#ifndef __stdlib_h__
#define __stdlib_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; Novell additions
=
=  stdlib.h
==============================================================================
*/
#include <stddef.h>

#define EXIT_FAILURE (-1)
#define EXIT_SUCCESS 0
#define RAND_MAX     32767

#include <pshpack1.h>

typedef struct
{
   int   quot;
   int   rem;
} div_t;

typedef struct
{
   long  quot;
   long  rem;
} ldiv_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

#if defined(__ECPP__) || defined(__ECC__)
# define div   __EPC_div
# define ldiv  __EPC_ldiv
#elif defined(__MWERKS__)
# define div   __CW_div
# define ldiv  __CW_ldiv
#endif

void            abort   ( void );
int             abs     ( int );
int             atexit  ( void (*)( void ) );
double          atof    ( const char * );
int             atoi    ( const char * );
long            atol    ( const char * );
int64_t         atoll   ( const char * );
void           *bsearch ( const void *, const void *, size_t, size_t,
                           int (*)( const void *, const void * ) );
void           *calloc  ( size_t, size_t );
div_t           div     ( int, int );
void            exit    ( int status );
void            free    ( void * );
char           *getenv  ( const char * );
long            labs    ( long );
ldiv_t          ldiv    ( long, long );
void           *malloc  ( size_t );
int             mblen   ( const char *, size_t );
size_t          mbstowcs( wchar_t *, const char *, size_t );
int             mbtowc  ( wchar_t *, const char *, size_t );
void            qsort   ( void *, size_t, size_t,
                           int (*)( const void *, const void * ) );
int             rand    ( void );
void           *realloc ( void *, size_t );
void            srand   ( unsigned int );
double          strtod  ( const char * restrict, char ** restrict );
long            strtol  ( const char * restrict, char ** restrict, int);
int64_t         strtoll ( const char * restrict, char ** restrict, int);
unsigned long   strtoul ( const char * restrict, char ** restrict, int);
uint64_t        strtoull( const char * restrict, char ** restrict, int);
int             system  ( const char * );
size_t          wcstombs( char * restrict, const wchar_t * restrict, size_t );
int             wctomb  ( char *, wchar_t );

#ifndef __ANSIC__
void           *alloca        ( size_t );
int             clearenv      ( void );
char           *getcmd        ( char * );
int             flushenv      ( const char *, int );
char           *getbsize      ( int *, long * );
unsigned long   htol          ( const char * );
char           *itoa          ( int, char *, int );
char           *itoab         ( unsigned long, char * );
char           *ltoa          ( long, char *, int );
char           *lltoa         ( int64_t, char *, int );
unsigned long  _lrotr         ( unsigned long, unsigned int );
unsigned long  _lrotl         ( unsigned long, unsigned int );
int             mkstemp       ( char * );
char           *mktemp        ( char * );
size_t          msize         ( void * );
int             multibyte     ( void );
int             mvalidrange   ( void *, size_t );
char           *nextmb        ( const char * );
char           *prevmb        ( const char * );
int             putenv        ( const char * );
int             rand_r        ( unsigned long * );
#define random  rand
unsigned int   _rotr          ( unsigned int, unsigned int );
unsigned int   _rotl          ( unsigned int, unsigned int );
uint8_t         rotl8         ( uint8_t, int );
uint16_t        rotl16        ( uint16_t, int );
uint32_t        rotl32        ( uint32_t, int );
uint64_t        rotl64        ( uint64_t, int );
uint8_t         rotr8         ( uint8_t, int );
uint16_t        rotr16        ( uint16_t, int );
uint32_t        rotr32        ( uint32_t, int );
uint64_t        rotr64        ( uint64_t, int );
int             setenv        ( const char *, const char *, int );
void            setkey        ( const char * );
#define srandom srand
size_t          stackavail    ( void );
void           *stackbase     ( void );
size_t          stackwatermark( void );
int             strtoi        ( const char *, int );
char           *truncmb       ( const char *, size_t );
char           *ultoa         ( unsigned long, char *, int );
char           *ulltoa        ( uint64_t , char *, int );
int             unsetenv      ( const char *name );
char           *utoa          ( unsigned int, char *, int );
int             valuemb       ( const char * );

/* atomic functions... */
void            atomic_add      ( unsigned long *addr, unsigned long value  );
unsigned long   atomic_bts      ( unsigned long *addr, unsigned long offset );
unsigned long   atomic_btr      ( unsigned long *addr, unsigned long offset );
void            atomic_dec      ( unsigned long *addr );
void            atomic_inc      ( unsigned long *addr );
void            atomic_sub      ( unsigned long *addr, unsigned long value );
unsigned long   atomic_xchg     ( unsigned long *addr, unsigned long value );
void            atomic_or       ( unsigned long *addr, unsigned long value );
void            atomic_xor      ( unsigned long *addr, unsigned long value );
void            atomic_and      ( unsigned long *addr, unsigned long value );
unsigned long   atomic_xchgadd  ( unsigned long *addr, unsigned long value );
unsigned long   atomic_cmpxchg  ( unsigned long *addr, unsigned long cmpvalue,
                                  unsigned long newvalue );
void            atomic64_inc    ( uint64_t *addr );
void            atomic64_dec    ( uint64_t *addr );
void            atomic64_add    ( uint64_t *addr, uint64_t value );
void            atomic64_sub    ( uint64_t *addr, uint64_t value );
uint64_t        atomic64_xchg   ( uint64_t *addr, uint64_t value );
uint64_t        atomic64_xchgadd( uint64_t *addr, uint64_t value );
uint64_t        atomic64_cmpxchg( uint64_t *addr, uint64_t cmpvalue,
                                  uint64_t newvalue );
#endif


/* compiler-specific implementations of alloca()... */
#if defined(__BORLANDC__)
void  *__alloca__( size_t );           /* from Borland static runtime */
#define alloca(s)    __alloca__(s)
#define _alloca(s)   alloca(s)

#elif defined(__ECC__) || defined(__ECPP__)
void  *__builtin_alloca( size_t );     /* Edinburgh Portable Compilers */
#define alloca       __builtin_alloca

#elif defined(__MWERKS__)              /* Metrowerks */
void  *_alloca( size_t );
#define alloca(s)    _alloca(s)

#elif defined(_MSC_VER)
void  *_alloca( size_t );              /* from Microsoft static runtime */
#define alloca(s)    _alloca(s)

#elif defined(__WATCOMC__)
void     *__alloca( size_t size );     /* Watcom in-lined assembly */
void     __push_eax( int __value );
#define ALLOCA_ALIGN(s) (((s) + (sizeof(int) - 1)) & ~(sizeof(int) - 1))
#define alloca(size) (__push_eax(stackavail()), __alloca(ALLOCA_ALIGN(size)))
#pragma aux __push_eax = 0x50                   \
   parm caller [eax];
#pragma aux __alloca =                          \
   0x59           /*       pop  ecx          */ \
   0x85 0xC0      /*       test eax, eax     */ \
   0x74 0x0F      /*       jz   short err    */ \
   0x8D 0x40 0x03 /*       lea  eax, [eax+3] */ \
   0x24 0xFC      /*       and  al, 0FCh     */ \
   0x3B 0xC1      /*       cmp  eax, ecx     */ \
   0x7F 0x06      /*       jg   short err    */ \
   0x2B 0xE0      /*       sub  esp, eax     */ \
   0x8B 0xC4      /*       mov  eax, esp     */ \
   0xEB 0x02      /*       jmp  done         */ \
   0x33 0xC0      /* err:  xor  eax, eax     */ \
                  /* done:                   */ \
   parm caller [eax] value[eax] modify [esp ecx];
#endif

#ifdef __cplusplus
}
#endif

#ifndef __cplusplus           /* because these may be done better in C++ */
# define max(a, b)            (((a) > (b)) ? (a) : (b))
# define min(a, b)            (((a) < (b)) ? (a) : (b))
# define inrange(lo, x, hi)   ((x) >= (lo) && (x) <= (hi))
# define mblen(s, n)          mbtowc((wchar_t *) 0, s, n)
   int (max)( int a, int b );
   int (min)( int a, int b );
#endif

#define MB_CUR_MAX   ((multibyte()) ? 2 : 1)

#endif
