#ifndef __string_h__
#define __string_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; ISO/IEC (POSIX) 9845:1996; Novell
=
=  string.h
==============================================================================
*/
#include <stddef.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for functions standard and nonstandard... */
void   *memchr     ( const void *, int, size_t );
int     memcmp     ( const void *, const void *, size_t );
void   *memcpy     ( void * restrict, const void * restrict, size_t );
void   *memmove    ( void *, const void *, size_t );
void   *memset     ( void *, int, size_t );
int     strcasecmp ( const char *, const char * );
char   *strcat     ( char * restrict, const char * restrict );
char   *strchr     ( const char *, int );
int     strcmp     ( const char *, const char * );
int     strcoll    ( const char *, const char * );
char   *strcpy     ( char * restrict, const char * restrict );
size_t  strcspn    ( const char *, const char * );
char   *strerror   ( int );
size_t  strlcat    ( char * restrict, const char * restrict, size_t );
size_t  strlcpy    ( char * restrict, const char * restrict, size_t );
size_t  strlen     ( const char * );
int     strncasecmp( const char *, const char *, size_t );
char   *strncat    ( char * restrict, const char * restrict, size_t );
int     strncmp    ( const char *, const char *, size_t );
int     strncoll   ( const char *, const char *, size_t );
char   *strncpy    ( char * restrict, const char * restrict, size_t );
int     strnicmp   ( const char *, const char *, size_t ); 
char   *strnset    ( char *, int, size_t ); 
char   *strpbrk    ( const char *, const char * );
char   *strrchr    ( const char *, int );
char   *strrev     ( char * ); 
char   *strset     ( char *, int ); 
size_t  strspn     ( const char *, const char * );
char   *strstr     ( const char *, const char * );
char   *strtok     ( char * restrict, const char * restrict );
size_t  strxfrm    ( char * restrict, const char * restrict, size_t );

#ifndef __ANSIC__
/* POSIX and other functions... */
char   *strtok_r   ( char * restrict, const char * restrict,
                           char ** restrict ); 

int     memicmp    ( const void *, const void *, size_t );
int     stricmp    ( const char *, const char * ); 
char   *strdup     ( const char * );
char   *strecpy    ( char *, const char * );
char   *strindex   ( const char *, const char * );
char   *strlist    ( char *, const char *, ... ); 
char   *strlwr     ( char * );
char   *strrindex  ( const char *, size_t, int );
char   *strwhich   ( char *, int, const char * );
char   *strupr     ( char * ); 
void    swab       ( const void *, void *, size_t ); 
void    swaw       ( const void *, void *, size_t );
void    ungettok   ( char * restrict, const char * restrict );
void    ungettok_r ( char * restrict, const char * restrict,
                           char ** restrict );

/* multibyte (double) interfaces for locale code page work... */
char   *Lstrbcpy   ( char * restrict, const char * restrict, size_t );
#define Lstrcat    strcat
char   *Lstrchr    ( const char *, const char * );
int     Lstrcmp    ( const char *, const char * );
int     Lstrcoll   ( const char *, const char * );
#define Lstrcpy    strcpy
size_t  Lstrcspn   ( const char *, const char * );
int     Lstricmp   ( const char *, const char * );
size_t  Lstrlen    ( const char * );
char   *Lstrlwr    ( char * ); 
char   *Lstrncat   ( char * restrict, const char * restrict, size_t );
int     Lstrncmp   ( const char *, const char *, size_t );
int     Lstrncoll  ( const char *, const char *, size_t );
char   *Lstrncpy   ( char * restrict, const char * restrict, size_t );
int     Lstrnicmp  ( const char *, const char *, size_t );
char   *Lstrpbrk   ( const char *, const char * );
char   *Lstrrchr   ( const char *, const char * );
char   *Lstrrev    ( char * );
size_t  Lstrspn    ( const char *, const char * );
char   *Lstrstr    ( const char *, const char * );
char   *Lstrtok_r  ( char * restrict, const char * restrict, char ** restrict );
char   *Lstrupr    ( char * ); 
size_t  Lstrxfrm   ( char * restrict, const char * restrict, size_t );

/* length-preceeded string manipulation... */
int     ASCIIZToLenStr   ( char *, const char * );
int     ASCIIZToMaxLenStr( char *, const char *, size_t );
char   *LenStrCat        ( char *, const char * );
int     LenStrCmp        ( const char *, const char * );
char   *LenStrCpy        ( char *, const char * );
int     LenToASCIIZStr   ( char *, const char * );
#endif

#ifdef __cplusplus
}
#endif


#ifndef __cplusplus
/* some macros to create Berkeley interfaces... */
# define bcmp(s1, s2, n) memcmp(s1, s2, n)
# define bcopy(s, d, n)  ((void) memmove(d, s, n))
# define bzero(d, n)     ((void) memset(d, 0, n))
# define index(sp, c)    strchr(sp, c)
# define rindex(sp, c)   strrchr(sp, c)
#else
extern "C++"
{
inline int         bcmp(const void *s1,const void *s2,size_t n)
                                                         {return memcmp(s1,s2,n);}
inline void        bcopy(const void *s,void *d, size_t n){memmove(d,s,n);}
inline void        bzero(void *d,size_t n)               {memset(d,0,n);}
inline const char *index(const char *s,int c)            {return strchr(s,c);}
inline char       *index(char *s,int c)                  {return strchr(s,c);}
inline const char *rindex(const char*s, int c)           {return strrchr(s,c);}
inline char       *rindex(char *s,int c)                 {return strrchr(s,c);}
}
#endif

#endif
