#ifndef __synch_h__
#define __synch_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): UNIX International
=
=  synch.h
===============================================================================
=  This header is not yet officially part of the NDK, but contains future info.
===============================================================================
*/
#include <sys/time.h>
#include <nks/synch.h>

/* synchronization types (field 'type')... */
#define USYNC_THREAD    0  /* known only to process    (supported)   */
#define USYNC_PROCESS   1  /* shared between processes (unsupported) */
#define USYNC_DESTROYED 2  /* deallocated object                     */


/* type definitions... */
typedef struct timespec timestruc_t;

typedef struct barrier
{
   long reserved[8];
} barrier_t;

typedef NXCond_t   cond_t;
typedef NXMutex_t  mutex_t;
typedef NXRwLock_t rwlock_t;
typedef NXSema_t   sema_t;


#ifdef __cplusplus
extern "C"
{
#endif

#define DEFAULTMUTEX {{0}, USYNC_THREAD } /* supported   on NetWare */
#define SHAREDMUTEX  {{0}, USYNC_PROCESS} /* unsupported on NetWare */
#define DEFAULTCV    {{0}, USYNC_THREAD } /* supported   on NetWare */
#define SHAREDCV     {{0}, USYNC_PROCESS} /* unsupported on NetWare */
#define DEFAULTSEMA  {{0}, USYNC_THREAD } /* supported   on NetWare */
#define SHAREDSEMA   {{0}, USYNC_PROCESS} /* unsupported on NetWare */

int   barrier_init   ( barrier_t *bp, int threads );
void  barrier_destroy( barrier_t *bp );
int   barrier_wait   ( barrier_t *bp );
int   barrier_inc    ( barrier_t *bp );
int   barrier_dec    ( barrier_t *bp );

int   cond_init      ( cond_t *cvp, int type, int arg );
int   cond_destroy   ( cond_t *cvp );
int   cond_broadcast ( cond_t *cvp );
int   cond_signal    ( cond_t *cvp );
int   cond_wait      ( cond_t *cvp, mutex_t *mp );
int   cond_timedwait ( cond_t *cvp, mutex_t *mp, timestruc_t *abstime );

int   mutex_init     ( mutex_t *mp, int type, void *arg );
int   mutex_destroy  ( mutex_t *mp );
int   mutex_lock     ( mutex_t *mp );
int   mutex_trylock  ( mutex_t *mp );
int   mutex_unlock   ( mutex_t *mp );

int   rwlock_init    ( rwlock_t *rwlp, int type, void *arg );
int   rwlock_destroy ( rwlock_t *rwlp );
int   rw_rdlock      ( rwlock_t *rwlp );
int   rw_wrlock      ( rwlock_t *rwlp );
int   rw_tryrdlock   ( rwlock_t *rwlp );
int   rw_trywrlock   ( rwlock_t *rwlp );
int   rw_unlock      ( rwlock_t *rwlp );

int   sema_init      ( sema_t *sp, unsigned int count, int type, void *arg );
int   sema_destroy   ( sema_t *sp );
int   sema_post      ( sema_t *sp );
int   sema_trywait   ( sema_t *sp );
int   sema_wait      ( sema_t *sp );

#ifdef __cplusplus
}
#endif

#endif
