#ifndef __sys_ipc_h__
#define __sys_ipc_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): System-V semaphore emulation
=
=  sys/ipc.h
==============================================================================
*/
#include <stddef.h>
#include <sys/types.h>

/* mode bits... */
#define IPC_CREAT    0x00000200  /* create entry if key doesn't exist */
#define IPC_EXCL     0x00000400  /* fail if key exists                */
#define IPC_NOWAIT   0x00000800  /* error if request must wait        */

/* keys... */
#define IPC_PRIVATE  (key_t) 0   /* private key                       */

/* control commands for semctl() and shmctl()... */
#define IPC_RMID     0           /* remove identifier.                */
#define IPC_SET      1           /* set 'struct ipc_perm' options     */
#define IPC_STAT     2           /* get 'struct ipc_perm' options     */
#define IPC_INFO     3           /* see ipcs                          */

#define SHM_LOCK     4           /* lock memory (unimplemented)       */
#define SHM_UNLOCK   5           /* unlock memory (unimplemented)     */


typedef int key_t;

struct ipc_perm
{
   uid_t  uid;                   /* owner                             */
   gid_t  gid;                   /* owner                             */
   uid_t  cuid;                  /* creator                           */
   gid_t  cgid;                  /* creator                           */
   mode_t mode;                  /* read/write permission             */
};

#ifdef __cplusplus
extern "C" {
#endif

key_t ftok( const char *path, int id );

#ifdef __cplusplus
}
#endif

#endif
