#ifndef __sys_mode_h__
#define __sys_mode_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): UNIX-inspired header
=
=  sys/mode.h
==============================================================================
*/

/* POSIX file types... */
#define S_IFMT       0xF000   /* type of file (mask for following)        */
#define S_IFIFO      0x1000   /* first-in/first-out (FIFO/pipe)           */
#define S_IFCHR      0x2000   /* character-special file (unused)          */
#define S_IFDIR      0x4000   /* directory                                */
#define S_IFBLK      0x6000   /* blocking device (unused)                 */
#define S_IFREG      0x8000   /* regular                                  */
#define S_IFLNK      0xA000   /* symbolic link (unused)                   */
#define S_IFSOCK     0xC000   /* Berkeley socket                          */

#define S_ISFIFO(m)  (((m) & S_IFMT) == S_IFIFO)  /* e.g.: FIFO/pipe      */
#define S_ISCHR(m)   (((m) & S_IFMT) == S_IFCHR)  /* e.g.: console        */
#define S_ISDIR(m)   (((m) & S_IFMT) == S_IFDIR)  /* e.g.: subdirectory   */
#define S_ISBLK(m)   (((m) & S_IFMT) == S_IFBLK)
#define S_ISREG(m)   (((m) & S_IFMT) == S_IFREG)
#define S_ISLNK(m)   (((m) & S_IFMT) == S_IFLNK)  /* should be FALSE      */
#define S_ISSOCK(m)  (((m) & S_IFMT) == S_IFSOCK) /* e.g.: socket         */

/* POSIX file modes: owner (user) permission... */
#define S_IRWXU      0x01C0
#define S_IRUSR      0x0100
#define S_IWUSR      0x0080
#define S_IXUSR      0x0040

#define S_IREAD      S_IRUSR
#define S_IWRITE     S_IWUSR
#define S_IEXEC      S_IXUSR

/* POSIX file modes: group permission... */
#define S_IRWXG      0x0038
#define S_IRGRP      0x0020
#define S_IWGRP      0x0010
#define S_IXGRP      0x0008

/* POSIX file modes: other permission... */
#define S_IRWXO      0x0007
#define S_IROTH      0x0004
#define S_IWOTH      0x0002
#define S_IXOTH      0x0001

/* POSIX setuid(), setgid(), and sticky... */
#define S_ISUID      0x0800
#define S_ISGID      0x0400
#define S_ISVTX      0x0200

/* NetWare-specific additions to the upper half of mode_t... */
#define M_A_RDONLY           0x00010000 /* read-only entry                */
#define M_A_HIDDEN           0x00020000 /* hidden entry                   */
#define M_A_SYSTEM           0x00040000 /* system entry                   */
#define M_A_SUBDIR           0x00080000 /* S_IFDIR                        */
#define M_A_ARCH             0x00100000 /* file has been archived         */
#define M_A_SHARE            0x00200000 /* file is shared                 */
#define M_A_TRANS            0x00400000 /* file transactions are tracked  */
#define M_A_IMMPURG          0x00800000 /* purge deleted file immediately */
#define M_A_NORENAM          0x01000000 /* inhibit renaming               */
#define M_A_NODELET          0x02000000 /* inhibit deletion               */
#define M_A_NOCOPY           0x04000000 /* inhibit copying                */
#define M_A_IMMCOMPRESS      0x08000000 /* compress immediately           */
#define M_A_FILE_COMPRESSED  0x10000000 /* file is compressed             */
#define M_A_DONT_COMPRESS    0x20000000 /* inhibit compression            */
#define M_A_CANT_COMPRESS    0x40000000 /* file cannot be compressed      */
#define M_A_BITS_SIGNIFICANT 0x80000000 /* these M_A_- bits are important */

#endif
