#ifndef __sys_param_h__
#define __sys_param_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Various UNICES, Novell header
=
=  sys/param.h
==============================================================================
*/
#include <limits.h>
#include <stdlib.h>
#include <sys/stat.h>

#define NBBY            CHAR_BIT
#define CANBSIZ         MAX_CANON
#define NCARGS          ARG_MAX
#define MAXPATHLEN      PATH_MAX
#define MAXHOSTNAMELEN  32

/*
** The following value is not really correct, but it is a value that has been
** used for a long time seems to be usable. Normally, NOFILE should not be used
** anyway.
*/
#define NOFILE          256

/* bit map related macros...  */
#define setbit(a,i)  ((a) [(i)/NBBY] |=   1 << ((i)%NBBY))
#define clrbit(a,i)  ((a) [(i)/NBBY] &= ~(1 << ((i)%NBBY)))
#define isset(a,i)   ((a) [(i)/NBBY] &   (1 << ((i)%NBBY)))
#define isclr(a,i)   (((a)[(i)/NBBY] &   (1 << ((i)%NBBY))) == 0)

/* macros for counting and rounding... */
#ifndef howmany
# define howmany(x, y)  (((x) + ((y) - 1)) / (y))
#endif
#define roundup(x, y)   ((((x) + ((y) - 1)) / (y)) * (y))
#define powerof2(x)     ((((x) - 1) & (x)) == 0)

/* supplementary macros for min/max...  */
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define MAX(a,b)        (((a) > (b)) ? (a) : (b))

/* unit of sys/stat.h `st_blocks'...  */
#define DEV_BSIZE       512

#endif
