#ifndef __sys_select_h__
#define __sys_select_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Berkeley-inspired Header
=
=  sys/select.h
==============================================================================
*/
#include <sys/types.h>
#include <sys/timeval.h>

/*
** Including file may make this bigger or smaller as long as the FD_- macros
** are faithfully used.
*/
#ifndef FD_SETSIZE
# define FD_SETSIZE     64
#endif

typedef struct fd_set
{
   int   fd_count;
   int   fd_array[FD_SETSIZE];
} fd_set;


#ifdef __cplusplus
extern "C" {
#endif

/* heterogeneous select calls (socket+pipe) unsupported on NetWare... */
int  pipe_select( int nfds, fd_set *readfds, fd_set *writefds,
        fd_set *exceptfds, const struct timeval *timeout );
int  select( int nfds, fd_set *readfds, fd_set *writefds,
        fd_set *exceptfds, const struct timeval *timeout );
int  ___fd_isset( int fd, fd_set *set );

#ifdef __cplusplus
}
#endif


#define FD_ISSET(fd, set)  ___fd_isset(fd, (fd_set *) (set))
#define FD_ZERO(set)       ((fd_set *) (set))->fd_count = 0

#define FD_SET(fd, set)                \
{                                      \
   register int   *slot, *end;         \
                                       \
   slot = (set)->fd_array;             \
   end  = slot + (set)->fd_count;      \
                                       \
   while (slot < end)                  \
   {                                   \
      if (*slot == fd)                 \
         break;                        \
                                       \
      slot++;                          \
   }                                   \
                                       \
   if (slot == end                     \
      && (set)->fd_count < FD_SETSIZE) \
   {                                   \
      *slot = fd;                      \
      (set)->fd_count++;               \
   }                                   \
}

# define FD_CLR(fd, set)               \
{                                      \
   register int   *slot, *end;         \
                                       \
   slot = (set)->fd_array;             \
   end  = slot + (set)->fd_count;      \
                                       \
   while (slot < end)                  \
   {                                   \
      if (*slot == fd)                 \
      {                                \
         *slot = *(--end);             \
         (set)->fd_count--;            \
         break;                        \
      }                                \
                                       \
      slot++;                          \
   }                                   \
}

#endif
