#ifndef __sys_sem_h__
#define __sys_sem_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): System-V semaphore emulation
=
=  sys/sem.h
==============================================================================
*/
#include <time.h>
#include <sys/ipc.h>


/* semctl() command definitions... */
#define GETNCNT   3            /* get semncnt                */
#define GETPID    4            /* get sempid                 */
#define GETVAL    5            /* get semval                 */
#define GETALL    6            /* get all semvals            */
#define __GETALL  66           /* reserved to implementation */
#define GETZCNT   7            /* get semzcnt                */
#define SETVAL    8            /* set semval                 */
#define SETALL    9            /* set all semvals            */

#define SEM_UNDO  0x00001000


struct sem
{
   ushort_t        semval;     /* semaphore text map address       */
   ushort_t        semadj;
   pid_t           sempid;     /* pid of last operation            */
   ushort_t        semncnt;    /* count awaiting (semval > cval)   */
   ushort_t        semzcnt;    /* count awaiting (semval == 0)     */
   void           *semptr;     /* semaphore on which this is based */
};

struct semid_ds
{
   struct ipc_perm sem_perm;
   struct sem     *sem_base;   /* pointer to first semaphore in set */
   unsigned short  sem_nsems;  /* number of semaphores in set       */
   time_t          sem_otime;  /* last semop time                   */
   time_t          sem_ctime;  /* last change time                  */
   void           *sem_ptr;    /* actual underlying semaphore       */
   int             sem_realkey;/* 'real' semaphore key              */
};

struct sembuf
{
   unsigned short  sem_num;    /* number    */
   short           sem_op;     /* operation */
   short           sem_flg;    /* flags     */
};

union semun
{
   int              val;
   struct semid_ds *buf;
   unsigned short  *array;
};

#ifdef __cplusplus
extern "C" {
#endif

int semctl( int semid, int semnum, int cmd, ... );
int semget( key_t key, int nsems, int semflag );
int semop ( int semid, struct sembuf *sops, size_t nsops );

#ifdef __cplusplus
}
#endif

#endif
