#ifndef __sys_socket_h__
#define __sys_socket_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Berkeley-inspired Header
=
=  sys/socket.h
==============================================================================
*/
#include <stddef.h>
#include <sys/uio.h>
#include <sys/types.h>

#if   defined(__novsock2_h__)
# error sys/socket.h is incompatible with novsock2.h!
#elif defined(__winsock2_h_)
# error sys/socket.h is incompatible with winsock2.h!
#endif

/* socket types... */
#define SOCK_NULL      0       /* just NW OFSD, no socket                */
#define SOCK_STREAM    1       /* stream socket                          */
#define SOCK_DGRAM     2       /* datagram socket                        */
#define SOCK_RAW       3       /* raw-protocol interface                 */
#define SOCK_RDM       4       /* reliably-delivered message             */
#define SOCK_SEQPACKET 5       /* sequenced packet stream                */

/* option flags per-socket... */
#define SO_DEBUG       0x0001  /* turn on debugging info recording       */
#define SO_ACCEPTCONN  0x0002  /* socket has had listen()                */
#define SO_REUSEADDR   0x0004  /* allow local address reuse              */
#define SO_KEEPALIVE   0x0008  /* keep connections alive                 */
#define SO_DONTROUTE   0x0010  /* just use interface addresses           */
#define SO_BROADCAST   0x0020  /* permit sending of broadcast msgs       */
#define SO_USELOOPBACK 0x0040  /* bypass hardware when possible          */
#define SO_LINGER      0x0080  /* linger on close if data present        */
#define SO_OOBINLINE   0x0100  /* leave received OOB data in line        */
#define SO_DONTLINGER  (~SO_LINGER)

/* additional options, not kept in so_options... */
#define SO_SNDBUF      0x1001  /* send buffer size                       */
#define SO_RCVBUF      0x1002  /* receive buffer size                    */
#define SO_SNDLOWAT    0x1003  /* send low-water mark                    */
#define SO_RCVLOWAT    0x1004  /* receive low-water mark                 */
#define SO_SNDTIMEO    0x1005  /* send timeout                           */
#define SO_RCVTIMEO    0x1006  /* receive timeout                        */
#define SO_ERROR       0x1007  /* get error status and clear             */
#define SO_TYPE        0x1008  /* get socket type                        */

/* additional option to be used with level IPPROTO_TCP... */
#define TCP_NODELAY    1       /* turn off the Nagle delay algorithm     */

/* level number for get/setsockopt() to apply to socket itself... */
#define SOL_SOCKET     0xFFFF  /* options for socket level               */

/* address families */
#define AF_UNSPEC       0      /* unspecified                            */
#define AF_UNIX         1      /* local to host (pipes, portals)         */
#define AF_INET         2      /* internetwork: UDP, TCP, etc.           */
#define AF_IMPLINK      3      /* ARPANet imp addresses                  */
#define AF_PUP          4      /* PUP protocols: e.g. BSP                */
#define AF_CHAOS        5      /* MIT CHAOS protocols                    */
#define AF_NS           6      /* Xerox NS protocols                     */
#define AF_IPX          AF_NS  /* IPX protocols: IPX, SPX, etc.          */
#define AF_ISO          7      /* ISO protocols                          */
#define AF_OSI          AF_ISO /* OSI is ISO                             */
#define AF_ECMA         8      /* European computer manufacturers        */
#define AF_DATAKIT      9      /* datakit protocols                      */
#define AF_CCITT        10     /* CCITT protocols, X.25 etc              */
#define AF_SNA          11     /* IBM SNA                                */
#define AF_DECnet       12     /* DECnet                                 */
#define AF_DLI          13     /* Direct data link interface             */
#define AF_LAT          14     /* LAT                                    */
#define AF_HYLINK       15     /* NSC Hyperchannel                       */
#define AF_APPLETALK    16     /* AppleTalk                              */
#define AF_NETBIOS      17     /* NetBios-style addresses                */
#define AF_VOICEVIEW    18     /* VoiceView                              */
#define AF_FIREFOX      19     /* Protocols from Firefox                 */
#define AF_UNKNOWN1     20     /* Somebody is using this!                */
#define AF_BAN          21     /* Banyan                                 */
#define AF_ATM          22     /* Native ATM Services                    */
#define AF_CLUSTER      24     /* Microsoft Wolfpack                     */
#define AF_12844        25     /* IEEE 1284.4 WG AF                      */
#define AF_IRDA         26     /* IrDA                                   */
#define AF_INET6        28     /* Internetwork Version 6                 */
#define AF_MAX          29

/* protocol families, same as address families for now... */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK
#define PF_PUP          AF_PUP
#define PF_CHAOS        AF_CHAOS
#define PF_NS           AF_NS
#define PF_IPX          AF_IPX
#define PF_ISO          AF_ISO
#define PF_OSI          AF_OSI
#define PF_ECMA         AF_ECMA
#define PF_DATAKIT      AF_DATAKIT
#define PF_CCITT        AF_CCITT
#define PF_SNA          AF_SNA
#define PF_DECnet       AF_DECnet
#define PF_DLI          AF_DLI
#define PF_LAT          AF_LAT
#define PF_HYLINK       AF_HYLINK
#define PF_APPLETALK    AF_APPLETALK
#define PF_VOICEVIEW    AF_VOICEVIEW
#define PF_FIREFOX      AF_FIREFOX
#define PF_UNKNOWN1     AF_UNKNOWN1
#define PF_BAN          AF_BAN
#define PF_ATM          AF_ATM
#define PF_INET6        AF_INET6
#define PF_MAX          AF_MAX

#define TSTPROTO_NPIPE  0       /* test protocol "numbered pipe"         */

#define SOMAXCONN       5       /* max queue length specifiable by listen*/

#define MSG_OOB         0x01    /* process out-of-band data              */
#define MSG_PEEK        0x02    /* peek at incoming message              */
#define MSG_DONTROUTE   0x04    /* send without using routing tables     */
#define MSG_MAXIOVLEN   0       /* (unlimited)                           */

/* values for shutdown() 'how'... */
#define SHUT_RD        0        /* disable further recv operations       */
#define SHUT_WR        1        /* send operations                       */ 
#define SHUT_RDWR      2        /* both recv and send operations         */

#include <pshpack1.h>

/* structure used for manipulating linger option... */
struct linger
{
   int            l_onoff;      /* option on/off                         */
   int            l_linger;     /* linger time                           */
};

/* structure used by kernel to store most addresses... */
struct sockaddr
{
   unsigned short sa_family;    /* address family                        */
   char           sa_data[14];  /* up to 14 bytes of direct address      */
};

struct sockproto                /* used by kernel to pass protocol info. */
{                               /*    in raw sockets                     */
   unsigned short sp_family;    /* address family                        */
   unsigned short sp_protocol;  /* protocol                              */
};

struct msghdr
{
   caddr_t        msg_name;     /* optional address                      */
   int            msg_namelen;  /* size of address                       */
   struct iovec   *msg_iov;     /* scatter/gather array                  */
   int            msg_iovlen;   /* count of elements in msg_iov          */
   caddr_t        msg_accrights;/* access rights sent/received           */
   int            msg_accrightslen;
};

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

int      accept(int s, struct sockaddr *addr, size_t *len);
int      bind(int s, const struct sockaddr *addr, size_t);
int      connect(int s, const struct sockaddr *addr, size_t len);
int      getpeername(int s, struct sockaddr *addr, size_t *len);
int      getsockname(int s, struct sockaddr *addr, size_t *len);
int      getsockopt(int s, int level, int optname, void * optval,
            size_t *optlen);
int      listen(int s, int backlog);
ssize_t  recv(int s, void *buf, size_t len, int flags);
ssize_t  recvfrom(int s, void *buf, size_t len, int flags,
            struct sockaddr *from, size_t *fromlen);
ssize_t  recvmsg(int s, struct msghdr *msg, int flags);
ssize_t  send(int s, const void *msg, size_t len, int flags);
ssize_t  sendmsg(int s, const struct msghdr *, int flags);
ssize_t  sendto(int s, const void *msg, size_t len, int flags,
            const struct sockaddr *to, size_t tolen);
int      setsockopt(int s, int level, int optname, const void * optval,
            size_t optlen);
int      shutdown(int s, int how );
int      socket(int domain, int type, int protocol);

#ifdef __cplusplus
}
#endif

#endif
