#ifndef __sys_stat_h__
#define __sys_stat_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  sys/stat.h
==============================================================================
*/
#include <time.h>
#include <stddef.h>
#include <sys/mode.h>
#include <sys/time.h>

#include <pshpack1.h>

struct stat
{
   uint32_t   st_userspec;    /* untouched by stat()                     */
   uint32_t   st_flags;       /* flags for this entry                    */
   mode_t     st_mode;        /* emulated file mode                      */
   uint32_t   st_spare1;
   uint64_t   st_gen;         /* generation number of inode              */
   ino_t      st_ino;         /* directory entry number                  */
   dev_t      st_dev;         /* volume number                           */
   dev_t      st_rdev;        /* device type (always 0)                  */
   off64_t    st_size;        /* total file size                         */
   uint64_t   st_spare2;
   blkcnt_t   st_blocks;      /* count of blocks allocated to file       */
   blksize_t  st_blksize;     /* block size for allocation--files only   */
   nlink_t    st_nlink;       /* count of hard links (always 1)          */
   uint32_t   st_spare3[3];
   uid_t      st_uid;         /* owner (object) identity                 */
   gid_t      st_gid;         /* group-id (always 0)                     */
   uid_t      st_bid;         /* identity of last archiver               */
   uid_t      st_mid;         /* identity of last updator                */
   timespec_t st_atim;        /* last access date--files only            */
   timespec_t st_mtim;        /* last modify date and time               */
   timespec_t st_ctim;        /* last file attributes modification       */
   timespec_t st_btim;        /* last archived date and time             */

                              /* NOT returned by stat() or fstat()...    */
   uint32_t   st_rights;      /* NetWare rights                          */
   uint32_t   st_spare4[3];
   char       st_name[255+1]; /* object name as if from readdir()        */
   uint32_t   st_spare5[20];
};                            /* sizeof(struct stat) == 0x200 (512.)     */

#ifdef _POSIX_SOURCE          /* ISO/IEC 9945 does not use extended time */
# define st_atime st_atim.tv_sec
# define st_mtime st_mtim.tv_sec
# define st_ctime st_ctim.tv_sec
# define st_btime st_btim.tv_sec
#else
# define st_atime st_atim
# define st_mtime st_mtim
# define st_ctime st_ctim
# define st_btime st_btim
#endif

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

int    chmod   ( const char *path,     mode_t mode      );
int    fchmod  ( int fildes,           mode_t mode      );
int    fstat   ( int fildes,           struct stat *buf );
int    realname( const char *pathname, char *name       );
int    mkdir   ( const char *pathname, mode_t mode      );
int    mkfifo  ( const char *pathname, mode_t mode      );
int    stat    ( const char *path,     struct stat *buf );
mode_t umask   (                       mode_t cmask     );

#ifdef __cplusplus
}
#endif

#define stat64  stat       /* same structure and function do both   */
#define fstat64 fstat      /* same function does both               */


#endif
