#ifndef __sys_time_h__
#define __sys_time_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Berkeley Header
=
=  sys/time.h
==============================================================================
*/
#include <time.h>
#include <sys/timeval.h>

#define SEC       1
#define MILLISEC  1000
#define MICROSEC  1000000
#define NANOSEC   1000000000

#define __CLOCK_REALTIME0  0  /* wall clock, bound to LWP */
#define CLOCK_VIRTUAL      1  /* user CPU usage clock */
#define CLOCK_PROF         2  /* user and system CPU usage clock */
#define __CLOCK_REALTIME3  3  /* wall clock, not bound */
#define  CLOCK_REALTIME    __CLOCK_REALTIME3

#define TIMER_RELTIME      0x0/* set timer relative */
#define TIMER_ABSTIME      0x1/* set timer absolute */

#include <pshpack1.h>

typedef struct timespec       /* time expressed in seconds and nanoseconds */
{
   time_t   tv_sec;           /* seconds */
   long     tv_nsec;          /* and nanoseconds */
} timespec_t, timestrc_t;

#include <poppack.h>


#ifdef __cplusplus
extern "C"
{
#endif

int gettimeofday( struct timeval *tp, struct timezone *tpz );
int settimeofday( struct timeval *tp, struct timezone *tpz );

#ifdef __cplusplus
}
#endif

#endif
