#ifndef __sys_times_h__
#define __sys_times_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9945:1996
=
=  sys/times.h
==============================================================================
*/
#include <time.h>

struct tms                 /* describes CPU time used by process, children */
{
   clock_t  tms_utime;     /* user CPU time                                */
   clock_t  tms_stime;     /* system CPU time (identical to 'tms_utime')   */
   clock_t  tms_cutime;    /* unimplemented                                */
   clock_t  tms_cstime;    /* unimplemented                                */
};

struct timezone            /* returned by gettimeofday()                   */
{
   time_t tz_secondswest;	/* seconds west of UTC                          */
   int    tz_minuteswest;  /* minutes west of UTC (GMT)                    */
   int    tz_dsttime;      /* nonzero if DST is ever in effect	            */
};

#ifdef __cplusplus
extern "C"
{
#endif

/*
** Normally this functions fills struct tms with several time values. Most of
** the time it is very important to have only the return value, that is the
** realtime that has been elapsed.
*/
clock_t  times( struct tms *__buffer );

#ifdef __cplusplus
}
#endif

#endif
