#ifndef __sys_timeval_h__
#define __sys_timeval_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): BSD 4.3, SVID 3, UNIX 95 and UNIX 98
=              see http://www.unix-systems.org)
=
=  sys/timeval.h
==============================================================================
*/
#include <sys/times.h>

#include <pshpack1.h>

/* this structure is returned by gettimeofday() and used in select()... */
struct timeval
{
   long  tv_sec;
   long  tv_usec;
};

#include <poppack.h>

/* operations on struct timeval; note timercmp() does not work for >= or <= */
#define timerisset(tvp)           ((tvp)->tv_sec || (tvp)->tv_usec)
#define timerclear(tvp)           (tvp)->tv_sec = (tvp)->tv_usec = 0
#define timercmp(tvp, uvp, _CMP_) (    (tvp)->tv_sec  _CMP_ (uvp)->tv_sec   \
											  || ((tvp)->tv_sec   ==   (uvp)->tv_sec   \
                                    && (tvp)->tv_usec _CMP_ (uvp)->tv_usec) \
                                  )

#endif
