#ifndef __sys_ttydefaults_h__
#define __sys_ttydefaults_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Berkeley Header
=
=  sys/ttydefaults.h
==============================================================================
=  Copyright (c) 1982, 1986, 1993 Regents of the University of California. All
=  rights reserved. The Berkeley software License Agreement specifies the
=  terms and conditions for redistribution.
==============================================================================
*/
/* system wide defaults for terminal state, mostly for porting help */

/* defaults on "first" open... */
#define TTYDEF_IFLAG  (BRKINT | ISTRIP | ICRNL | IMAXBEL | IXON | IXANY)
#define TTYDEF_OFLAG  (OPOST | ONLCR | XTABS)
#define TTYDEF_LFLAG  (ECHO | ICANON | ISIG | IEXTEN | ECHOE|ECHOKE|ECHOCTL)
#define TTYDEF_CFLAG  (CREAD | CS7 | PARENB | HUPCL)
#define TTYDEF_SPEED  (B9600)

/* control character defaults... */
#define CTRL(x)  (x&037)
#define CEOF     CTRL('d')

#ifdef _POSIX_VDISABLE
# define CEOL    _POSIX_VDISABLE
#else
# define CEOL    '\0'              /* XXX avoid _POSIX_VDISABLE */
#endif

#define CERASE   0177
#define CINTR    CTRL('c')

#ifdef _POSIX_VDISABLE
# define CSTATUS  _POSIX_VDISABLE
#else
# define CSTATUS '\0'              /* XXX avoid _POSIX_VDISABLE */
#endif

#define CKILL    CTRL('u')
#define CMIN     1
#define CQUIT    034               /* FS, ^\ */
#define CSUSP    CTRL('z')
#define CTIME    0
#define CDSUSP   CTRL('y')
#define CSTART   CTRL('q')
#define CSTOP    CTRL('s')
#define CLNEXT   CTRL('v')
#define CDISCARD CTRL('o')
#define CWERASE  CTRL('w')
#define CREPRINT CTRL('r')
#define CEOT     CEOF

/* compatibility: */
#define CBRK     CEOL
#define CRPRNT   CREPRINT
#define CFLUSH   CDISCARD

#endif

#ifdef TTYDEFCHARS
/*
** Define TTYDEFCHARS to include an array of default control characters.
** This operates somewhat independently of sys/ttydefaults.h.
*/
   cc_t  ttydefchars[NCCS] =
   {
      CEOF, CEOL, CEOL, CERASE, CWERASE, CKILL, CREPRINT,
      _POSIX_VDISABLE, CINTR, CQUIT, CSUSP, CDSUSP, CSTART, CSTOP, CLNEXT,
      CDISCARD, CMIN, CTIME, CSTATUS, _POSIX_VDISABLE
   };
# undef TTYDEFCHARS

#endif
