#ifndef __sys_types_h__
#define __sys_types_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9845:1996, Berkeley
=
=  sys/types.h
==============================================================================
*/
#include <stddef.h>

#ifndef _UCHAR_T
# define _UCHAR_T
typedef unsigned char   uchar_t;
#endif

#ifndef _USHORT_T
# define _USHORT_T
typedef unsigned short  ushort_t;
#endif

#ifndef _UINT_T
# define _UINT_T
typedef unsigned int    uint_t;
#endif

#ifndef _ULONG_T
# define _ULONG_T
typedef unsigned long   ulong_t;
#endif

#ifndef _U_CHAR
# define _U_CHAR
typedef unsigned char   u_char;
#endif

#ifndef _U_SHORT
# define _U_SHORT
typedef unsigned short  u_short;
#endif

#ifndef _U_INT
# define _U_INT
typedef unsigned int    u_int;
#endif

#ifndef _U_LONG 
# define _U_LONG 
typedef unsigned long   u_long;
#endif

#ifndef _CADDR_T
# define _CADDR_T
typedef char            *caddr_t;
#endif

#ifndef __BIT_TYPES_DEFINED__
# define __BIT_TYPES_DEFINED__
typedef uint8_t         u_int8_t;
typedef uint16_t        u_int16_t;
typedef uint32_t        u_int32_t;
typedef uint64_t        u_int64_t;
#endif


#ifdef __cplusplus
extern "C"
{
#endif

pid_t getpid ( void );
pid_t getppid( void );
uid_t getuid ( void );
uid_t geteuid( void );
gid_t getgid ( void );
gid_t getegid( void );
int   setuid ( uid_t uid );
int   setgid ( gid_t gid );
pid_t getpgrp( void );
pid_t setsid ( void );
int   setpgid( pid_t pid, pid_t pgid );

#ifdef __cplusplus
}
#endif

#endif
