#ifndef __sys_utsname_h__
#define __sys_utsname_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (POSIX) 9945:1996, Novell additions
=
=  sys/utsname.h
===============================================================================
*/
#include <time.h>
#include <stddef.h>


#include <pshpack1.h>

struct utsname
{
   int    userspec;             /* untouched by uname()                      */

                                /* Novell fields --------------------------- */
                                /*    Standard C Library implementation:     */
   int    libmajor;             /*                    major version number   */
   int    libminor;             /*                    minor version number   */
   int    librevision;          /*                    revision number        */
                                /*    NetWare OS implementation:             */
   int    major;                /*                    major version number   */
   int    minor;                /*                    minor version number   */
   int    revision;             /*                    revision number        */
   int    reserved1;
                                /*    NetWare product distribution:          */
   int    servicepack;          /*                    service pack number    */
   int    netware_major;        /*                    major version number   */
   int    netware_minor;        /*                    minor version number   */
   int    netware_revision;     /*                    revision number        */

   char   servername     [ 64]; /*    NetWare host/file server name          */
   char   clustername    [ 64]; /*    NetWare cluster node name              */

   char   languagename   [ 32]; /*    host's current language name           */
   char   altlanguagename[ 32]; /*    NLM's current language name            */

   int    languageid;           /*    host's current language identity       */
   int    altlanguageid;        /*    when NLM's language different from OS  */
   int    codepage;             /*    code page host's display               */
   int    reserved2;

   int    reserved3      [  4];

                                /* NLM-specific information                  */
   void  *nlmmodule;            /*    NetWare-loadable module (NLM) handle   */
                                /*    module's implementation:               */
   int    nlmmajor;             /*                    major version number   */
   int    nlmminor;             /*                    minor version number   */
   int    nlmrevision;          /*                    revision number        */

   time_t nlmtimer;             /*    module's date and time stamp in UTC    */
   char  *nlmcommandline;       /*    command line at invocation             */
   size_t nlmmessagecount;      /*    count of module's messages             */
   char **nlmmessagetable;      /*    pointer to module's messages           */

   char   nlmname        [ 36]; /*    name of module                         */
   char   nlmloadpath    [256]; /*    load path of module                    */
   char   nlmcopyright   [256]; /*    copyright string                       */
   char   nlmdescription [128]; /*    description string                     */
   int    nlmloadflags;         /*    load flags                             */
   int    reserved4;

                                /* POSIX fields ---------------------------- */
   char   release        [ 16]; /* release level of this implementation      */
   char   version        [ 16]; /* version level of this release             */

   char   sysname        [ 16]; /* name of [...] the operating system        */
   char   machine        [ 16]; /* name of the hardware type [...] running   */
   char   nodename       [ 16]; /* name of this node within [...] network    */

                                /* Novell fields (2nd set) ----------------- */
   char   treename       [ 96]; /* name of NDS tree in which this node found */

                                /* NLM-specific information                  */
   void  *codeoffset;           /*    starting address of code               */
	size_t codelength;           /*    length of code segment                 */
   void  *dataoffset;           /*    starting address of global/static data */
	size_t datalength;           /*    length of global/static data           */

	int    reserved5      [ 28]; /* for future expansion                      */
};

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif

/* prototype... */
int   uname( struct utsname *name );

#ifdef __cplusplus
}
#endif

#endif
