#ifndef __sys_wait_h__
#define __sys_wait_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (POSIX) 9945:1996
=
=  sys/wait.h
==============================================================================
*/
#include <sys/types.h>

#define WNOHANG             1
#define WUNTRACED           2 /* currently unsupported */

#define WIFEXITED(status)   ((status) & 0x80000000 == 0)
#define WEXITSTATUS(status) ((status) & 0x000000FF)


#define WIFSIGNALED(status) 0 /* currently unsupported */
#define WIFTERMSIG(status)  0 /* ibid */
#define WIFSTOPPED(status)  0 /* ibid */
#define WSTOPSIG(status)    0 /* ibid */

#ifdef __cplusplus
extern "C" {
#endif

pid_t wait   ( int *stat_loc );
pid_t waitpid( pid_t pid, int *stat_loc, int options );

#ifdef __cplusplus
}
#endif

#endif
