#ifndef __syslog_h__
#define __syslog_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): XSI Extension
=
=  syslog.h
==============================================================================
*/
#include <stddef.h>

/* log options for openlog()... */
#define LOG_PID     0x00000001  /* log the process ID with each message */
#define LOG_CONS    0x00000002  /* log to the system console on error   */
#define LOG_NDELAY  0x00000004  /* connect to syslog daemon immediately */
#define LOG_ODELAY  0x00000008  /* delay open until syslog() is called  */
#define LOG_NOWAIT  0x00000010  /* do not wait for child processes      */

/* message facilities for openlog()... */
#define LOG_KERN    0x00000001  /* generated by system */
#define LOG_USER    0x00000002  /* generated by a process               */
#define LOG_MAIL    0x00000004  /* generated by mail system             */
#define LOG_NEWS    0x00000008  /* generated by news system             */
#define LOG_UUCP    0x00000010  /* generated by UUCP system             */
#define LOG_DAEMON  0x00000020  /* generated by daemon                  */
#define LOG_AUTH    0x00000040  /* generated by auth. daemon            */
#define LOG_CRON    0x00000080  /* generated by clock daemon            */
#define LOG_LPR     0x00000100  /* generated by printer system          */
#define LOG_LOCAL0  0x00000200  /* local use                            */
#define LOG_LOCAL1  0x00000400  /* local use                            */
#define LOG_LOCAL2  0x00000800  /* local use                            */
#define LOG_LOCAL3  0x00001000  /* local use                            */
#define LOG_LOCAL4  0x00002000  /* local use                            */
#define LOG_LOCAL5  0x00004000  /* local use                            */
#define LOG_LOCAL6  0x00008000  /* local use                            */
#define LOG_LOCAL7  0x00010000  /* local use                            */
#define LOG_UNUSED1 0x00020000  /* unused                               */
#define LOG_UNUSED2 0x00040000  /* unused                               */
#define LOG_UNUSED3 0x00080000  /* unused                               */
#define LOG_UNUSED4 0x00100000  /* unused                               */
#define LOG_UNUSED5 0x00200000  /* unused                               */
#define LOG_UNUSED6 0x00400000  /* unused                               */
#define LOG_UNUSED7 0x00800000  /* unused                               */

/* for constructing 'maskpri' for setlogmask()... */
#define LOG_MASK(p) (p)

/* values for priority argument of syslog()... */
#define LOG_EMERG   0x01000000 /* panic reported to all processes       */
#define LOG_ALERT   0x02000000 /* condition to correct immediately      */
#define LOG_CRIT    0x04000000 /* critical condition                    */
#define LOG_ERR     0x08000000 /* error message                         */
#define LOG_WARNING 0x10000000 /* warning message                       */
#define LOG_NOTICE  0x20000000 /* condition requiring special handling  */
#define LOG_INFO    0x40000000 /* general information message           */
#define LOG_DEBUG   0x80000000 /* message useful for debugging programs */


/* with no filename argument, syslogd.nlm uses this configuration file: */
#define P_cfgfile    "sys:/etc/syslog.conf"


#ifdef __cplusplus
extern "C" {
#endif

void  closelog  ( void );                      /* (primarily aesthetic) */
void  openlog   ( const char *ident, int logopt, int facility );
int   setlogmask( int maskpri );
void  syslog    ( int priority, const char *message, ... );

#ifdef __cplusplus
}
#endif

#endif
