#ifndef __termios_h__
#define __termios_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (POSIX) 9845:1996
=
=  termios.h
==============================================================================
*/
#include <stddef.h>

/*
** Note: This is a very primitive and narrow adaptation of POSIX termios.h.
** Most of what is in this file is for completeness and to avoid locking
** termios.h interfaces off from advancing progressively as needed.
*/
#define NCCS    32

#define INTR    0x03  /* ^C */
#define QUIT    0x04  /* ^D */
#define SUSP    0x1A  /* ^Z */

#define ECHO    0x01  /* currently unsupported                         */
#define ECHOE   0x02  /* currently unsupported                         */
#define ECHOK   0x04  /* currently unsupported                         */
#define ECHONL  0x08  /* currently unsupported                         */
#define ICANON  0x10  /* currently unsupported                         */
#define IEXTEN  0x20  /* currently unsupported                         */
#define ISIG    0x40  /* check against INTR, QUIT and SUSP (default)   */
#define NOFLSH  0x80  /* currently unsupported                         */

/* c_iflag bits... */
#define IGNBRK  0000001
#define BRKINT  0000002
#define IGNPAR  0000004
#define PARMRK  0000010
#define INPCK   0000020
#define ISTRIP  0000040
#define INLCR   0000100
#define IGNCR   0000200
#define ICRNL   0000400
#define IUCLC   0001000
#define IXON    0002000
#define IXANY   0004000
#define IXOFF   0010000
#define IMAXBEL 0020000

#define CSIZE   0000060
#define   CS5   0000000
#define   CS6   0000020
#define   CS7   0000040
#define   CS8   0000060
#define CSTOPB  0000100
#define CREAD   0000200
#define PARENB  0000400
#define PARODD  0001000
#define HUPCL   0002000
#define CLOCAL  0004000

/* 'c_cc' control characters... */
#define VINTR   1     /* ^C                                            */
#define VQUIT   2     /* ^\   (unsupported)                            */
#define VERASE  3     /* del  (unsupported)                            */
#define VEOF    4     /* ^D                                            */
#define VKILL   5     /* @    (unsupported)                            */
#define VTIME   6     /* currently unsupported                         */
#define VMIN    7     /* currently unsupported                         */
#define VSTART  8     /* ^q   (unsupported)                            */
#define VSTOP   9     /* ^s   (unsupported)                            */
#define VSUSP   10    /* ^z                                            */
#define VEOL    11    /* '\0' (unsupported)                            */

/* 'optional_actions' causes action to be effectuated when: */
#define TCSANOW   1   /* immediately                                   */
#define TCSADRAIN 2   /* output done                     (unsupported) */
#define TCSAFLUSH 3   /* output done and input discarded (unsupported) */

typedef unsigned long tcflag_t;
typedef unsigned char cc_t;

typedef enum
{
   B0     = 0,
   B50    = 50,
   B75    = 75,
   B110   = 110,
   B134   = 134,
   B150   = 150,
   B200   = 200,
   B300   = 300,
   B600   = 600,
   B1200  = 1200,
   B1800  = 1800,
   B2400  = 2400,
   B4800  = 4800,
   B9600  = 9600,
   B19200 = 19200,
   B38400 = 38400
} speed_t;

/* ioctl() control packet... */
struct termios
{
   tcflag_t c_iflag;   /* input modes     --currently unused         */
   tcflag_t c_oflag;   /* output modes    --currently unused         */
   tcflag_t c_cflag;   /* control modes   --currently unused         */
   tcflag_t c_lflag;   /* local modes     --ISIG currently supported */
   speed_t  c_ispeed;  /* input speed     --currently unused         */
   speed_t  c_ospeed;  /* output speed    --currently unused         */
   cc_t     c_line;    /* line discipline --currently unused         */
   unsigned c_spare1;
   cc_t     c_cc[NCCS];/* control chars   --currently used           */
   unsigned c_spare2;
   unsigned c_spare3;
   unsigned c_spare4;
   unsigned c_spare5;
};


#ifdef __cplusplus
extern "C"
{
#endif

/* POSIX-defined functions... */
int tcgetattr( int fildes, struct termios *tp );
int tcsetattr( int fildes, int optional_actions, const struct termios *tp );

#ifdef __cplusplus
}
#endif

#endif
