#ifndef __thread_h__
#define __thread_h__
/*=============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): UNIX International
=
=  thread.h
===============================================================================
=  This header is not yet officially part of the NDK, but contains future info.
===============================================================================
*/
#include <synch.h>
#include <signal.h>
#include <stddef.h>
#include <nks/thread.h>

#define THR_BOUND       NX_THR_BIND_CONTEXT
#define THR_DETACHED    NX_THR_DETACHED
#define THR_NEW_LWP     0xFFFFFFFE
#define THR_SUSPENDED   NX_THR_SUSPENDED
#define THR_DAEMON      NX_THR_DAEMON

/* type definitions... */
typedef NXThreadId_t     thread_t;
typedef NXKey_t          thread_key_t;


#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes... */
int      thr_create        (void *stack_based, size_t stack_size,
                              void (*start_routine)(void *), void *arg,
                              long flags, thread_t *new_thr);
thread_t thr_self          (void);
int      thr_suspend       (thread_t thr);
int      thr_continue      (thread_t thr);
int      thr_join          (thread_t wait_for, thread_t *dead, void **status);
void     thr_yield         (void);
void     thr_exit          (void *status);

size_t   thr_minstack      (void);

int      thr_kill          (thread_t thr, int sig);
int      thr_sigsetmask    (int how, const sigset_t *set, sigset_t *oset);

int      thr_getconcurrency(void);
int      thr_setconcurrency(int new_level);
int      thr_getprio       (thread_t thr, int *pri);
int      thr_setprio       (thread_t thr, int pri);

int      thr_keycreate     (thread_key_t *key, void (*destructor)(void *value));
int      thr_getspecific   (thread_key_t key, void **value);
int      thr_setspecific   (thread_key_t key, void *value);

#ifdef __cplusplus
}
#endif

#define thr_minstack()  16384

#endif
