#ifndef __time_h__
#define __time_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (ANSI) 9899:1990; ISO/IEC (POSIX) 9845:1996; Novell
=
=  time.h
==============================================================================
*/
#include <stddef.h>


#include <pshpack1.h>

#ifndef _CLOCK_T
# define _CLOCK_T
typedef unsigned long   clock_t;
#endif

#ifndef _TIME_T
# define _TIME_T
typedef long            time_t;
#endif

struct tm                       /* ANSI/ISO 'broken-down' time               */
{
   int            tm_sec;       /* seconds after the minute [0..59]          */
   int            tm_min;       /* minutes after the hour [0..59]            */
   int            tm_hour;      /* hours since midnight [0..23]              */
   int            tm_mday;      /* days of the month [1..31]                 */
   int            tm_mon;       /* months since January [0..11]              */
   int            tm_year;      /* years since 1900 [0..]                   */
   int            tm_wday;      /* days since Sunday [0..6]                  */
   int            tm_yday;      /* days since first of January [0..365]      */
   int            tm_isdst;     /* on summer time (-1 unknown, 0 no, !0 yes) */
};                              /* sizeof(struct tm) == 0x24 (36.)           */

#ifndef __ANSIC__
struct dos_tm                   /* DOS 'broken-down' time                    */
{
   unsigned short bisecond : 5; /* two-second increments only                */
   unsigned short minute   : 6; /* 0-59                                      */
   unsigned short hour     : 5; /* 0-23                                      */
   unsigned short day      : 5; /* 1-31                                      */
   unsigned short month    : 4; /* 1-12                                      */
   unsigned short year     : 7; /* years since 1980 (limit: 0-119)           */
};

struct dos_dt                   /* DOS date separated from time              */
{
   unsigned short time;         /* time fields                               */
   unsigned short date;         /* date fields                               */
};

union dos_tm_u                  /* utility for passing DOS time              */
{
   unsigned long  long_dt;      /* scalar for passing as argument            */
   struct dos_dt  struct_dt;    /* separated-out DOS time and date           */
   struct dos_tm  struct_tm;    /* broken-down DOS time and date             */
};
#endif

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif


char      *asctime  ( const struct tm *localtime );
clock_t    clock    ( void );
char      *ctime    ( const time_t *calendar );
double     difftime ( time_t t1, time_t t2 );
struct tm *gmtime   ( const time_t *calendar );
struct tm *localtime( const time_t *calendar );
time_t     mktime   ( struct tm *localtime );
size_t     strftime ( char * restrict s, size_t, const char * restrict format,
                      const struct tm * restrict localtime );
time_t     time     ( time_t *calendar );

int        ___clocks_per_sec( void );

#ifndef __ANSIC__
/* POSIX data and helper functions... */
int       *___daylight      ( void );
int       *___daylightOnOff ( void );
time_t    *___daylightOffset( void );
time_t    *___timezone      ( void );
char     **___tzname        ( void );
int        __isleap         ( int year );

void       tzset            ( void );

/* POSIX-defined reentrant additions ... */
char      *asctime_r   ( const struct tm *localtime, char *timestr );
char      *ctime_r     ( const time_t *calendar, char *timestr );
struct tm *gmtime_r    ( const time_t *calendar, struct tm *localtime );
struct tm *localtime_r ( const time_t *calendar, struct tm *localtime );

/* Novell-defined additions... */
time_t        ltime       ( time_t *calendar );
time_t        mkgmtime    ( struct tm *gmtime );
time_t        dos2calendar( unsigned long dostime );
unsigned long calendar2dos( time_t calendar );
#endif

#ifdef __cplusplus
}
#endif

#ifndef __ANSIC__
# define daylight           (*___daylight())
# define daylightOffset     (*___daylightOffset())
# define daylightOnOff      (*___daylightOnOff())
# define _timezone          (*___timezone())
# define Lstrftime          strftime

#endif

#define _difftime(t1, t0)   ((double) (t1) - (double) (t0))
#define difftime(t1, t0)    _difftime(t1, t0)
#define tzname              (___tzname())
#define CLOCKS_PER_SEC      ___clocks_per_sec()
#define CLK_TCK             CLOCKS_PER_SEC

#endif
