#ifndef __unistd_h__
#define __unistd_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): ISO/IEC (POSIX) 9845:1996; Novell additions
=
=  unistd.h
==============================================================================
*/
#include <stdarg.h>
#include <stddef.h>
#include <sys/unistd.h>

/* 'mode' values for access(), shm_open(), etc. ...                  */
#define R_OK          1 /* test for read permission                  */
#define W_OK          2 /* test for write permission                 */
#define X_OK          4 /* test for execute permission               */
#define F_OK          8 /* test for existence of file                */

/* values for 'whence' in lseek()...                                 */
#define SEEK_SET      0 /* set file pointer to 'offset'              */
#define SEEK_CUR      1 /* set file pointer to current plus 'offset' */
#define SEEK_END      2 /* set file pointer to EOF plus 'offset'     */

/* old Berkeley names...                                             */
#define L_SET         SEEK_SET
#define L_INCR        SEEK_CUR
#define L_XTND        SEEK_END

#define EFF_ONLY_OK   8 /* test using effective ids                  */

#define STDIN_FILENO  0 /* descriptor underlying 'stdin'             */
#define STDOUT_FILENO 1 /* ibid for 'stdout'                         */
#define STDERR_FILENO 2 /* ibid for 'stderr'                         */

#ifdef __cplusplus
extern "C"
{
#endif

/* POSIX-defined functions... */
int          access   ( const char *path, int mode );
unsigned int alarm    ( unsigned int seconds );
int          chdir    ( const char *path );
int          chsize   ( int fildes, size_t size );
int          close    ( int fildes );
char        *crypt    ( const char *key, const char *salt );
int          dup      ( int fildes );
int          dup2     ( int fildes1, int fildes2 );
void         encrypt  ( char block[64], int edflag );
void         _exit    ( int status );
int          fdatasync( int fildes );
int          fsync    ( int fildes );
long         fpathconf( int fildes, int name );
int          ftruncate( int fildes, off_t len );
char        *getcwd   ( char *path, size_t len );
int          getopt   ( int argc, char * const argv[], const char *optstr );
int          ioctl    ( int, int, ... );
int          isatty   ( int fildes );
off_t        lseek    ( int fildes, off_t offset, int whence );
long         pathconf ( const char *path, int name );
int          pipe     ( int fildes[2] );
ssize_t      pread    ( int fildes, void *buf, size_t nbytes, off_t off );
ssize_t      pwrite   ( int fildes, const void *buf, size_t nbytes, off_t off );
ssize_t      read     ( int fildes, void *buf, size_t nbytes );
int          rmdir    ( const char *path );
long         sysconf  ( int name );
int          unlink   ( const char *path );
ssize_t      write    ( int fildes, const void *buf, size_t nbytes );

/* nonstandard additions (see also fsio.h)... */
int          cancel   ( int t_id );
size_t       confstr  ( int name, char *buf, size_t len );
int          delay    ( unsigned int milliseconds );
int          setmode  ( int fildes, int oflag );
unsigned int sleep    ( unsigned int seconds );

/* nonstandard (transitional) addtions for 64-bit file I/O... */
int      chsize64     ( int fildes, size64_t size );
int      ftruncate64  ( int fildes, off64_t len );
off64_t  lseek64      ( int fildes, off64_t offset, int whence );
ssize_t  pread64      ( int fildes, void *buf, size_t nbytes, off64_t off );
ssize_t  pwrite64     ( int fildes, const void *buf, size_t nbytes,off64_t off);
off64_t  tell64       ( int fildes );

char   **___environ   ( void );
char   **___optarg    ( void );
int     *___optind    ( void );
int     *___opterr    ( void );
int     *___optopt    ( void );
int     *___optreset  ( void );


#ifdef __cplusplus
}
#endif

#define environ  (___environ())

/* globals for getopt() implementation... */
#define optarg   (*___optarg())
#define optind   (*___optind())
#define opterr   (*___opterr())
#define optopt   (*___optopt())
#define optreset (*___optreset())

/* sleep() as implemented on NetWare is missing full POSIX semantics... */
#define sleep(t) delay((t) * 1000)

#define _POSIX_THREAD_SAFE_FUNCTIONS 1
#define _POSIX_MAPPED_FILES          1
#define _POSIX_MEMLOCK               1
#define _POSIX_MEMLOCK_RANGE         1
#define _POSIX_MEMORY_PROTECTION     1
#define _POSIX_SYNCHRONIZED_IO       1
#define _POSIX_FSYNC                 1

#define _POSIX_ASYNC_IO             -1
#define _POSIX_CHOWN_RESTRICTED     -1
#define _POSIX_NO_TRUNC             -1
#define _POSIX_PRIO_IO              -1
#define _POSIX_SYNC_IO               1
#define _POSIX_VDISABLE              0


#endif
