#ifndef __utf8_h__
#define __utf8_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  utf8.h
==============================================================================
*/
#include <stddef.h>
#include <string.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef unsigned char   utf8_t;

#if defined(IAPX386)
extern unsigned char  __utf8width[];
#endif


/* prototypes... */
size_t   utf8width   ( const utf8_t *ch );
utf8_t  *utf8cat     ( utf8_t *tgt, const utf8_t *src );
utf8_t  *utf8chr     ( const utf8_t *string, const utf8_t *ch );
int      utf8cmp     ( const utf8_t *s1, const utf8_t *s2 );
utf8_t  *utf8cpy     ( utf8_t *tgt, const utf8_t *src );
size_t   utf8cspn    ( const utf8_t *string, const utf8_t *charset );
utf8_t  *utf8dup     ( const utf8_t *s );
utf8_t  *utf8index   ( const utf8_t *string, const utf8_t *search );
size_t   utf8len     ( const utf8_t *string );
utf8_t  *utf8list    ( utf8_t *tgt, const utf8_t *s1, ... );
utf8_t  *utf8lwr     ( utf8_t *string );
utf8_t  *utf8ncat    ( utf8_t *tgt, const utf8_t *src, size_t n );
int      utf8ncmp    ( const utf8_t *s1, const utf8_t *s2, size_t n );
utf8_t  *utf8ncpy    ( utf8_t *tgt, const utf8_t *src, size_t n );
utf8_t  *utf8next    ( const utf8_t *string );
utf8_t  *utf8nset    ( utf8_t *base, utf8_t *ch, size_t n );
utf8_t  *utf8pbrk    ( const utf8_t *s1, const utf8_t *s2 );
utf8_t  *utf8prev    ( const utf8_t *string );
utf8_t  *utf8rchr    ( const utf8_t *string, const utf8_t *ch );
utf8_t  *utf8rev     ( utf8_t *string );
size_t   utf8size    ( const utf8_t *string );
size_t   utf8spn     ( const utf8_t *string, const utf8_t *charset );
utf8_t  *utf8str     ( const utf8_t *as1, const utf8_t *as2 );
utf8_t  *utf8tolower ( const utf8_t *string, utf8_t *dest );
utf8_t  *utf8tok_r   ( utf8_t *string, const utf8_t *sepset, utf8_t **lasts );
utf8_t  *utf8toupper ( const utf8_t *string, utf8_t *dest );
utf8_t  *utf8upr     ( utf8_t *string );

int      isutf8ascii ( const utf8_t *string );
int      isutf8digit ( const utf8_t *string );
int      isutf8xdigit( const utf8_t *string );
int      isutf8space ( const utf8_t *string );
int      isutf8alnum ( const utf8_t *string );
int      isutf8alpha ( const utf8_t *string );
int      isutf8lower ( const utf8_t *string );
int      isutf8upper ( const utf8_t *string );

#ifdef __cplusplus
}
#endif

#define utf8width(s)       __utf8width[*s]
#define utf8size(s)        strlen((char *) s)
#define utf8dup(s)        (utf8_t *) strdup((char *) s)
#define utf8cat(s1, s2)   (utf8_t *) strcat((char *) s1, (char *) s2)
#define utf8cpy(s1, s2)   (utf8_t *) strcpy((char *) s1, (char *) s2)
#define utf8index(s1, s2) (utf8_t *) strindex((char *) s1, (char *) s2)
#define utf8str(s1, s2)   (utf8_t *) strindex((char *) s1, (char *) s2)
#define isutf8ascii(s)    (utf8width(s) == 1)
#define isutf8digit(s)    (utf8width(s) == 1) ? isdigit (*(utf8_t *) s) : FALSE
#define isutf8xdigit(s)   (utf8width(s) == 1) ? isxdigit(*(utf8_t *) s) : FALSE
#define isutf8space(s)    (utf8width(s) == 1) ? isspace (*(utf8_t *) s) : FALSE

#endif
