#ifndef __wchar_h__
#define __wchar_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1990,1999
=
=  wchar.h
==============================================================================
*/
#include <time.h>
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdint.h>

#ifndef WEOF
# define WEOF  (-1)
#endif

#include <pshpack1.h>

typedef int             wint_t;
typedef unsigned short  wuchar_t;

typedef struct
{
   wchar_t  __mbwc;
   wchar_t  __mbst;
} mbstate_t;

#include <poppack.h>

#ifdef __cplusplus
extern "C"
{
#endif


size_t   mbsrtowcs(wchar_t * restrict, const char ** restrict, size_t,
            mbstate_t * restrict);
int      fwprintf(struct _iobuf * restrict, const wchar_t * restrict, ...);
int      fwscanf(struct _iobuf * restrict, const wchar_t * restrict, ...);
int      swprintf(wchar_t * restrict, size_t, const wchar_t * restrict, ...);
int      swscanf(const wchar_t * restrict, const wchar_t * restrict, ...);
int      vfwprintf(struct _iobuf * restrict, const wchar_t * restrict, va_list);
int      vfwscanf(struct _iobuf *, const wchar_t *, va_list);
int      vwscanf(const wchar_t *, va_list);
int      vswscanf(const wchar_t *, const wchar_t *, va_list);
size_t   wcrtomb(char * restrict, wchar_t, mbstate_t * restrict);
wchar_t *wcscat(wchar_t * restrict, const wchar_t * restrict);
wchar_t *wcschr(const wchar_t *, wchar_t);
int      wcscmp(const wchar_t *, const wchar_t *);
int      wcscoll(const wchar_t *, const wchar_t *);
wchar_t *wcscpy(wchar_t * restrict, const wchar_t * restrict);
size_t   wcscspn(const wchar_t *, const wchar_t *);
size_t   wcsftime(wchar_t * restrict,size_t,const wchar_t * restrict,
            const struct tm * restrict);
size_t   wcslen(const wchar_t *);
wchar_t *wcsncat(wchar_t * restrict, const wchar_t * restrict, size_t);
int      wcsncmp(const wchar_t *, const wchar_t *, size_t);
wchar_t *wcsncpy(wchar_t * restrict, const wchar_t * restrict, size_t);
wchar_t *wcspbrk(const wchar_t *, const wchar_t *);
wchar_t *wcsrchr(const wchar_t *, wchar_t);
size_t   wcsrtombs(char * restrict, const wchar_t ** restrict, size_t,
            mbstate_t * restrict);
size_t   wcsspn(const wchar_t *, const wchar_t *);
wchar_t *wcsstr(const wchar_t *, const wchar_t *);
double   wcstod(const wchar_t * restrict, wchar_t ** restrict);
float    wcstof(const wchar_t * restrict, wchar_t ** restrict);
wchar_t *wcstok(wchar_t * restrict, const wchar_t * restrict,
            wchar_t ** restrict); 
wchar_t *wcstok_r(wchar_t * restrict, const wchar_t * restrict,
            wchar_t ** restrict); 
long     wcstol(const wchar_t * restrict, wchar_t ** restrict, int);
long double wcstold(const wchar_t * restrict, wchar_t ** restrict);
int64_t  wcstoll(const wchar_t * restrict, wchar_t ** restrict, int);
unsigned long wcstoul( const wchar_t * restrict, wchar_t ** restrict, int);
uint64_t wcstoull(const wchar_t * restrict, wchar_t ** restrict, int);
size_t   wcsxfrm(wchar_t * restrict, const wchar_t * restrict, size_t);
int      wctob(wint_t);
int      wcsmemcmp(const wchar_t * restrict, const wchar_t * restrict, size_t);
wchar_t *wcsmemcpy(wchar_t * restrict, const wchar_t * restrict, size_t);
wchar_t *wcsmemmove(wchar_t *, const wchar_t *, size_t);
wint_t   putwc(wchar_t, struct _iobuf *);
wint_t   putwchar(wchar_t);
int      fwide(struct _iobuf *, int);
wint_t   fputwc(wchar_t, struct _iobuf *);
int      fputws(const wchar_t * restrict, struct _iobuf * restrict);
wint_t   fgetwc(struct _iobuf *);
wchar_t *fgetws(wchar_t * restrict, int, struct _iobuf * restrict);
wint_t   getwc(struct _iobuf *);
wint_t   getwchar(void);
wint_t   ungetwc(wint_t, struct _iobuf * restrict);
int      wprintf(const wchar_t * restrict, ...);
int      wscanf(const wchar_t * restrict, ...);
int      vwprintf(const wchar_t * restrict, va_list);
int      vswprintf(wchar_t * restrict, size_t, const wchar_t * restrict, va_list);

#ifndef __ANSIC__
int      wcscasecmp(const wchar_t *, const wchar_t *);
wchar_t *wcserror(int);
int      wcsicmp(const wchar_t *, const wchar_t *); 
wchar_t *wcsindex(const wchar_t *, const wchar_t *);
wchar_t *wcslist(wchar_t *, const wchar_t *, ...); 
wchar_t *wcslwr(wchar_t *);
int      wcsncasecmp( const wchar_t *, const wchar_t *, size_t);
int      wcsnicmp(const wchar_t *, const wchar_t *, size_t); 
wchar_t *wcsnset(wchar_t *, int, size_t); 
wchar_t *wcsrev(wchar_t *); 
wchar_t *wcsrindex(const wchar_t *, size_t, int);
wchar_t *wcsset(wchar_t *, int); 
wchar_t *wcsupr(wchar_t *); 
void     wungettok(wchar_t * restrict, const wchar_t * restrict,
            wchar_t ** restrict);
void     wungettok_r( wchar_t * restrict, const wchar_t * restrict,
            wchar_t ** restrict);

wint_t   btowc(int);
int      mbrlen(const char * restrict, size_t, mbstate_t * restrict);
int      mbrtowc(wchar_t * restrict, const char * restrict, size_t,
            mbstate_t * restrict);
int      mbsinit(const mbstate_t *);


int      wcwidth(wchar_t);
int      wcswidth(const wchar_t *, size_t);
#endif

#ifdef __cplusplus
}
#endif

/* macros that overcome implementation's function call overhead... */
#include <unilib.h>
#define wcsrev(s)             (wchar_t *)unirev((unicode_t *)s)
#define wcslwr(s)             (wchar_t *)unilwr((unicode_t *)s)
#define wcsupr(s)             (wchar_t *)uniupr((unicode_t *)s)
#define wcschr(s, ch)         (wchar_t *)unichr((unicode_t *)s,(unicode_t)ch)
#define wcsrchr(s,ch)         (wchar_t *)unirchr((unicode_t *)s,(unicode_t)ch)
#define wcsset(b,ch)          (wchar_t *)uniset((unicode_t *)b,(unicode_t)ch)
#define wcsstr(s1,s2)         (wchar_t *)unistr((unicode_t *)s1,(unicode_t *)s2)
#define wcsnset(b,ch,n)       (wchar_t *)uninset((unicode_t *)b,(unicode_t)ch,n)
#define wcspbrk(s1,s2)        (wchar_t *)unipbrk((unicode_t *)s1,(unicode_t*)s2)
#define wcsindex(s1,s2)       (wchar_t *)uniindex((unicode_t*)s1,(unicode_t*)s2)
#define wcslen(s)             unilen((unicode_t *)s)
#define wcsspn(s,cs)          unispn((unicode_t *)s,(unicode_t *)cs)
#define wcscspn(s,cs)         unicspn((unicode_t *)s,(unicode_t *)cs)
#define wcsicmp(s1,s2)        uniicmp((unicode_t *)s1,(unicode_t *)s2)
#define wcsnicmp(s1,s2,n)     uninicmp((unicode_t *)s1,(unicode_t *)s2, n)
#define wcscasecmp(s1,s2)     uniicmp((unicode_t *)s1,(unicode_t *)s2)
#define wcsncasecmp(s1,s2,n)  uninicmp((unicode_t *)s1,(unicode_t *)s2, n)
#define wcstok(s1,s2,p)       unitok_r((unicode_t *)s1,(unicode_t *)s2,(unicode_t **)p)
#define wcstok_r(s1,s2,p)     unitok_r((unicode_t *)s1,(unicode_t *)s2,(unicode_t **)p)
#define wcsungettok(s1,s2,p)  wcsungettok_r(s1,s2,p)

#define getwc(ch,fp)          fgetwc(ch,fp)
#define getwchar(ch)          fgetwc(ch,stdin)
#define putwc(ch,fp)          fputwc(ch,fp)
#define putwchar(ch)          fputwc(ch,stdout)

#endif
