#ifndef __wctype_h__
#define __wctype_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): ISO/IEC (ANSI) 9899:1999
=
=  wctype.h
==============================================================================
*/
#include <wchar.h>
#include <stddef.h>

typedef enum
{
	WCTYPE_UNDEF,
   WCTYPE_ALNUM,
   WCTYPE_ALPHA,
   WCTYPE_BLANK,
   WCTYPE_CNTRL,
   WCTYPE_DIGIT,
   WCTYPE_GRAPH,
   WCTYPE_LOWER,
   WCTYPE_PRINT,
   WCTYPE_PUNCT,
   WCTYPE_SPACE,
   WCTYPE_UPPER,
   WCTYPE_XDIGIT
} wctype_t;

typedef wchar_t   wctrans_t;


#ifdef __cplusplus
extern "C"
{
#endif

int       iswalnum ( wint_t );
int       iswalpha ( wint_t );
int       iswblank ( wint_t );
int       iswcntrl ( wint_t );
int       iswdigit ( wint_t );
int       iswgraph ( wint_t );
int       iswlower ( wint_t );
int       iswprint ( wint_t );
int       iswpunct ( wint_t );
int       iswspace ( wint_t );
int       iswupper ( wint_t );
int       iswxdigit( int     );

wint_t    towlower ( wint_t );
wint_t    towupper ( wint_t );

int       iswctype ( wint_t, wctype_t );
wctype_t  wctype   ( const char * );
wint_t    towctrans( wint_t, wctrans_t );
wctrans_t wctrans  ( const char * );

#ifndef __ANSIC__
int       iswascii ( wint_t );
#endif

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
inline int iswascii(wint_t wc) { return !(wc & ~0x7f); }
#else
# define iswascii(wc)          (!((wc) & ~0x7f))
#endif

#define iswalnum(wc)           (iswalpha(wc) || iswdigit(wc))
#define iswalpha(wc)           (unitype((unicode_t) wc) == UNI_ALPHA)
#define iswgraph(wc)           (iswprint(wc) && !iswspace(wc))
#define iswprint(wc)           (unitype((unicode_t) wc) == UNI_PRINT)
#define towlower(wc)           (wint_t) chr2lwr((unicode_t) wc)
#define towupper(wc)           (wint_t) chr2upr((unicode_t) wc)

#endif
