#ifndef __windows_h__
#define __windows_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): limited set of Microsoft Windows work-alike functions
=
=  windows.h
==============================================================================
*/

/* nonstandard DllMain() messages... */
#define DLL_ACTUAL_DLLMAIN    0  /* always return TRUE for this message   */
#define DLL_NLM_STARTUP       1  /* start-up, 'lpvReserved' is NLM handle */
#define DLL_NLM_SHUTDOWN      2  /* unload, 'lpvReserved' is NLM handle   */

/* standard DllMain() messages... */
#define DLL_PROCESS_ATTACH    3  /* DLL "loaded" into application space   */
#define DLL_THREAD_ATTACH     4  /* application creating new thread       */
#define DLL_THREAD_DETACH     5  /* application thread exiting cleanly    */
#define DLL_PROCESS_DETACH    6  /* DLL "unloaded" from application space */

#define TLS_MINIMUM_AVAILABLE	64 /* minumum number of keys available      */

#ifndef DWORD
# define DWORD unsigned long
#endif

/* Microsoft Windows types done as macros... */
#ifndef _VOID
# define _VOID
typedef void   VOID;
#endif
#ifndef _LPVOID
# define _LPVOID
typedef void  *LPVOID;
#endif
#ifndef _BOOL
# define _BOOL
typedef int    BOOL;
#endif
#ifndef _HMODULE
# define _HMODULE
typedef void  *HMODULE;
#endif
#ifndef _LPCTSTR
# define _LPCTSTR
typedef char  *LPCTSTR;
#endif
#ifndef _HINSTANCE
# define _HINSTANCE
typedef void  *HINSTANCE;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Win32 DLL solutions for dynamic NLM libraries on NetWare... */
DWORD   GetLastError( void );
VOID    SetLastError( DWORD dwErrCode );

BOOL    FreeLibrary ( HMODULE hModule );
HMODULE LoadLibrary ( LPCTSTR lpFileName );

#ifdef __cplusplus
}
#endif


/*
** Prototype for libraries writing their own start-up and shut-down code.
** This is not an interface, but only a prototype for code furnished by the
** NLM library.
*/
BOOL DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserve );


#endif
