#ifndef __novsock2_h__
#define __novsock2_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Microsoft-inspired Header
=
=  novsock2.h
==============================================================================
*/
#include <ws2defs.h>

#if !defined(N_PLAT_NLM)
# define N_PLAT_NLM
#endif

#include <unilib.h>

/* socket() 'flags'... */
#define SKTS_RAWCALLBACKS        0x40000000L
#define SKTS_WORKTODOCALLBACKS   0x20000000L

/* ioctl() 'flags' arguments... */
#define SIO_RAWCALLBACKS         0x1ADD0002L
#define SIO_WORKTODOCALLBACKS    0x1ADD0004L
#define SIO_FASTACCEPTCALLBACK   0x1ADD0008L
#define SIO_FASTRECVCALLBACK     0x1ADD000C

/* affects blocking mode as well as overlapped callbacks */
#define SIO_RCVFULLMSG           0x1ADD0010 

/* NetWare specific socket options */
#define SO_CONNTIMEO             0x1009 /* connect timeout */

/* some system flags not defined in NetWare... */
#define INFINITE                 0xFFFFFFFFUL
#define WAIT_FAILED              0xFFFFFFFFUL
#define WAIT_OBJECT_0            0x00000000UL
#define WAIT_ABANDONED           0x00000080UL
#define WAIT_IO_COMPLETION       0x000000C0UL
#define WAIT_TIMEOUT             0x00000102UL
#define MAXIMUM_WAIT_OBJECTS     64UL

/*
** Consume Berkeley interfaces from WinSock instead of from the C runtime
** library. The descriptors passed back from socket() won't be unified with
** those returned by open(), etc. This causes the correct WinSock definitions
** to be made and excludes library headers that would conflict.
*/
#define INCL_WINSOCK_API_TYPEDEFS     1
#define INCL_WINSOCK_API_PROTOTYPES   1


#if defined(__sys_socket_h__)
# error novsock2.h is incompatible with sys/socket.h!
#elif defined( __netdb_h__)
# error novsock2.h is incompatible with netdb.h!
#endif

/*
** BSD sockets clashes that must first be maped to WS2_32.NLM calls before
** they can be converted to Winsock 2.
*/  
#define htonl              WS2_32_htonl 
#define ntohl              WS2_32_ntohl 
#define htons              WS2_32_htons 
#define ioctlsocket        WS2_32_ioctlsocket
#define ntohs              WS2_32_ntohs 
#define send               WS2_32_send
#define recv               WS2_32_recv
#define bind               WS2_32_bind
#define listen             WS2_32_listen
#define closesocket        WS2_32_closesocket
#define getpeername        WS2_32_getpeername
#define getsockname        WS2_32_getsockname
#define getsockopt         WS2_32_getsockopt
#define recvfrom           WS2_32_recvfrom
#define select             WS2_32_select
#define sendto             WS2_32_sendto
#define setsockopt         WS2_32_setsockopt
#define socket             WS2_32_socket
#define shutdown           WS2_32_shutdown
#define inet_addr          WS2_32_inet_addr
#define inet_ntoa          WS2_32_inet_ntoa
#define gethostbyaddr      WS2_32_gethostbyaddr
#define gethostbyname      WS2_32_gethostbyname
#define gethostname        WS2_32_gethostname
#define getprotobyname     WS2_32_getprotobyname
#define getprotobynumber   WS2_32_getprotobynumber
#define getservbyname      WS2_32_getservbyname
#define getservbyport      WS2_32_getservbyport

#define _WINSOCK2API_
#define __winsock2_h__ /* for use by sys/socket.h */
/* Winsock2.h -- definitions to be used with the WinSock 2 DLL and
**               WinSock 2 applications.
**
** This header file corresponds to version 2.2.x of the WinSock API
** specification.
*/

/* Ensure structures packed consistently */
#ifndef _WIN64
# include <pshpack4.h>
#endif

/* Default: include function prototypes, don't include function typedefs */
#ifndef INCL_WINSOCK_API_PROTOTYPES
# define INCL_WINSOCK_API_PROTOTYPES 1
#endif

#ifndef INCL_WINSOCK_API_TYPEDEFS
# define INCL_WINSOCK_API_TYPEDEFS 0
#endif

/*
** Define the current Winsock version. To build an earlier Winsock version
** application redefine this value prior to including Winsock2.h.
*/
#if !defined(MAKEWORD)
#define MAKEWORD(low,high) \
        ((WORD)(((BYTE)(low)) | ((WORD)((BYTE)(high))) << 8))
#endif

#ifndef WINSOCK_VERSION
#define WINSOCK_VERSION MAKEWORD(2,2)
#endif

/*
** Establish DLL function linkage if supported by the current build
** environment and not previously defined.
*/
#ifndef WINSOCK_API_LINKAGE
# ifdef DECLSPEC_IMPORT
#  define WINSOCK_API_LINKAGE DECLSPEC_IMPORT
# else
#  define WINSOCK_API_LINKAGE
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
** Basic system type definitions, taken from the BSD file sys/types.h.
*/
#include <sys/types.h>

/*
** The new type to be used in all
** instances which refer to sockets.
*/
#ifdef _WIN64
typedef UINT_PTR  SOCKET;
#else
typedef int       SOCKET;
#endif

/*
** Select uses arrays of SOCKETs.  These macros manipulate such
** arrays.  FD_SETSIZE may be defined by the user before including
** this file, but the default here should be >= 64.
*/
#include <sys/select.h>

/*
** Since sys/select.h maps the FD_* functions into libc, we redefine them 
** back to the Winsock functions/macros.
**/
#undef FD_CLR
#undef FD_SET
#undef FD_ZERO
#undef FD_ISSET

extern int PASCAL FAR __WSAFDIsSet(SOCKET, fd_set FAR *);

#define FD_CLR(fd, set) do { \
    u_int __i; \
    for (__i = 0; __i < ((fd_set FAR *)(set))->fd_count ; __i++) { \
        if (((fd_set FAR *)(set))->fd_array[__i] == fd) { \
            while (__i < ((fd_set FAR *)(set))->fd_count-1) { \
                ((fd_set FAR *)(set))->fd_array[__i] = \
                    ((fd_set FAR *)(set))->fd_array[__i+1]; \
                __i++; \
            } \
            ((fd_set FAR *)(set))->fd_count--; \
            break; \
        } \
    } \
} while(0)

#define FD_SET(fd, set) do { \
    u_int __i; \
    for (__i = 0; __i < ((fd_set FAR *)(set))->fd_count; __i++) { \
        if (((fd_set FAR *)(set))->fd_array[__i] == (fd)) { \
            break; \
        } \
    } \
    if (__i == ((fd_set FAR *)(set))->fd_count) { \
        if (((fd_set FAR *)(set))->fd_count < FD_SETSIZE) { \
            ((fd_set FAR *)(set))->fd_array[__i] = (fd); \
            ((fd_set FAR *)(set))->fd_count++; \
        } \
    } \
} while(0)

#define FD_ZERO(set) (((fd_set FAR *)(set))->fd_count=0)

#define FD_ISSET(fd, set) __WSAFDIsSet((SOCKET)(fd), (fd_set FAR *)(set))

/*
** Structure used in select() call, taken from the BSD file sys/timeval.h.
*/
#include <sys/timeval.h>

/*
** Commands for ioctlsocket().
**
** Ioctl's have the command encoded in the lower word, and the size of any in
** or out parameters in the upper word. The high 2 bits of the upper word are
** used to encode the in/out status of the parameter; for now we restrict
** parameters to at most 128 bytes.
*/
#define IOCPARM_MASK 0x7f            /* parameters must be < 128 bytes */
#define IOC_VOID     0x20000000      /* no parameters */
#define IOC_OUT      0x40000000      /* copy out parameters */
#define IOC_IN       0x80000000      /* copy in parameters */
#define IOC_INOUT    (IOC_IN|IOC_OUT)/* 0x20000000 distinguishes new/old ioctl*/

#define _IO(x,y)     (IOC_VOID|((x)<<8)|(y))
#define _IOR(x,y,t)  (IOC_OUT|(((long)sizeof(t)&IOCPARM_MASK)<<16)|((x)<<8)|(y))
#define _IOW(x,y,t)  (IOC_IN|(((long)sizeof(t)&IOCPARM_MASK)<<16)|((x)<<8)|(y))

#define FIONREAD    _IOR('f', 127, u_long) /* get # bytes to read */
#define FIONBIO     _IOW('f', 126, u_long) /* set/clear non-blocking i/o */
#define FIOASYNC    _IOW('f', 125, u_long) /* set/clear async i/o */

/* Socket I/O Controls */
#define SIOCSHIWAT  _IOW('s',  0, u_long)  /* set high watermark */
#define SIOCGHIWAT  _IOR('s',  1, u_long)  /* get high watermark */
#define SIOCSLOWAT  _IOW('s',  2, u_long)  /* set low watermark */
#define SIOCGLOWAT  _IOR('s',  3, u_long)  /* get low watermark */
#define SIOCATMARK  _IOR('s',  7, u_long)  /* at oob mark? */

/*
** Structures returned by network data base library, taken from the
** BSD file netdb.h. All addresses are supplied in host order, and
** returned in network order (suitable for use in system calls).
** Addresses are supplied in host order and returned in network order.
*/
struct hostent
{
   char   *h_name;               /* official name of host                  */
   char  **h_aliases;            /* alias list                             */
   short   h_addrtype;           /* host address type                      */
   short   h_length;             /* length of address                      */
   char  **h_addr_list;          /* list of addresses                      */
#define h_addr  h_addr_list[0]   /* address, for backward compatibility    */
};

/*
** It is assumed here that a network number fits in 32 bits.
*/
struct netent                    /* assumed network number fits in 32 bits */
{
   char   *n_name;               /* official name of net                   */
   char  **n_aliases;            /* alias list                             */
   short   n_addrtype;           /* net address type                       */
   u_long  n_net;                /* network number                         */
};

struct servent
{
   char   *s_name;               /* official service name                  */
   char  **s_aliases;            /* alias list                             */
   short   s_port;               /* port number                            */
   char   *s_proto;              /* protocol to use                        */
};

struct protoent
{
   char   *p_name;               /* official protocol name                 */
   char  **p_aliases;            /* alias list                             */
   short   p_proto;              /* protocol number                        */
};

/*
** Constants and structures defined by the internet system, per RFC 790,
** September 1981, taken from the BSD file netinet/in.h.
*/

/*
** Protocols
*/
#include <netinet/in.h>

/*
** Socket address, internet style.
*/
#define WSADESCRIPTION_LEN      256
#define WSASYS_STATUS_LEN       128

typedef struct WSAData
{
   WORD           wVersion;
   WORD           wHighVersion;
#ifdef _WIN64
   unsigned short iMaxSockets;
   unsigned short iMaxUdpDg;
   char          *lpVendorInfo;
   char           szDescription[WSADESCRIPTION_LEN+1];
   char           szSystemStatus[WSASYS_STATUS_LEN+1];
#else
   char           szDescription[WSADESCRIPTION_LEN+1];
   char           szSystemStatus[WSASYS_STATUS_LEN+1];
   unsigned short iMaxSockets;
   unsigned short iMaxUdpDg;
   char          *lpVendorInfo;
#endif
} WSADATA, * LPWSADATA;

/*
** Definitions related to sockets: types, address families, options, taken
** from the BSD file sys/socket.h. However, don't include the standard C
** library's sys/socket.h because conflicts will result.
*/
#if defined(__sys_socket_h__)
# error winsock2.h is incompatible with sys/socket.h!
#endif

/*
** This is used instead of -1, since the SOCKET type is unsigned.
*/
#define INVALID_SOCKET  (SOCKET)(~0)
#define SOCKET_ERROR            (-1)

/*
** The following may be used in place of the address family, socket type, or
** protocol in a call to WSASocket to indicate that the corresponding value
** should be taken from the supplied WSAPROTOCOL_INFO structure instead of the
** parameter itself.
*/
#define FROM_PROTOCOL_INFO (-1)

/*
** Types
*/
#define SOCK_STREAM     1               /* stream socket */
#define SOCK_DGRAM      2               /* datagram socket */
#define SOCK_RAW        3               /* raw-protocol interface */
#define SOCK_RDM        4               /* reliably-delivered message */
#define SOCK_SEQPACKET  5               /* sequenced packet stream */

/*
** Option flags per-socket.
*/
#define SO_DEBUG        0x0001          /* turn on debugging info recording */
#define SO_ACCEPTCONN   0x0002          /* socket has had listen() */
#define SO_REUSEADDR    0x0004          /* allow local address reuse */
#define SO_KEEPALIVE    0x0008          /* keep connections alive */
#define SO_DONTROUTE    0x0010          /* just use interface addresses */
#define SO_BROADCAST    0x0020          /* permit sending of broadcast msgs */
#define SO_USELOOPBACK  0x0040          /* bypass hardware when possible */
#define SO_LINGER       0x0080          /* linger on close if data present */
#define SO_OOBINLINE    0x0100          /* leave received OOB data in line */

#define SO_DONTLINGER        (int)(~SO_LINGER)
#define SO_EXCLUSIVEADDRUSE ((int)(~SO_REUSEADDR))/* disallow local address reuse */

/*
** Additional options.
*/
#define SO_SNDBUF       0x1001          /* send buffer size */
#define SO_RCVBUF       0x1002          /* receive buffer size */
#define SO_SNDLOWAT     0x1003          /* send low-water mark */
#define SO_RCVLOWAT     0x1004          /* receive low-water mark */
#define SO_SNDTIMEO     0x1005          /* send timeout */
#define SO_RCVTIMEO     0x1006          /* receive timeout */
#define SO_ERROR        0x1007          /* get error status and clear */
#define SO_TYPE         0x1008          /* get socket type */

/*
** WinSock 2 extension--new options
*/
#define SO_GROUP_ID       0x2001      /* ID of a socket group */
#define SO_GROUP_PRIORITY 0x2002      /* the relative priority within a group*/
#define SO_MAX_MSG_SIZE   0x2003      /* maximum message size */
#define SO_PROTOCOL_INFOA 0x2004      /* WSAPROTOCOL_INFOA structure */
#define SO_PROTOCOL_INFOW 0x2005      /* WSAPROTOCOL_INFOW structure */
#ifdef UNICODE
# define SO_PROTOCOL_INFO SO_PROTOCOL_INFOW
#else
# define SO_PROTOCOL_INFO SO_PROTOCOL_INFOA
#endif
#define PVD_CONFIG        0x3001      /* config info for service provider */

/*
** TCP options.
*/
#define TCP_NODELAY     0x0001

/*
** Address families.
*/
#define AF_UNSPEC       0               /* unspecified */

/*
** Although AF_UNSPEC is defined for backwards compatibility, using
** AF_UNSPEC for the "af" parameter when creating a socket is STRONGLY
** DISCOURAGED.  The interpretation of the "protocol" parameter
** depends on the actual address family chosen. As environments grow
** to include more and more address families that use overlapping
** protocol values there is more and more chance of choosing an
** undesired address family when AF_UNSPEC is used.
*/
#define AF_UNIX         1               /* local to host (pipes, portals) */
#define AF_INET         2               /* internetwork: UDP, TCP, etc. */
#define AF_IMPLINK      3               /* arpanet imp addresses */
#define AF_PUP          4               /* pup protocols: e.g. BSP */
#define AF_CHAOS        5               /* mit CHAOS protocols */
#define AF_NS           6               /* XEROX NS protocols */
#define AF_IPX          AF_NS           /* IPX protocols: IPX, SPX, etc. */
#define AF_ISO          7               /* ISO protocols */
#define AF_OSI          AF_ISO          /* OSI is ISO */
#define AF_ECMA         8               /* european computer manufacturers */
#define AF_DATAKIT      9               /* datakit protocols */
#define AF_CCITT        10              /* CCITT protocols, X.25 etc */
#define AF_SNA          11              /* IBM SNA */
#define AF_DECnet       12              /* DECnet */
#define AF_DLI          13              /* Direct data link interface */
#define AF_LAT          14              /* LAT */
#define AF_HYLINK       15              /* NSC Hyperchannel */
#define AF_APPLETALK    16              /* AppleTalk */
#define AF_NETBIOS      17              /* NetBios-style addresses */
#define AF_VOICEVIEW    18              /* VoiceView */
#define AF_FIREFOX      19              /* Protocols from Firefox */
#define AF_UNKNOWN1     20              /* Somebody is using this! */
#define AF_BAN          21              /* Banyan */
#define AF_ATM          22              /* Native ATM Services */
#define AF_INET6        23              /* Internetwork Version 6 */
#define AF_CLUSTER      24              /* Microsoft Wolfpack */
#define AF_12844        25              /* IEEE 1284.4 WG AF */
#define AF_IRDA         26              /* IrDA */

#define AF_MAX          27

/*
** Structure used by kernel to store most
** addresses.
 */
struct sockaddr
{
   u_short sa_family;              /* address family */
   char    sa_data[14];            /* up to 14 bytes of direct address */
};

/*
** Structure used by kernel to pass protocol
** information in raw sockets.
*/
struct sockproto
{
   u_short sp_family;              /* address family */
   u_short sp_protocol;            /* protocol */
};

/*
** Protocol families, same as address families for now.
*/
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK
#define PF_PUP          AF_PUP
#define PF_CHAOS        AF_CHAOS
#define PF_NS           AF_NS
#define PF_IPX          AF_IPX
#define PF_ISO          AF_ISO
#define PF_OSI          AF_OSI
#define PF_ECMA         AF_ECMA
#define PF_DATAKIT      AF_DATAKIT
#define PF_CCITT        AF_CCITT
#define PF_SNA          AF_SNA
#define PF_DECnet       AF_DECnet
#define PF_DLI          AF_DLI
#define PF_LAT          AF_LAT
#define PF_HYLINK       AF_HYLINK
#define PF_APPLETALK    AF_APPLETALK
#define PF_VOICEVIEW    AF_VOICEVIEW
#define PF_FIREFOX      AF_FIREFOX
#define PF_UNKNOWN1     AF_UNKNOWN1
#define PF_BAN          AF_BAN
#define PF_ATM          AF_ATM
#define PF_INET6        AF_INET6

#define PF_MAX          AF_MAX

/*
** Structure used for manipulating linger option.
*/
struct linger
{
   u_short l_onoff;                /* option on/off */
   u_short l_linger;               /* linger time */
};

/*
** Level number for (get/set)sockopt() to apply to socket itself.
*/
#define SOL_SOCKET      0xffff          /* options for socket level */

/*
** Maximum queue length specifiable by listen.
*/
#define SOMAXCONN     0x7fffffff

#define MSG_OOB       0x1          /* process out-of-band data */
#define MSG_PEEK      0x2          /* peek at incoming message */
#define MSG_DONTROUTE 0x4          /* send without using routing tables */

#define MSG_PARTIAL   0x8000       /* partial send or recv for message xport */


/*
** WinSock 2 extension--new flags for WSASend(), WSASendTo(), WSARecv() and
** WSARecvFrom()
*/
#define MSG_INTERRUPT    0x10      /* send/recv in the interrupt context */
#define MSG_MAXIOVLEN    16

/*
** Define constant based on rfc883, used by gethostbyxxxx() calls.
*/
#define MAXGETHOSTSTRUCT 1024

/*
** WinSock 2 extension--bit values and indices for FD_XXX network events
*/
#define FD_READ_BIT      0
#define FD_READ          (1 << FD_READ_BIT)

#define FD_WRITE_BIT     1
#define FD_WRITE         (1 << FD_WRITE_BIT)

#define FD_OOB_BIT       2
#define FD_OOB           (1 << FD_OOB_BIT)

#define FD_ACCEPT_BIT    3
#define FD_ACCEPT        (1 << FD_ACCEPT_BIT)

#define FD_CONNECT_BIT   4
#define FD_CONNECT       (1 << FD_CONNECT_BIT)

#define FD_CLOSE_BIT     5
#define FD_CLOSE         (1 << FD_CLOSE_BIT)

#define FD_QOS_BIT       6
#define FD_QOS           (1 << FD_QOS_BIT)

#define FD_GROUP_QOS_BIT 7
#define FD_GROUP_QOS     (1 << FD_GROUP_QOS_BIT)

#define FD_ROUTING_INTERFACE_CHANGE_BIT 8
#define FD_ROUTING_INTERFACE_CHANGE     (1 << FD_ROUTING_INTERFACE_CHANGE_BIT)

#define FD_ADDRESS_LIST_CHANGE_BIT      9
#define FD_ADDRESS_LIST_CHANGE          (1 << FD_ADDRESS_LIST_CHANGE_BIT)

#define FD_MAX_EVENTS                   10
#define FD_ALL_EVENTS                   ((1 << FD_MAX_EVENTS) - 1)

/*
** WinSock error codes are also defined in winerror.h hence the IFDEF.
*/
#ifndef WSABASEERR

/*
** All Windows Sockets error constants are biased by WSABASEERR from
** the "normal."
*/
# define WSABASEERR              10000

/*
** Windows Sockets definitions of regular Microsoft C error constants
*/
# define WSAEINTR                (WSABASEERR+4)
# define WSAEBADF                (WSABASEERR+9)
# define WSAEACCES               (WSABASEERR+13)
# define WSAEFAULT               (WSABASEERR+14)
# define WSAEINVAL               (WSABASEERR+22)
# define WSAEMFILE               (WSABASEERR+24)

/*
** Windows Sockets definitions of regular Berkeley error constants
*/
# define WSAEWOULDBLOCK          (WSABASEERR+35)
# define WSAEINPROGRESS          (WSABASEERR+36)
# define WSAEALREADY             (WSABASEERR+37)
# define WSAENOTSOCK             (WSABASEERR+38)
# define WSAEDESTADDRREQ         (WSABASEERR+39)
# define WSAEMSGSIZE             (WSABASEERR+40)
# define WSAEPROTOTYPE           (WSABASEERR+41)
# define WSAENOPROTOOPT          (WSABASEERR+42)
# define WSAEPROTONOSUPPORT      (WSABASEERR+43)
# define WSAESOCKTNOSUPPORT      (WSABASEERR+44)
# define WSAEOPNOTSUPP           (WSABASEERR+45)
# define WSAEPFNOSUPPORT         (WSABASEERR+46)
# define WSAEAFNOSUPPORT         (WSABASEERR+47)
# define WSAEADDRINUSE           (WSABASEERR+48)
# define WSAEADDRNOTAVAIL        (WSABASEERR+49)
# define WSAENETDOWN             (WSABASEERR+50)
# define WSAENETUNREACH          (WSABASEERR+51)
# define WSAENETRESET            (WSABASEERR+52)
# define WSAECONNABORTED         (WSABASEERR+53)
# define WSAECONNRESET           (WSABASEERR+54)
# define WSAENOBUFS              (WSABASEERR+55)
# define WSAEISCONN              (WSABASEERR+56)
# define WSAENOTCONN             (WSABASEERR+57)
# define WSAESHUTDOWN            (WSABASEERR+58)
# define WSAETOOMANYREFS         (WSABASEERR+59)
# define WSAETIMEDOUT            (WSABASEERR+60)
# define WSAECONNREFUSED         (WSABASEERR+61)
# define WSAELOOP                (WSABASEERR+62)
# define WSAENAMETOOLONG         (WSABASEERR+63)
# define WSAEHOSTDOWN            (WSABASEERR+64)
# define WSAEHOSTUNREACH         (WSABASEERR+65)
# define WSAENOTEMPTY            (WSABASEERR+66)
# define WSAEPROCLIM             (WSABASEERR+67)
# define WSAEUSERS               (WSABASEERR+68)
# define WSAEDQUOT               (WSABASEERR+69)
# define WSAESTALE               (WSABASEERR+70)
# define WSAEREMOTE              (WSABASEERR+71)

/*
** Extended Windows Sockets error constant definitions
*/
# define WSASYSNOTREADY          (WSABASEERR+91)
# define WSAVERNOTSUPPORTED      (WSABASEERR+92)
# define WSANOTINITIALISED       (WSABASEERR+93)
# define WSAEDISCON              (WSABASEERR+101)
# define WSAENOMORE              (WSABASEERR+102)
# define WSAECANCELLED           (WSABASEERR+103)
# define WSAEINVALIDPROCTABLE    (WSABASEERR+104)
# define WSAEINVALIDPROVIDER     (WSABASEERR+105)
# define WSAEPROVIDERFAILEDINIT  (WSABASEERR+106)
# define WSASYSCALLFAILURE       (WSABASEERR+107)
# define WSASERVICE_NOT_FOUND    (WSABASEERR+108)
# define WSATYPE_NOT_FOUND       (WSABASEERR+109)
# define WSA_E_NO_MORE           (WSABASEERR+110)
# define WSA_E_CANCELLED         (WSABASEERR+111)
# define WSAEREFUSED             (WSABASEERR+112)

/*
** Error return codes from gethostbyname() and gethostbyaddr() (when using the
** resolver). Note that these errors are retrieved via WSAGetLastError() and
** must therefore follow the rules for avoiding clashes with error numbers
** from specific implementations or language run-time systems. For this reason
** the codes are based at WSABASEERR+1001. Note also that [WSA]NO_ADDRESS is
** defined only for compatibility purposes.
*/

/* Authoritative Answer: Host not found */
# define WSAHOST_NOT_FOUND       (WSABASEERR+1001)

/* Non-Authoritative: Host not found, or SERVERFAIL */
# define WSATRY_AGAIN            (WSABASEERR+1002)

/* Non-recoverable errors, FORMERR, REFUSED, NOTIMP */
# define WSANO_RECOVERY          (WSABASEERR+1003)

/* Valid name, no data record of requested type */
# define WSANO_DATA              (WSABASEERR+1004)

/*
** Define QOS related error return codes
*/
# define  WSA_QOS_RECEIVERS               (WSABASEERR + 1005)
         /* at least one Reserve has arrived */
# define  WSA_QOS_SENDERS                 (WSABASEERR + 1006)
         /* at least one Path has arrived */
# define  WSA_QOS_NO_SENDERS              (WSABASEERR + 1007)  
         /* there are no senders */
# define  WSA_QOS_NO_RECEIVERS            (WSABASEERR + 1008) 
         /* there are no receivers */
# define  WSA_QOS_REQUEST_CONFIRMED       (WSABASEERR + 1009)
         /* Reserve has been confirmed */
# define  WSA_QOS_ADMISSION_FAILURE       (WSABASEERR + 1010)
         /* error due to lack of resources */
# define  WSA_QOS_POLICY_FAILURE          (WSABASEERR + 1011)
         /* rejected for administrative reasons - bad credentials */
# define  WSA_QOS_BAD_STYLE               (WSABASEERR + 1012)
         /* unknown or conflicting style */
# define  WSA_QOS_BAD_OBJECT              (WSABASEERR + 1013)
         /* problem with some part of the filterspec or providerspecific
          * buffer in general */
# define  WSA_QOS_TRAFFIC_CTRL_ERROR      (WSABASEERR + 1014)
         /* problem with some part of the flowspec */
# define  WSA_QOS_GENERIC_ERROR           (WSABASEERR + 1015) 
         /* general error */

/*
** WinSock error codes are also defined in winerror.h hence the IFDEF.
*/
#endif /* ifdef WSABASEERR */

/*
** Compatibility macros.
*/
#define h_errno                 WSAGetLastError()
#define HOST_NOT_FOUND          WSAHOST_NOT_FOUND
#define TRY_AGAIN               WSATRY_AGAIN
#define NO_RECOVERY             WSANO_RECOVERY
#define NO_DATA                 WSANO_DATA

/* no address, look for MX record */
#define WSANO_ADDRESS           WSANO_DATA
#define NO_ADDRESS              WSANO_ADDRESS

/*
** Windows Sockets errors redefined as regular Berkeley error constants.
** These are commented out in Windows NT to avoid conflicts with errno.h.
** Use the WSA constants instead.
*/
#if 0
#define EWOULDBLOCK     WSAEWOULDBLOCK
#define EINPROGRESS     WSAEINPROGRESS
#define EALREADY        WSAEALREADY
#define ENOTSOCK        WSAENOTSOCK
#define EDESTADDRREQ    WSAEDESTADDRREQ
#define EMSGSIZE        WSAEMSGSIZE
#define EPROTOTYPE      WSAEPROTOTYPE
#define ENOPROTOOPT     WSAENOPROTOOPT
#define EPROTONOSUPPORT WSAEPROTONOSUPPORT
#define ESOCKTNOSUPPORT WSAESOCKTNOSUPPORT
#define EOPNOTSUPP      WSAEOPNOTSUPP
#define EPFNOSUPPORT    WSAEPFNOSUPPORT
#define EAFNOSUPPORT    WSAEAFNOSUPPORT
#define EADDRINUSE      WSAEADDRINUSE
#define EADDRNOTAVAIL   WSAEADDRNOTAVAIL
#define ENETDOWN        WSAENETDOWN
#define ENETUNREACH     WSAENETUNREACH
#define ENETRESET       WSAENETRESET
#define ECONNABORTED    WSAECONNABORTED
#define ECONNRESET      WSAECONNRESET
#define ENOBUFS         WSAENOBUFS
#define EISCONN         WSAEISCONN
#define ENOTCONN        WSAENOTCONN
#define ESHUTDOWN       WSAESHUTDOWN
#define ETOOMANYREFS    WSAETOOMANYREFS
#define ETIMEDOUT       WSAETIMEDOUT
#define ECONNREFUSED    WSAECONNREFUSED
#define ELOOP           WSAELOOP
#define ENAMETOOLONG    WSAENAMETOOLONG
#define EHOSTDOWN       WSAEHOSTDOWN
#define EHOSTUNREACH    WSAEHOSTUNREACH
#define ENOTEMPTY       WSAENOTEMPTY
#define EPROCLIM        WSAEPROCLIM
#define EUSERS          WSAEUSERS
#define EDQUOT          WSAEDQUOT
#define ESTALE          WSAESTALE
#define EREMOTE         WSAEREMOTE
#endif

/*
** WinSock 2 extension--new error codes and type definition
*/
#define WSAAPI                  PASCAL
#define WSAEVENT                HANDLE
#define LPWSAEVENT              LPHANDLE
#define WSAOVERLAPPED           OVERLAPPED
typedef struct _OVERLAPPED     *LPWSAOVERLAPPED;

#define WSA_IO_PENDING          (ERROR_IO_PENDING)
#define WSA_IO_INCOMPLETE       (ERROR_IO_INCOMPLETE)
#define WSA_INVALID_HANDLE      (ERROR_INVALID_HANDLE)
#define WSA_INVALID_PARAMETER   (ERROR_INVALID_PARAMETER)
#define WSA_NOT_ENOUGH_MEMORY   (ERROR_NOT_ENOUGH_MEMORY)
#define WSA_OPERATION_ABORTED   (ERROR_OPERATION_ABORTED)

#define WSA_INVALID_EVENT       ((WSAEVENT)NULL)
#define WSA_MAXIMUM_WAIT_EVENTS (MAXIMUM_WAIT_OBJECTS)
#define WSA_WAIT_FAILED         (WAIT_FAILED)
#define WSA_WAIT_EVENT_0        (WAIT_OBJECT_0)
#define WSA_WAIT_IO_COMPLETION  (WAIT_IO_COMPLETION)
#define WSA_WAIT_TIMEOUT        (WAIT_TIMEOUT)
#define WSA_INFINITE            (INFINITE)


/*
** WinSock 2 extension--WSABUF and QOS struct, include qos.h to pull in
** FLOWSPEC and related definitions
*/
typedef struct _WSABUF
{
   u_long  len;     /* the length of the buffer */
   char   *buf;     /* the pointer to the buffer */
} WSABUF, *LPWSABUF;


#include <qos.h>


typedef struct _QualityOfService
{
   FLOWSPEC     SendingFlowspec;       /* the flow spec for data sending */
   FLOWSPEC     ReceivingFlowspec;     /* the flow spec for data receiving */
   WSABUF       ProviderSpecific;      /* additional provider specific stuff */
} QOS, *LPQOS;

/*
** WinSock 2 extension--manifest constants for return values of the condition
** function.
*/
#define CF_ACCEPT       0x0000
#define CF_REJECT       0x0001
#define CF_DEFER        0x0002

/*
** WinSock 2 extension--manifest constants for shutdown()
*/
#define SD_RECEIVE      0x00
#define SD_SEND         0x01
#define SD_BOTH         0x02

/*
** WinSock 2 extension--data type and manifest constants for socket groups
*/
typedef unsigned int             GROUP;

#define SG_UNCONSTRAINED_GROUP   0x01
#define SG_CONSTRAINED_GROUP     0x02


/*
** WinSock 2 extension--data type for WSAEnumNetworkEvents()
*/
typedef struct _WSANETWORKEVENTS
{
   long lNetworkEvents;
   int  iErrorCode[FD_MAX_EVENTS];
} WSANETWORKEVENTS, * LPWSANETWORKEVENTS;

/*
** WinSock 2 extension--WSAPROTOCOL_INFO structure and associated
** manifest constants
*/
#ifndef GUID_DEFINED
# define GUID_DEFINED
typedef struct _GUID
{
   unsigned long  Data1;
   unsigned short Data2;
   unsigned short Data3;
   unsigned char  Data4[8];
} GUID;
#endif

#ifndef __LPGUID_DEFINED__
# define __LPGUID_DEFINED__
typedef GUID *LPGUID;
#endif

#define MAX_PROTOCOL_CHAIN 7

#define BASE_PROTOCOL      1
#define LAYERED_PROTOCOL   0

typedef struct _WSAPROTOCOLCHAIN
{
   int    ChainLen;                        /* the length of the chain,     */
                                           /* == 0 means layered protocol, */
                                           /* == 1 means base protocol,    */
                                           /*  > 1 means protocol chain    */
    DWORD ChainEntries[MAX_PROTOCOL_CHAIN];/* a list of dwCatalogEntryIds  */
} WSAPROTOCOLCHAIN, *LPWSAPROTOCOLCHAIN;

#define WSAPROTOCOL_LEN  255

typedef struct _WSAPROTOCOL_INFOA
{
   DWORD            dwServiceFlags1;
   DWORD            dwServiceFlags2;
   DWORD            dwServiceFlags3;
   DWORD            dwServiceFlags4;
   DWORD            dwProviderFlags;
   GUID               ProviderId;
   DWORD            dwCatalogEntryId;
   WSAPROTOCOLCHAIN   ProtocolChain;
   int               iVersion;
   int               iAddressFamily;
   int               iMaxSockAddr;
   int               iMinSockAddr;
   int               iSocketType;
   int               iProtocol;
   int               iProtocolMaxOffset;
   int               iNetworkByteOrder;
   int               iSecurityScheme;
   DWORD            dwMessageSize;
   DWORD            dwProviderReserved;
   CHAR             szProtocol[WSAPROTOCOL_LEN+1];
} WSAPROTOCOL_INFOA, * LPWSAPROTOCOL_INFOA;

typedef struct _WSAPROTOCOL_INFOW
{
   DWORD            dwServiceFlags1;
   DWORD            dwServiceFlags2;
   DWORD            dwServiceFlags3;
   DWORD            dwServiceFlags4;
   DWORD            dwProviderFlags;
   GUID               ProviderId;
   DWORD            dwCatalogEntryId;
   WSAPROTOCOLCHAIN   ProtocolChain;
   int               iVersion;
   int               iAddressFamily;
   int               iMaxSockAddr;
   int               iMinSockAddr;
   int               iSocketType;
   int               iProtocol;
   int               iProtocolMaxOffset;
   int               iNetworkByteOrder;
   int               iSecurityScheme;
   DWORD            dwMessageSize;
   DWORD            dwProviderReserved;
   WCHAR            szProtocol[WSAPROTOCOL_LEN+1];
} WSAPROTOCOL_INFOW, *LPWSAPROTOCOL_INFOW;

#ifdef UNICODE
typedef WSAPROTOCOL_INFOW WSAPROTOCOL_INFO;
typedef LPWSAPROTOCOL_INFOW LPWSAPROTOCOL_INFO;
#else
typedef WSAPROTOCOL_INFOA WSAPROTOCOL_INFO;
typedef LPWSAPROTOCOL_INFOA LPWSAPROTOCOL_INFO;
#endif

/* Flag bit definitions for dwProviderFlags */
#define PFL_MULTIPLE_PROTO_ENTRIES          0x00000001
#define PFL_RECOMMENDED_PROTO_ENTRY         0x00000002
#define PFL_HIDDEN                          0x00000004
#define PFL_MATCHES_PROTOCOL_ZERO           0x00000008

/* Flag bit definitions for dwServiceFlags1 */
#define XP1_CONNECTIONLESS                  0x00000001
#define XP1_GUARANTEED_DELIVERY             0x00000002
#define XP1_GUARANTEED_ORDER                0x00000004
#define XP1_MESSAGE_ORIENTED                0x00000008
#define XP1_PSEUDO_STREAM                   0x00000010
#define XP1_GRACEFUL_CLOSE                  0x00000020
#define XP1_EXPEDITED_DATA                  0x00000040
#define XP1_CONNECT_DATA                    0x00000080
#define XP1_DISCONNECT_DATA                 0x00000100
#define XP1_SUPPORT_BROADCAST               0x00000200
#define XP1_SUPPORT_MULTIPOINT              0x00000400
#define XP1_MULTIPOINT_CONTROL_PLANE        0x00000800
#define XP1_MULTIPOINT_DATA_PLANE           0x00001000
#define XP1_QOS_SUPPORTED                   0x00002000
#define XP1_INTERRUPT                       0x00004000
#define XP1_UNI_SEND                        0x00008000
#define XP1_UNI_RECV                        0x00010000
#define XP1_IFS_HANDLES                     0x00020000
#define XP1_PARTIAL_MESSAGE                 0x00040000

#define BIGENDIAN                           0x0000
#define LITTLEENDIAN                        0x0001

#define SECURITY_PROTOCOL_NONE              0x0000

/*
** WinSock 2 extension--manifest constants for WSAJoinLeaf()
*/
#define JL_SENDER_ONLY    0x01
#define JL_RECEIVER_ONLY  0x02
#define JL_BOTH           0x04

/*
** WinSock 2 extension--manifest constants for WSASocket()
*/
#define WSA_FLAG_OVERLAPPED           0x01
#define WSA_FLAG_MULTIPOINT_C_ROOT    0x02
#define WSA_FLAG_MULTIPOINT_C_LEAF    0x04
#define WSA_FLAG_MULTIPOINT_D_ROOT    0x08
#define WSA_FLAG_MULTIPOINT_D_LEAF    0x10

/*
** WinSock 2 extension--manifest constants for WSAIoctl()
*/
#define IOC_UNIX                      0x00000000
#define IOC_WS2                       0x08000000
#define IOC_PROTOCOL                  0x10000000
#define IOC_VENDOR                    0x18000000

#define _WSAIO(x,y)                   (IOC_VOID|(x)|(y))
#define _WSAIOR(x,y)                  (IOC_OUT|(x)|(y))
#define _WSAIOW(x,y)                  (IOC_IN|(x)|(y))
#define _WSAIORW(x,y)                 (IOC_INOUT|(x)|(y))

#define SIO_ASSOCIATE_HANDLE          _WSAIOW(IOC_WS2,1)
#define SIO_ENABLE_CIRCULAR_QUEUEING  _WSAIO(IOC_WS2,2)
#define SIO_FIND_ROUTE                _WSAIOR(IOC_WS2,3)
#define SIO_FLUSH                     _WSAIO(IOC_WS2,4)
#define SIO_GET_BROADCAST_ADDRESS     _WSAIOR(IOC_WS2,5)
#define SIO_GET_EXTENSION_FUNCTION_POINTER  _WSAIORW(IOC_WS2,6)
#define SIO_GET_QOS                   _WSAIORW(IOC_WS2,7)
#define SIO_GET_GROUP_QOS             _WSAIORW(IOC_WS2,8)
#define SIO_MULTIPOINT_LOOPBACK       _WSAIOW(IOC_WS2,9)
#define SIO_MULTICAST_SCOPE           _WSAIOW(IOC_WS2,10)
#define SIO_SET_QOS                   _WSAIOW(IOC_WS2,11)
#define SIO_SET_GROUP_QOS             _WSAIOW(IOC_WS2,12)
#define SIO_TRANSLATE_HANDLE          _WSAIORW(IOC_WS2,13)
#define SIO_ROUTING_INTERFACE_QUERY   _WSAIORW(IOC_WS2,20)
#define SIO_ROUTING_INTERFACE_CHANGE  _WSAIOW(IOC_WS2,21)
#define SIO_ADDRESS_LIST_QUERY        _WSAIOR(IOC_WS2,22)
#define SIO_ADDRESS_LIST_CHANGE       _WSAIO(IOC_WS2,23)
#define SIO_QUERY_TARGET_PNP_HANDLE   _WSAIOR(IOC_W32,24)

/*
** WinSock 2 extension--manifest constants for SIO_TRANSLATE_HANDLE ioctl
*/
#define TH_NETDEV        0x00000001
#define TH_TAPI          0x00000002

/*-----------------------------------------------------------------------------
** Registration and naming prototypes
**-----------------------------------------------------------------------------
*/
#include <ws2name.h>

/*-----------------------------------------------------------------------------
** Socket function prototypes
**-----------------------------------------------------------------------------
*/
#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
accept(
    IN SOCKET s,
    OUT struct sockaddr * addr,
    IN OUT int * addrlen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
SOCKET
(WSAAPI * LPFN_ACCEPT)(
    IN SOCKET s,
    OUT struct sockaddr * addr,
    IN OUT int * addrlen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
bind(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_BIND)(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
closesocket(
    IN SOCKET s
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_CLOSESOCKET)(
    IN SOCKET s
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
connect(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_CONNECT)(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
ioctlsocket(
    IN SOCKET s,
    IN long cmd,
    IN OUT u_long * argp
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_IOCTLSOCKET)(
    IN SOCKET s,
    IN long cmd,
    IN OUT u_long * argp
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
getpeername(
    IN SOCKET s,
    OUT struct sockaddr * name,
    IN OUT int * namelen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_GETPEERNAME)(
    IN SOCKET s,
    IN struct sockaddr * name,
    IN OUT int * namelen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
getsockname(
    IN SOCKET s,
    OUT struct sockaddr * name,
    IN OUT int * namelen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_GETSOCKNAME)(
    IN SOCKET s,
    OUT struct sockaddr * name,
    IN OUT int * namelen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
getsockopt(
    IN SOCKET s,
    IN int level,
    IN int optname,
    OUT char * optval,
    IN OUT int * optlen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_GETSOCKOPT)(
    IN SOCKET s,
    IN int level,
    IN int optname,
    OUT char * optval,
    IN OUT int * optlen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
u_long
WSAAPI
htonl(
    IN u_long hostlong
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
u_long
(WSAAPI * LPFN_HTONL)(
    IN u_long hostlong
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
u_short
WSAAPI
htons(
    IN u_short hostshort
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
u_short
(WSAAPI * LPFN_HTONS)(
    IN u_short hostshort
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
unsigned long
WSAAPI
inet_addr(
    IN const char * cp
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
unsigned long
(WSAAPI * LPFN_INET_ADDR)(
    IN const char * cp
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
char *
WSAAPI
inet_ntoa(
    IN struct in_addr in
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
char *
(WSAAPI * LPFN_INET_NTOA)(
    IN struct in_addr in
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
listen(
    IN SOCKET s,
    IN int backlog
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_LISTEN)(
    IN SOCKET s,
    IN int backlog
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
u_long
WSAAPI
ntohl(
    IN u_long netlong
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
u_long
(WSAAPI * LPFN_NTOHL)(
    IN u_long netlong
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
u_short
WSAAPI
ntohs(
    IN u_short netshort
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
u_short
(WSAAPI * LPFN_NTOHS)(
    IN u_short netshort
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
recv(
    IN SOCKET s,
    OUT char * buf,
    IN int len,
    IN int flags
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_RECV)(
    IN SOCKET s,
    OUT char * buf,
    IN int len,
    IN int flags
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
recvfrom(
    IN SOCKET s,
    OUT char * buf,
    IN int len,
    IN int flags,
    OUT struct sockaddr * from,
    IN OUT int * fromlen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_RECVFROM)(
    IN SOCKET s,
    OUT char * buf,
    IN int len,
    IN int flags,
    OUT struct sockaddr * from,
    IN OUT int * fromlen
    );
#endif

/*
** This function is prototyped in sys/select.h rather than here...
int select( int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
      const struct timeval *timeout );
*/

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_SELECT)(
    IN int nfds,
    IN OUT fd_set * readfds,
    IN OUT fd_set * writefds,
    IN OUT fd_set *exceptfds,
    IN const struct timeval * timeout
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
send(
    IN SOCKET s,
    IN const char * buf,
    IN int len,
    IN int flags
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_SEND)(
    IN SOCKET s,
    IN const char * buf,
    IN int len,
    IN int flags
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
sendto(
    IN SOCKET s,
    IN const char * buf,
    IN int len,
    IN int flags,
    IN const struct sockaddr * to,
    IN int tolen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_SENDTO)(
    IN SOCKET s,
    IN const char * buf,
    IN int len,
    IN int flags,
    IN const struct sockaddr * to,
    IN int tolen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
setsockopt(
    IN SOCKET s,
    IN int level,
    IN int optname,
    IN const char * optval,
    IN int optlen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_SETSOCKOPT)(
    IN SOCKET s,
    IN int level,
    IN int optname,
    IN const char * optval,
    IN int optlen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
shutdown(
    IN SOCKET s,
    IN int how
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_SHUTDOWN)(
    IN SOCKET s,
    IN int how
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
socket(
    IN int af,
    IN int type,
    IN int protocol
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
SOCKET
(WSAAPI * LPFN_SOCKET)(
    IN int af,
    IN int type,
    IN int protocol
    );
#endif

/* Database function prototypes */

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct hostent *
WSAAPI
gethostbyaddr(
    IN const char * addr,
    IN int len,
    IN int type
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct hostent *
(WSAAPI * LPFN_GETHOSTBYADDR)(
    IN const char * addr,
    IN int len,
    IN int type
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct hostent *
WSAAPI
gethostbyname(
    IN const char * name
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct hostent *
(WSAAPI * LPFN_GETHOSTBYNAME)(
    IN const char * name
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
gethostname(
    OUT char * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_GETHOSTNAME)(
    OUT char * name,
    IN int namelen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct servent *
WSAAPI
getservbyport(
    IN int port,
    IN const char * proto
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct servent *
(WSAAPI * LPFN_GETSERVBYPORT)(
    IN int port,
    IN const char * proto
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct servent *
WSAAPI
getservbyname(
    IN const char * name,
    IN const char * proto
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct servent *
(WSAAPI * LPFN_GETSERVBYNAME)(
    IN const char * name,
    IN const char * proto
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct protoent *
WSAAPI
getprotobynumber(
    IN int number
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct protoent *
(WSAAPI * LPFN_GETPROTOBYNUMBER)(
    IN int number
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
struct protoent *
WSAAPI
getprotobyname(
    IN const char * name
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
struct protoent *
(WSAAPI * LPFN_GETPROTOBYNAME)(
    IN const char * name
    );
#endif

/* Microsoft Windows Extension function prototypes */

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAStartup(
    IN WORD wVersionRequested,
    OUT LPWSADATA lpWSAData
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSASTARTUP)(
    IN WORD wVersionRequested,
    OUT LPWSADATA lpWSAData
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSACleanup(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSACLEANUP)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
void
WSAAPI
WSASetLastError(
    IN int iError
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
void
(WSAAPI * LPFN_WSASETLASTERROR)(
    IN int iError
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAGetLastError(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAGETLASTERROR)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSAIsBlocking(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSAISBLOCKING)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAUnhookBlockingHook(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAUNHOOKBLOCKINGHOOK)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
FARPROC
WSAAPI
WSASetBlockingHook(
    IN FARPROC lpBlockFunc
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
FARPROC
(WSAAPI * LPFN_WSASETBLOCKINGHOOK)(
    IN FARPROC lpBlockFunc
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSACancelBlockingCall(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSACANCELBLOCKINGCALL)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetServByName(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    IN const char * proto,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETSERVBYNAME)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    IN const char * proto,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetServByPort(
    IN HWND hWnd,
    IN u_int wMsg,
    IN int port,
    IN const char * proto,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETSERVBYPORT)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN int port,
    IN const char * proto,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetProtoByName(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETPROTOBYNAME)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetProtoByNumber(
    IN HWND hWnd,
    IN u_int wMsg,
    IN int number,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETPROTOBYNUMBER)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN int number,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetHostByName(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETHOSTBYNAME)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * name,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
HANDLE
WSAAPI
WSAAsyncGetHostByAddr(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * addr,
    IN int len,
    IN int type,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
HANDLE
(WSAAPI * LPFN_WSAASYNCGETHOSTBYADDR)(
    IN HWND hWnd,
    IN u_int wMsg,
    IN const char * addr,
    IN int len,
    IN int type,
    OUT char * buf,
    IN int buflen
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSACancelAsyncRequest(
    IN HANDLE hAsyncTaskHandle
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSACANCELASYNCREQUEST)(
    IN HANDLE hAsyncTaskHandle
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAAsyncSelect(
    IN SOCKET s,
    IN HWND hWnd,
    IN u_int wMsg,
    IN long lEvent
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAASYNCSELECT)(
    IN SOCKET s,
    IN HWND hWnd,
    IN u_int wMsg,
    IN long lEvent
    );
#endif


/*-----------------------------------------------------------------------------
** WinSock 2 extensions--data types for the condition function in WSAAccept()
** and overlapped I/O completion routine.
**-----------------------------------------------------------------------------
*/
typedef
int
(CALLBACK * LPCONDITIONPROC)(
    IN LPWSABUF lpCallerId,
    IN LPWSABUF lpCallerData,
    IN OUT LPQOS lpSQOS,
    IN OUT LPQOS lpGQOS,
    IN LPWSABUF lpCalleeId,
    IN LPWSABUF lpCalleeData,
    OUT GROUP * g,
#ifdef _WIN64
    IN ULONG_PTR dwCallbackData
#else
    IN DWORD dwCallbackData
#endif
    );

typedef
void
(CALLBACK * LPWSAOVERLAPPED_COMPLETION_ROUTINE)(
    IN DWORD dwError,
    IN DWORD cbTransferred,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN DWORD dwFlags
    );

/*-----------------------------------------------------------------------------
** WinSock 2 API new function prototypes
**-----------------------------------------------------------------------------
*/
#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
WSAAccept(
    IN SOCKET s,
    OUT struct sockaddr * addr,
    IN OUT LPINT addrlen,
    IN LPCONDITIONPROC lpfnCondition,
#ifdef _WIN64
    IN ULONG_PTR dwCallbackData
#else
    IN DWORD dwCallbackData
#endif
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
SOCKET
(WSAAPI * LPFN_WSAACCEPT)(
    IN SOCKET s,
    OUT struct sockaddr * addr,
    IN OUT LPINT addrlen,
    IN LPCONDITIONPROC lpfnCondition,
#ifdef _WIN64
    IN ULONG_PTR dwCallbackData
#else
    IN DWORD dwCallbackData
#endif
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSACloseEvent(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSACLOSEEVENT)(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAConnect(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen,
    IN LPWSABUF lpCallerData,
    OUT LPWSABUF lpCalleeData,
    IN LPQOS lpSQOS,
    IN LPQOS lpGQOS
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSACONNECT)(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen,
    IN LPWSABUF lpCallerData,
    OUT LPWSABUF lpCalleeData,
    IN LPQOS lpSQOS,
    IN LPQOS lpGQOS
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
WSAEVENT
WSAAPI
WSACreateEvent(
    void
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
WSAEVENT
(WSAAPI * LPFN_WSACREATEEVENT)(
    void
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSADuplicateSocketA(
    IN SOCKET s,
    IN DWORD dwProcessId,
    OUT LPWSAPROTOCOL_INFOA lpProtocolInfo
    );
WINSOCK_API_LINKAGE
int
WSAAPI
WSADuplicateSocketW(
    IN SOCKET s,
    IN DWORD dwProcessId,
    OUT LPWSAPROTOCOL_INFOW lpProtocolInfo
    );
#ifdef UNICODE
#define WSADuplicateSocket  WSADuplicateSocketW
#else
#define WSADuplicateSocket  WSADuplicateSocketA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSADUPLICATESOCKETA)(
    IN SOCKET s,
    IN DWORD dwProcessId,
    OUT LPWSAPROTOCOL_INFOA lpProtocolInfo
    );
typedef
int
(WSAAPI * LPFN_WSADUPLICATESOCKETW)(
    IN SOCKET s,
    IN DWORD dwProcessId,
    OUT LPWSAPROTOCOL_INFOW lpProtocolInfo
    );
#ifdef UNICODE
#define LPFN_WSADUPLICATESOCKET  LPFN_WSADUPLICATESOCKETW
#else
#define LPFN_WSADUPLICATESOCKET  LPFN_WSADUPLICATESOCKETA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAEnumNetworkEvents(
    IN SOCKET s,
    IN WSAEVENT hEventObject,
    OUT LPWSANETWORKEVENTS lpNetworkEvents
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAENUMNETWORKEVENTS)(
    IN SOCKET s,
    IN WSAEVENT hEventObject,
    OUT LPWSANETWORKEVENTS lpNetworkEvents
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAEnumProtocolsA(
    IN LPINT lpiProtocols,
    OUT LPWSAPROTOCOL_INFOA lpProtocolBuffer,
    IN OUT LPDWORD lpdwBufferLength
    );
WINSOCK_API_LINKAGE
int
WSAAPI
WSAEnumProtocolsW(
    IN LPINT lpiProtocols,
    OUT LPWSAPROTOCOL_INFOW lpProtocolBuffer,
    IN OUT LPDWORD lpdwBufferLength
    );
#ifdef UNICODE
#define WSAEnumProtocols  WSAEnumProtocolsW
#else
#define WSAEnumProtocols  WSAEnumProtocolsA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAENUMPROTOCOLSA)(
    IN LPINT lpiProtocols,
    OUT LPWSAPROTOCOL_INFOA lpProtocolBuffer,
    IN OUT LPDWORD lpdwBufferLength
    );
typedef
int
(WSAAPI * LPFN_WSAENUMPROTOCOLSW)(
    IN LPINT lpiProtocols,
    OUT LPWSAPROTOCOL_INFOW lpProtocolBuffer,
    IN OUT LPDWORD lpdwBufferLength
    );
#ifdef UNICODE
#define LPFN_WSAENUMPROTOCOLS  LPFN_WSAENUMPROTOCOLSW
#else
#define LPFN_WSAENUMPROTOCOLS  LPFN_WSAENUMPROTOCOLSA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAEventSelect(
    IN SOCKET s,
    IN WSAEVENT hEventObject,
    IN long lNetworkEvents
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAEVENTSELECT)(
    IN SOCKET s,
    IN WSAEVENT hEventObject,
    IN long lNetworkEvents
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSAGetOverlappedResult(
    IN SOCKET s,
    IN LPWSAOVERLAPPED lpOverlapped,
    OUT LPDWORD lpcbTransfer,
    IN BOOL fWait,
    OUT LPDWORD lpdwFlags
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSAGETOVERLAPPEDRESULT)(
    IN SOCKET s,
    IN LPWSAOVERLAPPED lpOverlapped,
    OUT LPDWORD lpcbTransfer,
    IN BOOL fWait,
    OUT LPDWORD lpdwFlags
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSAGetQOSByName(
    IN SOCKET s,
    IN LPWSABUF lpQOSName,
    OUT LPQOS lpQOS
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSAGETQOSBYNAME)(
    IN SOCKET s,
    IN LPWSABUF lpQOSName,
    OUT LPQOS lpQOS
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAHtonl(
    IN SOCKET s,
    IN u_long hostlong,
    OUT u_long * lpnetlong
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAHTONL)(
    IN SOCKET s,
    IN u_long hostlong,
    OUT u_long * lpnetlong
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAHtons(
    IN SOCKET s,
    IN u_short hostshort,
    OUT u_short * lpnetshort
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAHTONS)(
    IN SOCKET s,
    IN u_short hostshort,
    OUT u_short * lpnetshort
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSAIoctl(
    IN SOCKET s,
    IN DWORD dwIoControlCode,
    IN LPVOID lpvInBuffer,
    IN DWORD cbInBuffer,
    OUT LPVOID lpvOutBuffer,
    IN DWORD cbOutBuffer,
    OUT LPDWORD lpcbBytesReturned,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSAIOCTL)(
    IN SOCKET s,
    IN DWORD dwIoControlCode,
    IN LPVOID lpvInBuffer,
    IN DWORD cbInBuffer,
    OUT LPVOID lpvOutBuffer,
    IN DWORD cbOutBuffer,
    OUT LPDWORD lpcbBytesReturned,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
WSAJoinLeaf(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen,
    IN LPWSABUF lpCallerData,
    OUT LPWSABUF lpCalleeData,
    IN LPQOS lpSQOS,
    IN LPQOS lpGQOS,
    IN DWORD dwFlags
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
SOCKET
(WSAAPI * LPFN_WSAJOINLEAF)(
    IN SOCKET s,
    IN const struct sockaddr * name,
    IN int namelen,
    IN LPWSABUF lpCallerData,
    OUT LPWSABUF lpCalleeData,
    IN LPQOS lpSQOS,
    IN LPQOS lpGQOS,
    IN DWORD dwFlags
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSANtohl(
    IN SOCKET s,
    IN u_long netlong,
    OUT u_long * lphostlong
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSANTOHL)(
    IN SOCKET s,
    IN u_long netlong,
    OUT u_long * lphostlong
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSANtohs(
    IN SOCKET s,
    IN u_short netshort,
    OUT u_short * lphostshort
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSANTOHS)(
    IN SOCKET s,
    IN u_short netshort,
    OUT u_short * lphostshort
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSARecv(
    IN SOCKET s,
    IN OUT LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesRecvd,
    IN OUT LPDWORD lpFlags,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSARECV)(
    IN SOCKET s,
    IN OUT LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesRecvd,
    IN OUT LPDWORD lpFlags,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSARecvDisconnect(
    IN SOCKET s,
    OUT LPWSABUF lpInboundDisconnectData
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSARECVDISCONNECT)(
    IN SOCKET s,
    OUT LPWSABUF lpInboundDisconnectData
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSARecvFrom(
    IN SOCKET s,
    IN OUT LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesRecvd,
    IN OUT LPDWORD lpFlags,
    OUT struct sockaddr * lpFrom,
    IN OUT LPINT lpFromlen,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSARECVFROM)(
    IN SOCKET s,
    IN OUT LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesRecvd,
    IN OUT LPDWORD lpFlags,
    OUT struct sockaddr * lpFrom,
    IN OUT LPINT lpFromlen,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSAResetEvent(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSARESETEVENT)(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSASend(
    IN SOCKET s,
    IN LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesSent,
    IN DWORD dwFlags,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSASEND)(
    IN SOCKET s,
    IN LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesSent,
    IN DWORD dwFlags,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSASendDisconnect(
    IN SOCKET s,
    IN LPWSABUF lpOutboundDisconnectData
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSASENDDISCONNECT)(
    IN SOCKET s,
    IN LPWSABUF lpOutboundDisconnectData
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
int
WSAAPI
WSASendTo(
    IN SOCKET s,
    IN LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesSent,
    IN DWORD dwFlags,
    IN const struct sockaddr * lpTo,
    IN int iTolen,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
int
(WSAAPI * LPFN_WSASENDTO)(
    IN SOCKET s,
    IN LPWSABUF lpBuffers,
    IN DWORD dwBufferCount,
    OUT LPDWORD lpNumberOfBytesSent,
    IN DWORD dwFlags,
    IN const struct sockaddr * lpTo,
    IN int iTolen,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
BOOL
WSAAPI
WSASetEvent(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
BOOL
(WSAAPI * LPFN_WSASETEVENT)(
    IN WSAEVENT hEvent
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
WSASocketA(
    IN int af,
    IN int type,
    IN int protocol,
    IN LPWSAPROTOCOL_INFOA lpProtocolInfo,
    IN GROUP g,
    IN DWORD dwFlags
    );
WINSOCK_API_LINKAGE
SOCKET
WSAAPI
WSASocketW(
    IN int af,
    IN int type,
    IN int protocol,
    IN LPWSAPROTOCOL_INFOW lpProtocolInfo,
    IN GROUP g,
    IN DWORD dwFlags
    );
#ifdef UNICODE
#define WSASocket  WSASocketW
#else
#define WSASocket  WSASocketA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
SOCKET
(WSAAPI * LPFN_WSASOCKETA)(
    IN int af,
    IN int type,
    IN int protocol,
    IN LPWSAPROTOCOL_INFOA lpProtocolInfo,
    IN GROUP g,
    IN DWORD dwFlags
    );
typedef
SOCKET
(WSAAPI * LPFN_WSASOCKETW)(
    IN int af,
    IN int type,
    IN int protocol,
    IN LPWSAPROTOCOL_INFOW lpProtocolInfo,
    IN GROUP g,
    IN DWORD dwFlags
    );
#ifdef UNICODE
#define LPFN_WSASOCKET  LPFN_WSASOCKETW
#else
#define LPFN_WSASOCKET  LPFN_WSASOCKETA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
DWORD
WSAAPI
WSAWaitForMultipleEvents(
    IN DWORD cEvents,
    IN const WSAEVENT * lphEvents,
    IN BOOL fWaitAll,
    IN DWORD dwTimeout,
    IN BOOL fAlertable
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
DWORD
(WSAAPI * LPFN_WSAWAITFORMULTIPLEEVENTS)(
    IN DWORD cEvents,
    IN const WSAEVENT * lphEvents,
    IN BOOL fWaitAll,
    IN DWORD dwTimeout,
    IN BOOL fAlertable
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAAddressToStringA(
    IN     LPSOCKADDR          lpsaAddress,
    IN     DWORD               dwAddressLength,
    IN     LPWSAPROTOCOL_INFOA lpProtocolInfo,
    IN OUT LPSTR             lpszAddressString,
    IN OUT LPDWORD             lpdwAddressStringLength
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAAddressToStringW(
    IN     LPSOCKADDR          lpsaAddress,
    IN     DWORD               dwAddressLength,
    IN     LPWSAPROTOCOL_INFOW lpProtocolInfo,
    IN OUT LPWSTR             lpszAddressString,
    IN OUT LPDWORD             lpdwAddressStringLength
    );
#ifdef UNICODE
#define WSAAddressToString  WSAAddressToStringW
#else
#define WSAAddressToString  WSAAddressToStringA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAADDRESSTOSTRINGA)(
    IN     LPSOCKADDR          lpsaAddress,
    IN     DWORD               dwAddressLength,
    IN     LPWSAPROTOCOL_INFOA lpProtocolInfo,
    IN OUT LPSTR             lpszAddressString,
    IN OUT LPDWORD             lpdwAddressStringLength
    );
typedef
INT
(WSAAPI * LPFN_WSAADDRESSTOSTRINGW)(
    IN     LPSOCKADDR          lpsaAddress,
    IN     DWORD               dwAddressLength,
    IN     LPWSAPROTOCOL_INFOW lpProtocolInfo,
    IN OUT LPWSTR             lpszAddressString,
    IN OUT LPDWORD             lpdwAddressStringLength
    );
#ifdef UNICODE
#define LPFN_WSAADDRESSTOSTRING  LPFN_WSAADDRESSTOSTRINGW
#else
#define LPFN_WSAADDRESSTOSTRING  LPFN_WSAADDRESSTOSTRINGA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAStringToAddressA(
    IN     LPSTR               AddressString,
    IN     INT                 AddressFamily,
    IN     LPWSAPROTOCOL_INFOA lpProtocolInfo,
    OUT    LPSOCKADDR          lpAddress,
    IN OUT LPINT               lpAddressLength
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAStringToAddressW(
    IN     LPWSTR              AddressString,
    IN     INT                 AddressFamily,
    IN     LPWSAPROTOCOL_INFOW lpProtocolInfo,
    OUT    LPSOCKADDR          lpAddress,
    IN OUT LPINT               lpAddressLength
    );
#ifdef UNICODE
#define WSAStringToAddress  WSAStringToAddressW
#else
#define WSAStringToAddress  WSAStringToAddressA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSASTRINGTOADDRESSA)(
    IN     LPSTR               AddressString,
    IN     INT                 AddressFamily,
    IN     LPWSAPROTOCOL_INFOA lpProtocolInfo,
    OUT    LPSOCKADDR          lpAddress,
    IN OUT LPINT               lpAddressLength
    );
typedef
INT
(WSAAPI * LPFN_WSASTRINGTOADDRESSW)(
    IN     LPWSTR              AddressString,
    IN     INT                 AddressFamily,
    IN     LPWSAPROTOCOL_INFOW lpProtocolInfo,
    OUT    LPSOCKADDR          lpAddress,
    IN OUT LPINT               lpAddressLength
    );
#ifdef UNICODE
#define LPFN_WSASTRINGTOADDRESS  LPFN_WSASTRINGTOADDRESSW
#else
#define LPFN_WSASTRINGTOADDRESS  LPFN_WSASTRINGTOADDRESSA
#endif
#endif

/*-----------------------------------------------------------------------------
** Registration and Name Resolution API functions
**-----------------------------------------------------------------------------
*/
#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSALookupServiceBeginA(
    IN  LPWSAQUERYSETA lpqsRestrictions,
    IN  DWORD          dwControlFlags,
    OUT LPHANDLE       lphLookup
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSALookupServiceBeginW(
    IN  LPWSAQUERYSETW lpqsRestrictions,
    IN  DWORD          dwControlFlags,
    OUT LPHANDLE       lphLookup
    );
#ifdef UNICODE
#define WSALookupServiceBegin  WSALookupServiceBeginW
#else
#define WSALookupServiceBegin  WSALookupServiceBeginA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSALOOKUPSERVICEBEGINA)(
    IN  LPWSAQUERYSETA lpqsRestrictions,
    IN  DWORD          dwControlFlags,
    OUT LPHANDLE       lphLookup
    );
typedef
INT
(WSAAPI * LPFN_WSALOOKUPSERVICEBEGINW)(
    IN  LPWSAQUERYSETW lpqsRestrictions,
    IN  DWORD          dwControlFlags,
    OUT LPHANDLE       lphLookup
    );
#ifdef UNICODE
#define LPFN_WSALOOKUPSERVICEBEGIN  LPFN_WSALOOKUPSERVICEBEGINW
#else
#define LPFN_WSALOOKUPSERVICEBEGIN  LPFN_WSALOOKUPSERVICEBEGINA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSALookupServiceNextA(
    IN     HANDLE           hLookup,
    IN     DWORD            dwControlFlags,
    IN OUT LPDWORD          lpdwBufferLength,
    OUT    LPWSAQUERYSETA   lpqsResults
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSALookupServiceNextW(
    IN     HANDLE           hLookup,
    IN     DWORD            dwControlFlags,
    IN OUT LPDWORD          lpdwBufferLength,
    OUT    LPWSAQUERYSETW   lpqsResults
    );
#ifdef UNICODE
#define WSALookupServiceNext  WSALookupServiceNextW
#else
#define WSALookupServiceNext  WSALookupServiceNextA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSALOOKUPSERVICENEXTA)(
    IN     HANDLE           hLookup,
    IN     DWORD            dwControlFlags,
    IN OUT LPDWORD          lpdwBufferLength,
    OUT    LPWSAQUERYSETA   lpqsResults
    );
typedef
INT
(WSAAPI * LPFN_WSALOOKUPSERVICENEXTW)(
    IN     HANDLE           hLookup,
    IN     DWORD            dwControlFlags,
    IN OUT LPDWORD          lpdwBufferLength,
    OUT    LPWSAQUERYSETW   lpqsResults
    );
#ifdef UNICODE
#define LPFN_WSALOOKUPSERVICENEXT  LPFN_WSALOOKUPSERVICENEXTW
#else
#define LPFN_WSALOOKUPSERVICENEXT  LPFN_WSALOOKUPSERVICENEXTA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSALookupServiceEnd(
    IN HANDLE  hLookup
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSALOOKUPSERVICEEND)(
    IN HANDLE  hLookup
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAInstallServiceClassA(
    IN  LPWSASERVICECLASSINFOA   lpServiceClassInfo
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAInstallServiceClassW(
    IN  LPWSASERVICECLASSINFOW   lpServiceClassInfo
    );
#ifdef UNICODE
#define WSAInstallServiceClass  WSAInstallServiceClassW
#else
#define WSAInstallServiceClass  WSAInstallServiceClassA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAINSTALLSERVICECLASSA)(
    IN  LPWSASERVICECLASSINFOA   lpServiceClassInfo
    );
typedef
INT
(WSAAPI * LPFN_WSAINSTALLSERVICECLASSW)(
    IN  LPWSASERVICECLASSINFOW   lpServiceClassInfo
    );
#ifdef UNICODE
#define LPFN_WSAINSTALLSERVICECLASS  LPFN_WSAINSTALLSERVICECLASSW
#else
#define LPFN_WSAINSTALLSERVICECLASS  LPFN_WSAINSTALLSERVICECLASSA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSARemoveServiceClass(
    IN  LPGUID  lpServiceClassId
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAREMOVESERVICECLASS)(
    IN  LPGUID  lpServiceClassId
    );
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAGetServiceClassInfoA(
    IN  LPGUID  lpProviderId,
    IN  LPGUID  lpServiceClassId,
    IN OUT LPDWORD  lpdwBufSize,
    OUT LPWSASERVICECLASSINFOA lpServiceClassInfo
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAGetServiceClassInfoW(
    IN  LPGUID  lpProviderId,
    IN  LPGUID  lpServiceClassId,
    IN OUT LPDWORD  lpdwBufSize,
    OUT LPWSASERVICECLASSINFOW lpServiceClassInfo
    );
#ifdef UNICODE
#define WSAGetServiceClassInfo  WSAGetServiceClassInfoW
#else
#define WSAGetServiceClassInfo  WSAGetServiceClassInfoA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAGETSERVICECLASSINFOA)(
    IN  LPGUID  lpProviderId,
    IN  LPGUID  lpServiceClassId,
    IN OUT LPDWORD  lpdwBufSize,
    OUT LPWSASERVICECLASSINFOA lpServiceClassInfo
    );
typedef
INT
(WSAAPI * LPFN_WSAGETSERVICECLASSINFOW)(
    IN  LPGUID  lpProviderId,
    IN  LPGUID  lpServiceClassId,
    IN OUT LPDWORD  lpdwBufSize,
    OUT LPWSASERVICECLASSINFOW lpServiceClassInfo
    );
#ifdef UNICODE
#define LPFN_WSAGETSERVICECLASSINFO  LPFN_WSAGETSERVICECLASSINFOW
#else
#define LPFN_WSAGETSERVICECLASSINFO  LPFN_WSAGETSERVICECLASSINFOA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAEnumNameSpaceProvidersA(
    IN OUT LPDWORD              lpdwBufferLength,
    OUT    LPWSANAMESPACE_INFOA lpnspBuffer
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAEnumNameSpaceProvidersW(
    IN OUT LPDWORD              lpdwBufferLength,
    OUT    LPWSANAMESPACE_INFOW lpnspBuffer
    );
#ifdef UNICODE
#define WSAEnumNameSpaceProviders  WSAEnumNameSpaceProvidersW
#else
#define WSAEnumNameSpaceProviders  WSAEnumNameSpaceProvidersA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAENUMNAMESPACEPROVIDERSA)(
    IN OUT LPDWORD              lpdwBufferLength,
    OUT    LPWSANAMESPACE_INFOA lpnspBuffer
    );
typedef
INT
(WSAAPI * LPFN_WSAENUMNAMESPACEPROVIDERSW)(
    IN OUT LPDWORD              lpdwBufferLength,
    OUT    LPWSANAMESPACE_INFOW lpnspBuffer
    );
#ifdef UNICODE
#define LPFN_WSAENUMNAMESPACEPROVIDERS  LPFN_WSAENUMNAMESPACEPROVIDERSW
#else
#define LPFN_WSAENUMNAMESPACEPROVIDERS  LPFN_WSAENUMNAMESPACEPROVIDERSA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAGetServiceClassNameByClassIdA(
    IN      LPGUID  lpServiceClassId,
    OUT     LPSTR lpszServiceClassName,
    IN OUT  LPDWORD lpdwBufferLength
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAGetServiceClassNameByClassIdW(
    IN      LPGUID  lpServiceClassId,
    OUT     LPWSTR lpszServiceClassName,
    IN OUT  LPDWORD lpdwBufferLength
    );
#ifdef UNICODE
#define WSAGetServiceClassNameByClassId  WSAGetServiceClassNameByClassIdW
#else
#define WSAGetServiceClassNameByClassId  WSAGetServiceClassNameByClassIdA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAGETSERVICECLASSNAMEBYCLASSIDA)(
    IN      LPGUID  lpServiceClassId,
    OUT     LPSTR lpszServiceClassName,
    IN OUT  LPDWORD lpdwBufferLength
    );
typedef
INT
(WSAAPI * LPFN_WSAGETSERVICECLASSNAMEBYCLASSIDW)(
    IN      LPGUID  lpServiceClassId,
    OUT     LPWSTR lpszServiceClassName,
    IN OUT  LPDWORD lpdwBufferLength
    );
#ifdef UNICODE
#define LPFN_WSAGETSERVICECLASSNAMEBYCLASSID  LPFN_WSAGETSERVICECLASSNAMEBYCLASSIDW
#else
#define LPFN_WSAGETSERVICECLASSNAMEBYCLASSID  LPFN_WSAGETSERVICECLASSNAMEBYCLASSIDA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSASetServiceA(
    IN LPWSAQUERYSETA lpqsRegInfo,
    IN WSAESETSERVICEOP essoperation,
    IN DWORD dwControlFlags
    );
WINSOCK_API_LINKAGE
INT
WSAAPI
WSASetServiceW(
    IN LPWSAQUERYSETW lpqsRegInfo,
    IN WSAESETSERVICEOP essoperation,
    IN DWORD dwControlFlags
    );
#ifdef UNICODE
#define WSASetService  WSASetServiceW
#else
#define WSASetService  WSASetServiceA
#endif
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSASETSERVICEA)(
    IN LPWSAQUERYSETA lpqsRegInfo,
    IN WSAESETSERVICEOP essoperation,
    IN DWORD dwControlFlags
    );
typedef
INT
(WSAAPI * LPFN_WSASETSERVICEW)(
    IN LPWSAQUERYSETW lpqsRegInfo,
    IN WSAESETSERVICEOP essoperation,
    IN DWORD dwControlFlags
    );
#ifdef UNICODE
#define LPFN_WSASETSERVICE  LPFN_WSASETSERVICEW
#else
#define LPFN_WSASETSERVICE  LPFN_WSASETSERVICEA
#endif
#endif

#if INCL_WINSOCK_API_PROTOTYPES
WINSOCK_API_LINKAGE
INT
WSAAPI
WSAProviderConfigChange(
    IN OUT LPHANDLE lpNotificationHandle,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

#if INCL_WINSOCK_API_TYPEDEFS
typedef
INT
(WSAAPI * LPFN_WSAPROVIDERCONFIGCHANGE)(
    IN OUT LPHANDLE lpNotificationHandle,
    IN LPWSAOVERLAPPED lpOverlapped,
    IN LPWSAOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
    );
#endif

/*-----------------------------------------------------------------------------
** Microsoft Windows Extended data types
**-----------------------------------------------------------------------------
*/
typedef struct sockaddr_in SOCKADDR_IN;
typedef struct sockaddr_in *PSOCKADDR_IN;
typedef struct sockaddr_in *LPSOCKADDR_IN;

typedef struct linger LINGER;
typedef struct linger *PLINGER;
typedef struct linger *LPLINGER;

typedef struct in_addr IN_ADDR;
typedef struct in_addr *PIN_ADDR;
typedef struct in_addr *LPIN_ADDR;

typedef struct fd_set FD_SET;
typedef struct fd_set *PFD_SET;
typedef struct fd_set *LPFD_SET;

typedef struct hostent HOSTENT;
typedef struct hostent *PHOSTENT;
typedef struct hostent *LPHOSTENT;

typedef struct servent SERVENT;
typedef struct servent *PSERVENT;
typedef struct servent *LPSERVENT;

typedef struct protoent PROTOENT;
typedef struct protoent *PPROTOENT;
typedef struct protoent *LPPROTOENT;

typedef struct timeval TIMEVAL;
typedef struct timeval *PTIMEVAL;
typedef struct timeval *LPTIMEVAL;

/*
** Windows message parameter composition and decomposition
** macros.
**
** WSAMAKEASYNCREPLY is intended for use by the Windows Sockets implementation
** when constructing the response to a WSAAsyncGetXByY() routine.
*/
#define WSAMAKEASYNCREPLY(buflen,error)     MAKELONG(buflen,error)
/*
** WSAMAKESELECTREPLY is intended for use by the Windows Sockets implementation
** when constructing the response to WSAAsyncSelect().
*/
#define WSAMAKESELECTREPLY(event,error)     MAKELONG(event,error)
/*
** WSAGETASYNCBUFLEN is intended for use by the Windows Sockets application
** to extract the buffer length from the lParam in the response
** to a WSAAsyncGetXByY().
*/
#define WSAGETASYNCBUFLEN(lParam)           LOWORD(lParam)
/*
** WSAGETASYNCERROR is intended for use by the Windows Sockets application
** to extract the error code from the lParam in the response
** to a WSAGetXByY().
*/
#define WSAGETASYNCERROR(lParam)            HIWORD(lParam)
/*
** WSAGETSELECTEVENT is intended for use by the Windows Sockets application
** to extract the event code from the lParam in the response
** to a WSAAsyncSelect().
*/
#define WSAGETSELECTEVENT(lParam)           LOWORD(lParam)
/*
** WSAGETSELECTERROR is intended for use by the Windows Sockets application
** to extract the error code from the lParam in the response
** to a WSAAsyncSelect().
*/
#define WSAGETSELECTERROR(lParam)           HIWORD(lParam)

/* BSD sockets clashes that can be maped directly to WSA calls */
#define connect(s,name,namelen) WSAConnect(s,name,namelen, 0,0,0,0)
#define accept(s,addr,addrlen)  WSAAccept(s,addr,addrlen,0,0)

/*
** NetWare Fast Accept and Recv option structures. Fast Recv also has a
** cleanup routine returned.
*/
typedef
int (CALLBACK *LPFASTACCEPT_COMPLETION_ROUTINE)
(
    SOCKET      acceptSkt, 
    LPSOCKADDR  peerAddr, 
    int         peerAddrLen,
    void        *arg
);

typedef
int (CALLBACK *LPFASTRECV_COMPLETION_ROUTINE)
(
    SOCKET      s, 
    void        *recvBuf,
    LPWSABUF    wsBuf,
    DWORD       wsBufCnt,
    DWORD       recvLen,
    void        *arg
);
 
typedef struct FASTACCEPT_OP
{
    LPFASTACCEPT_COMPLETION_ROUTINE acceptHandler;
    void        *arg;
} *LPFAST_ACCEPT_OPT, FAST_ACCEPT_OPT;

typedef struct FASTRECV_OP
{
    LPFASTRECV_COMPLETION_ROUTINE   recvHandler;
    void        *arg;
} *LPFAST_RECV_OPT, FAST_RECV_OPT;


/* new function prototypes */
int WSAOpenHosts(void);
int WSAOpenProtocols(void);
int WSAOpenServices(void);
int WSAOpenResolveCfg(void);


/*
** Secure Sockets Layer: Needed until WinSock SDK supplies SSL header, taken
** from Winsock 2 Protocol Annex for SSL Security Protocol; unsupported options
** are labeled 'not supported.'
*/
#include <time.h>

/*
** These values are used to form the WSAIoctl 'dwIoControlCode' 'Code' value.
*/
#define _SO_SSL                  ((2L << 27) | (0x73L << 16))

/*
** This is the SSL protocol tag and ioctl 'dwIoControlCode' 'T' value.
*/
#define _SO_SSL_FLAGS            0x01
#define _SO_SSL_CIPHERS          0x02
#define _SO_SSL_SERVER           0x04
#define _SO_SSL_AUTH_CERT_HOOK   0x08        /* not supported */
#define _SO_SSL_RSA_ENCRYPT_HOOK 0x10        /* not supported */
#define _SO_SSL_RSA_DECRYPT_HOOK 0x20        /* not supported */

/*
** _SO_SSL_CLIENT has been changed from 0x03 to 0x80 to avoid bitwise 
** conflicts with _SO_SSL_CIPHERS _SO_SSL_FLAGS. 
*/
#define _SO_SSL_CLIENT     0x80  

/* ioctl() 'cmd' argument values... */
#define SO_SSL_GET_FLAGS   (IOC_IN |_SO_SSL|_SO_SSL_FLAGS)
#define SO_SSL_SET_FLAGS   (IOC_OUT|_SO_SSL|_SO_SSL_FLAGS)
#define SO_SSL_GET_CIPHERS (IOC_IN |_SO_SSL|_SO_SSL_CIPHERS)/* not supported */
#define SO_SSL_SET_CIPHERS (IOC_OUT|_SO_SSL|_SO_SSL_CIPHERS)/* not supported */
#define SO_SSL_GET_CLIENT  (IOC_IN |_SO_SSL|_SO_SSL_CLIENT)
#define SO_SSL_SET_CLIENT  (IOC_OUT|_SO_SSL|_SO_SSL_CLIENT)
#define SO_SSL_GET_SERVER  (IOC_IN |_SO_SSL|_SO_SSL_SERVER)
#define SO_SSL_SET_SERVER  (IOC_OUT|_SO_SSL|_SO_SSL_SERVER)

#define SO_SSL_ENABLE      0x001
#define SO_SSL_SERVER      0x002
#define SO_SSL_AUTH_CLIENT 0x004
#define SO_SSL_ACCEPT_WEAK 0x008       /* not supported */

/* the following are all unsupported... */
#define SO_SSL_GET_AUTH_CERT_HOOK   (IOC_IN |_SO_SSL|_SO_SSL_AUTH_CERT_HOOK)
#define SO_SSL_SET_AUTH_CERT_HOOK   (IOC_OUT|_SO_SSL|_SO_SSL_AUTH_CERT_HOOK)
#define SO_SSL_GET_RSA_ENCRYPT_HOOK (IOC_IN |_SO_SSL|_SO_SSL_RSA_ENCRYPT_HOOK)
#define SO_SSL_SET_RSA_ENCRYPT_HOOK (IOC_OUT|_SO_SSL|_SO_SSL_RSA_ENCRYPT_HOOK)
#define SO_SSL_GET_RSA_DECRYPT_HOOK (IOC_IN |_SO_SSL|_SO_SSL_RSA_DECRYPT_HOOK)
#define SO_SSL_SET_RSA_DECRYPT_HOOK (IOC_OUT|_SO_SSL|_SO_SSL_RSA_DECRYPT_HOOK)

#ifndef int32
# define int32      int
#endif

/* these are packed on 1 byte */
#ifndef _WIN64
# include <pshpack1.h>
#endif

struct sslcipheropts /* not supported */
{
    int     n;
    char    specs[3];
};

struct sslclientopts
{
    char        *cert;
    int         certlen;
    time_t      sidtimeout;
    int32       sidentries;
    char        *siddir;
};

struct sslserveropts
{
    char    *cert;
    int     certlen;
    time_t  sidtimeout;
    int32   sidentries;
    char    *siddir;
};

/* ---- the following types and implied definitions are all unsupported! ---- */
struct sslauthhook
{
    BYTE            *certificateChain;
    char            *subjectDN;
    unsigned char   *cipher;
    unsigned char   *sessionID;
    unsigned int    sessionIDLen;
};

struct sslauthcertopts  /* not supported */
{
    int     type;
    int     (*func)( void *arg, char *cert, int len );
    void    *arg;
};

#define SSL_ACK_OK              1   /* not supported */
#define SSL_ACH_WEAK_OK         2   /* not supported */
#define SSL_ACH_LONG_DATA       3   /* not supported */
#define SSL_ACH_BAD_DATA        4   /* not supported */
#define SSL_ACH_BAD_SIG         5   /* not supported */
#define SSL_ACH_CERT_EXPIRED    6   /* not supported */


struct sslrsaencrypthook    /* not supported */
{
    int     (*func)( void *arg, int blockType, char *dest, 
                        int *destlen, char *src, int srclen );
    void    *arg;
};

#define SSL_REH_OK              0   /* not supported */
#define SSL_REH_BAD_TYPE        1   /* not supported */
#define SSL_REH_BAD_LEN         2   /* not supported */


struct sslrsadecrypthook    /* not supported */
{
    int     (*func)( void *arg, int blockType, char *dest, 
                        int *destlen, char *src, int srclen );
    void    *arg;
};

#define SSL_RDH_OK              0   /* not supported */
#define SSL_RDH_BAD_TYPE        1   /* not supported */
#define SSL_RDH_BAD_LEN         2   /* not supported */

#include <poppack.h>

/* wallet predefined provider names, maximum length 63 Unicode characters... */
#define WAL_MAX_PROVIDER_NAME_BYTES     128
#define WAL_MAX_PROVIDER_NAME_CHARS     (WAL_MAX_PROVIDER_NAME_BYTES/2)

#define WAL_PROV_PFX                    L"pfx"
/*
** In this case, the name specifies either a file, or an NDS tree/object which
** has an attribute of type OctetString. In either case, the data format is
** PFX.
**
** Files are specified like this:
**    file:///C:/directory/mywallet.wal
**
** NDS objects holding wallet attributes are specified like this:
**       nds://[tree name]/[fully distinguished name of object with the wallet
**                                              attribute]
**       nds://NOVELL_INC/.username.novell/wallet
**
** If [tree name] is not specified, the default tree is used, ex.:
**       nds:///.object_with_wallet_attribute.username.novell.
*/

#define WAL_PROV_JKS                    L"jks"
/* in this case, name specifies a Java keystore file... */

#define WAL_PROV_KMO                    L"kmo"
/*
** Naming convention not yet determined. Here are some possibilities:
**
** Option 1: Name could be unspecified (null), and then the KMO names would be
** specified as the alias in GetPrivKey().
**
** Option 2: Name could be the name of the KMO, and then the alias in
** GetPrivKey() would be ignored.
*/

#define WAL_PROV_DER                    L"der"
/*
** DER files are always read from file system. If roots are in NDS, then they
** are saved as TrustedRoot KMOs and we use the WAL_PROV_KMO for them, e.g.:
**       file:///C:/directory/root.der
*/


/* wallet access types... */
#define WAL_A_READ       1   /* shared read */
#define WAL_A_READ_WRITE 2   /* read-write */
#define WAL_A_NEW        4   /* create new wallet of the given name and type */
                             /* if other wallet of that name, overwrite */

/* wallet name maximum length of 63 unicode characters plus NULL... */
#define WAL_MAX_KEY_TYPE_BYTES 128
#define WAL_MAX_KEY_TYPE_CHARS (WAL_MAX_KEY_TYPE_BYTES/2)

/* predefined key types... */
#define WAL_KT_NICI_WRAPPED    L"nici wrapped"
#define WAL_KT_PKCS8           L"pkcs8"
#define WAL_KT_BSAFE1          L"bsafe1"

/* wallet handle type... */
#define WAL_HANDLE             nptr
#define WAL_ENUM_HANDLE        nptr

/* wallet property flags returned from WAL_Open()... */
#define WAL_WP_IS_INTEGRITY_PROTECTED   1

/* provider property flags returned in WAL_ProviderInfo structure from WAL_GetProvider()... */
#define WAL_PP_SUPPORTS_INTEGRITY_PROTECTION    1
#define WAL_PP_REQUIRES_INTEGRITY_PROTECTION    \
                            (WAL_PP_SUPPORTS_INTEGRITY_PROTECTION|2)

/*
** Secure Sockets Layer--needed until Winsock SDK supplies ssl header file.
** Taken from Winsock 2 protocol Annex for SSL Security Protocol. Unsupported
** options are labeled "not supported".
**
** This value is the SSL protocol tag and WSAIoctl dwIoControlCode
** "T" value. This value is unique to distinguish a TLS Ioctl from an SSL
** Ioctl due to different structure definitions.
*/
#define _SO_TLS     ((2L << 27) | (0x74L << 16))

/*
** These values are used to form the WSAIoctl dwIoControlCode
** "Code" value.
*/
#define _SO_TLS_FLAGS               0x01
#define _SO_TLS_CIPHERS             0x02
#define _SO_TLS_SERVER              0x04
#define _SO_TLS_AUTH_CERT_HOOK      0x08  /* not supported */
#define _SO_TLS_RSA_ENCRYPT_HOOK    0x10  /* not supported */
#define _SO_TLS_RSA_DECRYPT_HOOK    0x20  /* not supported */
#define _SO_TLS_CERT                0x40

/*
** _SO_TLS_CLIENT has been changed from 0x03 to 0x80 to avoid bitwise 
** conflicts with _SO_TLS_CIPHERS _SO_TLS_FLAGS. 
*/
#define _SO_TLS_CLIENT              0x80  

/*
** Actual TLS Ioctl commands
*/
#define SO_TLS_GET_FLAGS   (IOC_IN |_SO_TLS|_SO_TLS_FLAGS)
#define SO_TLS_SET_FLAGS   (IOC_OUT|_SO_TLS|_SO_TLS_FLAGS)
#define SO_TLS_GET_CIPHERS (IOC_IN |_SO_TLS|_SO_TLS_CIPHERS) /* not supported */
#define SO_TLS_SET_CIPHERS (IOC_OUT|_SO_TLS|_SO_TLS_CIPHERS) /* not supported */
#define SO_TLS_GET_CLIENT  (IOC_IN |_SO_TLS|_SO_TLS_CLIENT)
#define SO_TLS_SET_CLIENT  (IOC_OUT|_SO_TLS|_SO_TLS_CLIENT)
#define SO_TLS_GET_SERVER  (IOC_IN |_SO_TLS|_SO_TLS_SERVER)
#define SO_TLS_SET_SERVER  (IOC_OUT|_SO_TLS|_SO_TLS_SERVER)
#define SO_TLS_GET_CERT    (IOC_IN |_SO_TLS|_SO_TLS_CERT)    /* not supported */

/* the following are all unsupported... */
#define SO_TLS_GET_AUTH_CERT_HOOK   (IOC_IN |_SO_TLS|_SO_TLS_AUTH_CERT_HOOK)
#define SO_TLS_SET_AUTH_CERT_HOOK   (IOC_OUT|_SO_TLS|_SO_TLS_AUTH_CERT_HOOK)
#define SO_TLS_GET_RSA_ENCRYPT_HOOK (IOC_IN |_SO_TLS|_SO_TLS_RSA_ENCRYPT_HOOK)
#define SO_TLS_SET_RSA_ENCRYPT_HOOK (IOC_OUT|_SO_TLS|_SO_TLS_RSA_ENCRYPT_HOOK)
#define SO_TLS_GET_RSA_DECRYPT_HOOK (IOC_IN |_SO_TLS|_SO_TLS_RSA_DECRYPT_HOOK)
#define SO_TLS_SET_RSA_DECRYPT_HOOK (IOC_OUT|_SO_TLS|_SO_TLS_RSA_DECRYPT_HOOK)

#define SO_TLS_ENABLE               0x0001
#define SO_TLS_SERVER               0x0002
#define SO_TLS_AUTH_CLIENT          0x0004
#define SO_TLS_ACCEPT_WEAK          0x0008 /* not supported */
#define SO_TLS_MAP_DISABLE          0x0010
#define SO_TLS_MAP_IDENTITY         0x0020
#define SO_TLS_BLIND_ACCEPT         0x0040
#define SO_TLS_INTERACTIVE_ACCEPT   0x0080

#ifndef int32
#define int32   int
#endif

struct tlscipheropts   /* not supported */
{
   int     n;
   char    specs[3];
};

struct tlsclientopts
{
   unicode_t   *wallet;
   int         walletlen;
   time_t      sidtimeout;
   int32       sidentries;
   char        *siddir;
   void        *options;
};

struct tlsserveropts
{
   unicode_t   *wallet;
   int         walletlen;
   time_t      sidtimeout;
   int32       sidentries;
   char        *siddir;
   void        *options;
};

struct nwtlsopts
{
   unicode_t *walletProvider;        /* wallet content provider e.g. PFX, KMO, DER */
   unicode_t **keysList;             /* alias for private key in wallet to be used */
                                       /* not used for anything but pfx wallet provider */
   int     numElementsInKeyList;   /* number of elements in the array */
   unicode_t **TrustedRootList;      /* array of trusted root names */
   int     numElementsInTRList;    /* number of elements in the array */
   void    *reservedforfutureuse;  /* reserved to set ciphers */
   void    *reservedforfutureCRL;  /* reserved for CRL */
   int     reservedforfutureCRLLen;/* reserved for CRL len */
   void    *reserved1;             /* reserved */
   void    *reserved2;             /* reserved */
   void    *reserved3;             /* reserved */
};

struct tlsauthhook
{
   BYTE            *certificateChain;
   char            *subjectDN;
   unsigned char   *cipher;
   unsigned char   *sessionID;
   unsigned int    sessionIDLen;
};


struct tlsauthcertopts  /* not supported */
{
   int     type;
   int     (*func)(void *arg, char *cert, int len);
   void    *arg;
};

#define TLS_ACK_OK              1   /* not supported */ 
#define TLS_ACH_WEAK_OK         2   /* not supported */ 
#define TLS_ACH_LONG_DATA       3   /* not supported */ 
#define TLS_ACH_BAD_DATA        4   /* not supported */ 
#define TLS_ACH_BAD_SIG         5   /* not supported */ 
#define TLS_ACH_CERT_EXPIRED    6   /* not supported */ 

struct tlsrsaencrypthook   /* not supported */
{
   int     (*func)(void *arg, int blockType, char *dest, 
                        int *destlen, char *src, int srclen);
   void    *arg;
};

#define TLS_REH_OK          0   /* not supported */ 
#define TLS_REH_BAD_TYPE    1   /* not supported */ 
#define TLS_REH_BAD_LEN     2   /* not supported */ 

struct tlsrsadecrypthook   /* not supported */
{
   int     (*func)(void *arg, int blockType, char *dest, 
                        int *destlen, char *src, int srclen);
   void    *arg;
};

#define TLS_RDH_OK          0   /* not supported */ 
#define TLS_RDH_BAD_TYPE    1   /* not supported */ 
#define TLS_RDH_BAD_LEN     2   /* not supported */ 

struct tlscert     /* not supported */
{
   char    *cert;
   int     certlen;
};


#ifndef _WIN64
# include <poppack.h>
#endif

#ifdef __cplusplus
}
#endif

#endif
