#ifndef _WS2EXT_H
#define _WS2EXT_H
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2001 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  ws2ext.h
==============================================================================


** This file contains proposed extensions to the Winsock 2 specification to
** support Novell's implementation of namespace providers.


======[ Manifest constants ]==================================================

**
** Proposed output flag for deregistered services
*/
#ifndef RESULT_IS_DEREGISTERED
#define RESULT_IS_DEREGISTERED 0x0002
#endif

/* 
** Proposed output flag for containers  
*/
#ifndef RESULT_IS_CONTAINER
#define RESULT_IS_CONTAINER 0x0004
#endif

/* 
** Values used to indicate an attribute list in the blob    
*/
#define WS_ATTRLIST_ASCII    0xb10bea1a     /* blob contains ASCII strings  */
#define WS_ATTRLIST_UNICODE  0xb10bea10     /* blob contains UNICODE strings*/

/*
** Name Spaces
** Extends definitions in WINSOCK2.H
*/
#define NS_BINDERY                  (4)

/*
** Predefined BLOB Value Types
** Extends Predefined Value Types in winnt.h
*/

#define REG_BOOL                    (11)    /* Boolian value; TRUE or FALSE */
#define REG_KEYWORD                 (12)    /* Keyword with no value        */

/*====[ Macros ]============================================================*/

#define IS_ASCII_BLOBATTRLIST(p) (WS_ATTRLIST_ASCII == (p)->dwSignature)
#define IS_UNICODE_BLOBATTRLIST(p) (WS_ATTRLIST_UNICODE == (p)->dwSignature)
#define IS_BLOBATTRLIST(p) (IS_ASCII_BLOBATTRLIST(p)                         \
                            || IS_UNICODE_BLOBATTRLIST(p))

/*
** After a successful return from WSALookupServiceNext, 
** use the following macro to convert the
** offsets in the WSABLOBATTRLIST to pointers:
**
**    ADJUST_BLOB_POINTERS(resultSet->lpBlob);
** 
** If there is no blob, or it is not a WSABLOBATTRLIST, 
** the macro will do nothing.
*/
#define ADJUST_BLOB_POINTERS(p) {                                            \
   LPWSABLOBATTRLIST pBase;                                                  \
   if ((p) && (pBase = (LPWSABLOBATTRLIST)(p)->pBlobData)                    \
           && IS_BLOBATTRLIST(pBase)) {                                      \
      DWORD i;                                                               \
      ADJUST_BLOB_PTR(pBase->lpAttributes, LPWSAATTRINFO);                   \
      for (i = 0; i < pBase->dwAttrCount; i++)                               \
         ADJUST_BLOB_PTR(pBase->lpAttributes[i].lpszName, unicode_t),           \
         ADJUST_BLOB_PTR(pBase->lpAttributes[i].lpValue, LPBYTE);            \
   }                                                                         \
}
#define ADJUST_BLOB_PTR(p,type)                                              \
            (p ? p = (type)(((LPBYTE)pBase) + (DWORD)(p)):0)

/*====[ Type definitions ]==================================================*/

typedef WSANSCLASSINFO WSAATTRINFO, *LPWSAATTRINFO;

#include <pshpack1.h>

/* 
** Structure of a blob containing an attribute list
*/
typedef struct _WSABlobAttrList {
   DWORD           dwSignature;     /* Identifies the blob as an attribute list */
   DWORD           dwAttrCount;     /* Number of attributes present         */
   LPWSAATTRINFO   lpAttributes;    /* Pointer to attribute array           */
} WSABLOBATTRLIST, *LPWSABLOBATTRLIST;

#include <poppack.h>

#endif /* _NWWS2EXT_H */

