#ifndef __ws2guid_h__
#define __ws2guid_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2001 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Novell Header
=
=  ws2guid.h
==============================================================================
*/


#define guidCmp(dst,src)   (*(p32(dst)) == *(p32(src)) &&		\
                            *(p32(dst)+1) == *(p32(src)+1) &&	\
                            *(p32(dst)+2) == *(p32(src)+2) &&	\
                            *(p32(dst)+3) == *(p32(src)+3))

#define guidCmpZero(guid)  (*(p32(guid))   == 0 &&              \
                            *(p32(guid)+1) == 0 &&              \
                            *(p32(guid)+2) == 0 &&              \
                            *(p32(guid)+3) == 0)


#define guidZero(guid)      *(p32(guid))   =                    \
                            *(p32(guid)+1) =                    \
                            *(p32(guid)+2) =                    \
                            *(p32(guid)+3) = 0


#define INW_WSP_SSL_GUID  { /* {BE2753A0-EC6F-11D0-8B85-00C04FD73763} */ \
	0xBE2753A0,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_WSP_IP_GUID   { /* {B62753A0-EC6F-11D0-8B85-00C04FD73763} */ \
	0xB62753A0,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_WSP_IPX_GUID  { /* {7C689CA0-EC6F-11D0-8B85-00C04FD73763} */\
	0x7C689CA0,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_WSP_ATM_GUID  { /* {AEB88E40-EC6F-11D0-8B85-00C04FD73763} */\
	0xAEB88E40,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_WSP_ACP_GUID  { /* {BE4D3400-EC6F-11D0-8B85-00C04FD73763} */\
	0xBE4D3400,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_NSP_NDS_GUID  { /* {C4292460-EC6F-11D0-8B85-00C04FD73763} */\
	0xC4292460,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_NSP_SAP_GUID  { /* {C9340920-EC6F-11D0-8B85-00C04FD73763} */\
	0xC9340920,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_NSP_DNS_GUID  { /* {D088DDE0-EC6F-11D0-8B85-00C04FD73763} */\
	0xD088DDE0,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_NSP_SLP_GUID  { /* {D7D61180-EC6F-11D0-8B85-00C04FD73763} */\
	0xD7D61180,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}

#define INW_NSP_DHCP_GUID {	/*  (93c66f00-e6ec-11d2-87e7-0008c729a767) */\
	0x93C66F00, 0xE6EC, 0x11D2, {0x87,0xe7,0x00,0x08,0xc7,0x29,0xa7,0x67}}

#define SVCID_DHCP_LOCAL_INFO {/* {4BA95732-8C98-11d3-883F-0008C729A767}*/\
	0x4ba95732, 0x8c98, 0x11d3, {0x88,0x3f,0x0,0x8,0xc7,0x29,0xa7,0x67}}

#define INW_WSP_DSI_GUID  { /* {BE4D3400-EC6F-11D0-8B85-00C04FD73763} */\
	0xAE7C3400,	0xEC6F,	0x11D0,	{0x8B,0x85,0x00,0xC0,0x4F,0xD7,0x37,0x63}}
    
#endif /* __ws2guid_h__ */

