#ifndef __ws2name_h__
#define __ws2name_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Microsoft-inspired Header
=
=  ws2name.h
==============================================================================
*/
#ifndef __novsock2_h__     /* if WinSock doesn't provide struct sockaddr... */
# include <sys/socket.h>   /* ...then the standard C library will do it */
#endif

#include <ws2defs.h>
#include <knwnguid.h>

#if !defined(N_PLAT_NLM)
#define N_PLAT_NLM
#endif

/*
** WinSock 2 extension--WSAPROTOCOL_INFO structure and associated
** manifest constants
*/
#ifndef GUID_DEFINED
# define GUID_DEFINED
typedef struct _GUID
{
   unsigned long  Data1;
   unsigned short Data2;
   unsigned short Data3;
   unsigned char  Data4[8];
} GUID;
#endif

#ifndef __LPGUID_DEFINED__
# define __LPGUID_DEFINED__
typedef GUID *LPGUID;
#endif

#define MAX_PROTOCOL_CHAIN 7

/* Ensure structures packed consistently */
#ifndef _WIN64
# include <pshpack4.h>
#endif

/*
** Microsoft Windows Extended data types required for the functions to
** convert back and forth between binary and string forms of addresses.
*/
typedef struct sockaddr SOCKADDR;
typedef struct sockaddr *PSOCKADDR;
typedef struct sockaddr *LPSOCKADDR;

/*
** Manifest constants and type definitions related to name resolution and
** registration (RNR) API
*/
#ifndef _tagBLOB_DEFINED
# define _tagBLOB_DEFINED
# define _BLOB_DEFINED
# define _LPBLOB_DEFINED
typedef struct _BLOB
{
   ULONG  cbSize;
# ifdef MIDL_PASS
          [size_is(cbSize)] BYTE *pBlobData;
# else
   BYTE   *pBlobData;
# endif
} BLOB, *LPBLOB;
#endif

/*
** Service Install Flags
*/
#define SERVICE_MULTIPLE       (0x00000001)

/*
** Name Spaces
*/
#define NS_ALL                      0

#define NS_SAP                      1
#define NS_NDS                      2
#define NS_PEER_BROWSE              3

#define NS_SLP						5
#define NS_DHCP						6

#define NS_TCPIP_LOCAL              10
#define NS_TCPIP_HOSTS              11
#define NS_DNS                      12
#define NS_NETBT                    13
#define NS_WINS                     14

#define NS_NBP                      20

#define NS_MS                       30
#define NS_STDA                     31
#define NS_NTDS                     32

#define NS_X500                     40
#define NS_NIS                      41
#define NS_NISPLUS                  42

#define NS_WRQ                      50

/*
** Resolution flags for WSAGetAddressByName(). Note these are also used by
** the 1.1 API GetAddressByName, so leave them around.
*/
#define RES_UNUSED_1                0x00000001
#define RES_FLUSH_CACHE             0x00000002
#ifndef RES_SERVICE
# define RES_SERVICE                0x00000004
#endif

/*
** Well known value names for Service Types
*/
#define SERVICE_TYPE_VALUE_IPXPORTA      "IpxSocket"
#define SERVICE_TYPE_VALUE_IPXPORTW     L"IpxSocket"
#define SERVICE_TYPE_VALUE_SAPIDA        "SapId"
#define SERVICE_TYPE_VALUE_SAPIDW       L"SapId"

#define SERVICE_TYPE_VALUE_TCPPORTA      "TcpPort"
#define SERVICE_TYPE_VALUE_TCPPORTW     L"TcpPort"

#define SERVICE_TYPE_VALUE_UDPPORTA      "UdpPort"
#define SERVICE_TYPE_VALUE_UDPPORTW     L"UdpPort"

#define SERVICE_TYPE_VALUE_OBJECTIDA     "ObjectId"
#define SERVICE_TYPE_VALUE_OBJECTIDW    L"ObjectId"

#ifdef UNICODE
# define SERVICE_TYPE_VALUE_SAPID       SERVICE_TYPE_VALUE_SAPIDW
# define SERVICE_TYPE_VALUE_TCPPORT     SERVICE_TYPE_VALUE_TCPPORTW
# define SERVICE_TYPE_VALUE_UDPPORT     SERVICE_TYPE_VALUE_UDPPORTW
# define SERVICE_TYPE_VALUE_OBJECTID    SERVICE_TYPE_VALUE_OBJECTIDW
#else /* not UNICODE */
# define SERVICE_TYPE_VALUE_SAPID       SERVICE_TYPE_VALUE_SAPIDA
# define SERVICE_TYPE_VALUE_TCPPORT     SERVICE_TYPE_VALUE_TCPPORTA
# define SERVICE_TYPE_VALUE_UDPPORT     SERVICE_TYPE_VALUE_UDPPORTA
# define SERVICE_TYPE_VALUE_OBJECTID    SERVICE_TYPE_VALUE_OBJECTIDA
#endif

#ifndef __CSADDR_DEFINED__
# define __CSADDR_DEFINED__

/*
** SockAddr Information
*/
typedef struct _SOCKET_ADDRESS
{
   LPSOCKADDR lpSockaddr;
   INT iSockaddrLength;
} SOCKET_ADDRESS, *PSOCKET_ADDRESS, *LPSOCKET_ADDRESS;

/*
** CSAddr Information
*/
typedef struct _CSADDR_INFO
{
   SOCKET_ADDRESS LocalAddr;
   SOCKET_ADDRESS RemoteAddr;
   INT iSocketType;
   INT iProtocol;
} CSADDR_INFO, *PCSADDR_INFO, *LPCSADDR_INFO;

#endif

/*
** Address list returned via SIO_ADDRESS_LIST_QUERY
*/
typedef struct _SOCKET_ADDRESS_LIST
{
   INT             iAddressCount;
   SOCKET_ADDRESS  Address[1];
} SOCKET_ADDRESS_LIST, *LPSOCKET_ADDRESS_LIST;

/*
**  Address Family/Protocol Tuples
*/
typedef struct _AFPROTOCOLS
{
   INT iAddressFamily;
   INT iProtocol;
} AFPROTOCOLS, *PAFPROTOCOLS, *LPAFPROTOCOLS;

/*
** Client Query API Typedefs
*/

/*
** The comparators
*/
typedef enum _WSAEcomparator
{
   COMP_EQUAL = 0,
   COMP_NOTLESS
} WSAECOMPARATOR, *PWSAECOMPARATOR, *LPWSAECOMPARATOR;

typedef struct _WSAVersion
{
   DWORD           dwVersion;
   WSAECOMPARATOR  ecHow;
} WSAVERSION, *PWSAVERSION, *LPWSAVERSION;

typedef struct _WSAQuerySetA
{
   DWORD           dwSize;
   LPSTR           lpszServiceInstanceName;
   LPGUID          lpServiceClassId;
   LPWSAVERSION    lpVersion;
   LPSTR           lpszComment;
   DWORD           dwNameSpace;
   LPGUID          lpNSProviderId;
   LPSTR           lpszContext;
   DWORD           dwNumberOfProtocols;
   LPAFPROTOCOLS   lpafpProtocols;
   LPSTR           lpszQueryString;
   DWORD           dwNumberOfCsAddrs;
   LPCSADDR_INFO   lpcsaBuffer;
   DWORD           dwOutputFlags;
   LPBLOB          lpBlob;
} WSAQUERYSETA, *PWSAQUERYSETA, *LPWSAQUERYSETA;

typedef struct _WSAQuerySetW
{
   DWORD           dwSize;
   LPWSTR          lpszServiceInstanceName;
   LPGUID          lpServiceClassId;
   LPWSAVERSION    lpVersion;
   LPWSTR          lpszComment;
   DWORD           dwNameSpace;
   LPGUID          lpNSProviderId;
   LPWSTR          lpszContext;
   DWORD           dwNumberOfProtocols;
   LPAFPROTOCOLS   lpafpProtocols;
   LPWSTR          lpszQueryString;
   DWORD           dwNumberOfCsAddrs;
   LPCSADDR_INFO   lpcsaBuffer;
   DWORD           dwOutputFlags;
   LPBLOB          lpBlob;
} WSAQUERYSETW, *PWSAQUERYSETW, *LPWSAQUERYSETW;

#ifdef UNICODE
typedef WSAQUERYSETW WSAQUERYSET;
typedef PWSAQUERYSETW PWSAQUERYSET;
typedef LPWSAQUERYSETW LPWSAQUERYSET;
#else
typedef WSAQUERYSETA WSAQUERYSET;
typedef PWSAQUERYSETA PWSAQUERYSET;
typedef LPWSAQUERYSETA LPWSAQUERYSET;
#endif

#define LUP_DEEP                0x0001
#define LUP_CONTAINERS          0x0002
#define LUP_NOCONTAINERS        0x0004
#define LUP_NEAREST             0x0008
#define LUP_RETURN_NAME         0x0010
#define LUP_RETURN_TYPE         0x0020
#define LUP_RETURN_VERSION      0x0040
#define LUP_RETURN_COMMENT      0x0080
#define LUP_RETURN_ADDR         0x0100
#define LUP_RETURN_BLOB         0x0200
#define LUP_RETURN_ALIASES      0x0400
#define LUP_RETURN_QUERY_STRING 0x0800
#define LUP_RETURN_ALL          0x0FF0
#define LUP_RES_SERVICE         0x8000

#define LUP_FLUSHCACHE       0x1000
#define LUP_FLUSHPREVIOUS    0x2000


/*
** Return flags
*/
#define RESULT_IS_ALIAS      0x0001

/*
** Service Address Registration and Deregistration Data Types.
*/
typedef enum _WSAESETSERVICEOP
{
   RNRSERVICE_REGISTER=0,
   RNRSERVICE_DEREGISTER,
   RNRSERVICE_DELETE
} WSAESETSERVICEOP, *PWSAESETSERVICEOP, *LPWSAESETSERVICEOP;

/*
** Service Installation/Removal Data Types.
*/
typedef struct _WSANSClassInfoA
{
   LPSTR   lpszName;
   DWORD   dwNameSpace;
   DWORD   dwValueType;
   DWORD   dwValueSize;
   LPVOID  lpValue;
} WSANSCLASSINFOA, *PWSANSCLASSINFOA, *LPWSANSCLASSINFOA;

typedef struct _WSANSClassInfoW
{
   LPWSTR  lpszName;
   DWORD   dwNameSpace;
   DWORD   dwValueType;
   DWORD   dwValueSize;
   LPVOID  lpValue;
} WSANSCLASSINFOW, *PWSANSCLASSINFOW, *LPWSANSCLASSINFOW;

#ifdef UNICODE
typedef WSANSCLASSINFOW WSANSCLASSINFO;
typedef PWSANSCLASSINFOW PWSANSCLASSINFO;
typedef LPWSANSCLASSINFOW LPWSANSCLASSINFO;
#else
typedef WSANSCLASSINFOA WSANSCLASSINFO;
typedef PWSANSCLASSINFOA PWSANSCLASSINFO;
typedef LPWSANSCLASSINFOA LPWSANSCLASSINFO;
#endif

typedef struct _WSAServiceClassInfoA
{
   LPGUID              lpServiceClassId;
   LPSTR               lpszServiceClassName;
   DWORD               dwCount;
   LPWSANSCLASSINFOA   lpClassInfos;
} WSASERVICECLASSINFOA, *PWSASERVICECLASSINFOA, *LPWSASERVICECLASSINFOA;

typedef struct _WSAServiceClassInfoW
{
   LPGUID              lpServiceClassId;
   LPWSTR              lpszServiceClassName;
   DWORD               dwCount;
   LPWSANSCLASSINFOW   lpClassInfos;
} WSASERVICECLASSINFOW, *PWSASERVICECLASSINFOW, *LPWSASERVICECLASSINFOW;

#ifdef UNICODE
typedef WSASERVICECLASSINFOW WSASERVICECLASSINFO;
typedef PWSASERVICECLASSINFOW PWSASERVICECLASSINFO;
typedef LPWSASERVICECLASSINFOW LPWSASERVICECLASSINFO;
#else
typedef WSASERVICECLASSINFOA WSASERVICECLASSINFO;
typedef PWSASERVICECLASSINFOA PWSASERVICECLASSINFO;
typedef LPWSASERVICECLASSINFOA LPWSASERVICECLASSINFO;
#endif

typedef struct _WSANAMESPACE_INFOA
{
   GUID                NSProviderId;
   DWORD               dwNameSpace;
   BOOL                fActive;
   DWORD               dwVersion;
   LPSTR               lpszIdentifier;
} WSANAMESPACE_INFOA, *PWSANAMESPACE_INFOA, *LPWSANAMESPACE_INFOA;
typedef struct _WSANAMESPACE_INFOW

{
   GUID                NSProviderId;
   DWORD               dwNameSpace;
   BOOL                fActive;
   DWORD               dwVersion;
   LPWSTR              lpszIdentifier;
} WSANAMESPACE_INFOW, *PWSANAMESPACE_INFOW, *LPWSANAMESPACE_INFOW;

#ifdef UNICODE
typedef WSANAMESPACE_INFOW WSANAMESPACE_INFO;
typedef PWSANAMESPACE_INFOW PWSANAMESPACE_INFO;
typedef LPWSANAMESPACE_INFOW LPWSANAMESPACE_INFO;
#else
typedef WSANAMESPACE_INFOA WSANAMESPACE_INFO;
typedef PWSANAMESPACE_INFOA PWSANAMESPACE_INFO;
typedef LPWSANAMESPACE_INFOA LPWSANAMESPACE_INFO;
#endif

#ifndef _WIN64
# include <poppack.h>
#endif

#endif
