/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability. 
=
=  Source(s): Microsoft-inspired Header
=
=  novsock2.h
==============================================================================
*/

#ifndef _WS2TCPIP_H_
#define _WS2TCPIP_H_

/* Argument structure for IP_ADD_MEMBERSHIP and IP_DROP_MEMBERSHIP */

struct ip_mreq {
	struct in_addr imr_multiaddr;	/* IP multicast address of group */
	struct in_addr imr_interface;	/* local IP address of interface */
};

/* TCP/IP specific Ioctl codes */

#define SIO_GET_INTERFACE_LIST  _IOR('t', 127, u_long)	

/* Option to use with [gs]etsockopt at the IPPROTO_IP level */

#define	IP_OPTIONS		1 /* set/get IP options */
#define	IP_HDRINCL		2 /* header is included with data */
#define	IP_TOS			3 /* IP type of service and preced*/
#define	IP_TTL			4 /* IP time to live */
#define	IP_MULTICAST_IF		9 /* set/get IP multicast i/f  */
#define	IP_MULTICAST_TTL       10 /* set/get IP multicast ttl */
#define	IP_MULTICAST_LOOP      11 /*set/get IP multicast loopback */
#define	IP_ADD_MEMBERSHIP      12 /* add an IP group membership */
#define	IP_DROP_MEMBERSHIP     13/* drop an IP group membership */


/* Option to use with [gs]etsockopt at the IPPROTO_UDP level */

#define UDP_NOCHECKSUM	1

/* Option to use with [gs]etsockopt at the IPPROTO_TCP level */

#define  TCP_EXPEDITED_1122	0x0002


/* IPv6 definitions */

struct in6_addr {
    union {
        u_char Byte[16];
        u_short Word[8];
    } u;
};

struct sockaddr_in6 {
      short sin6_family;    /* AF_INET6 */
      u_short sin6_port;      /* Transport level port number */
      u_long  sin6_flowinfo;  /* IPv6 flow information */
      struct in6_addr sin6_addr; /* IPv6 address */
      u_long sin6_scope_id;  /* set of interfaces for a scope */
};


typedef struct in_addr6 IN6_ADDR;
typedef struct in_addr6 *PIN6_ADDR;
typedef struct in_addr6 FAR *LPIN6_ADDR;

typedef struct sockaddr_in6 SOCKADDR_IN6;
typedef struct sockaddr_in6 *PSOCKADDR_IN6;
typedef struct sockaddr_in6 FAR *LPSOCKADDR_IN6;


#define in_addr6 in6_addr

/*
** Defines to match RFC 2553.
*/
#define _S6_un     u
#define _S6_u8     Byte
#define s6_addr    _S6_un._S6_u8

/*
** Defines for our implementation.
*/
#define s6_bytes   u.Byte
#define s6_words   u.Word


#define IN6ADDR_SETANY(x) {\
(x)->sin6_family = AF_INET6; \
(x)->sin6_port = 0; \
(x)->sin6_flowinfo = 0; \
*((u_long *)((x)->sin6_addr.s6_addr)    ) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 1) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 2) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 3) = 0; \
}

#define IN6ADDR_SETLOOPBACK(x) {\
(x)->sin6_family = AF_INET6; \
(x)->sin6_port = 0; \
(x)->sin6_flowinfo = 0; \
*((u_long *)((x)->sin6_addr.s6_addr)    ) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 1) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 2) = 0; \
*((u_long *)((x)->sin6_addr.s6_addr) + 3) = 1; \
}

int __inline IN6_IS_ADDR_V4MAPPED(const struct in6_addr *a)
{
    return ((a->s6_words[0] == 0) &&
            (a->s6_words[1] == 0) &&
            (a->s6_words[2] == 0) &&
            (a->s6_words[3] == 0) &&
            (a->s6_words[4] == 0) &&
            (a->s6_words[5] == 0xffff));
}

#define IN6ADDR_ISANY(x) ( \
(x)->sin6_family == AF_INET6 && \
*((u_long *)((x)->sin6_addr.s6_addr)    ) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 1) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 2) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 3) == 0 \
)


#define IN6ADDR_ISLOOPBACK(x) (\
(x)->sin6_family == AF_INET6 && \
*((u_long *)((x)->sin6_addr.s6_addr)    ) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 1) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 2) == 0 && \
*((u_long *)((x)->sin6_addr.s6_addr) + 3) == 1 \
)



typedef union sockaddr_gen{
		struct sockaddr Address;
		struct sockaddr_in  AddressIn;
		struct sockaddr_in6 AddressIn6;
} sockaddr_gen;

/* Structure to keep interface specific information */

typedef struct _INTERFACE_INFO
{
	u_long		iiFlags;		/* Interface flags */
	sockaddr_gen	iiAddress;		/* Interface address */
	sockaddr_gen	iiBroadcastAddress; 	/* Broadcast address */
	sockaddr_gen	iiNetmask;		/* Network mask */
} INTERFACE_INFO, FAR * LPINTERFACE_INFO;

/* Possible flags for the  iiFlags - bitmask  */ 

#define IFF_UP		0x00000001 /* Interface is up */
#define IFF_BROADCAST	0x00000002 /* Broadcast is  supported */
#define IFF_LOOPBACK	0x00000004 /* this is loopback interface */
#define IFF_POINTTOPOINT 0x00000008 /*this is point-to-point interface*/
#define IFF_MULTICAST	0x00000010 /* multicast is supported */

#define getaddrinfo WS2_32_getaddrinfo
#define getnameinfo WS2_32_getnameinfo
#define freeaddrinfo WS2_32_freeaddrinfo 

int
WS2_32_getaddrinfo(const char *hostname, const char *servname,
	const struct addrinfo *hints, struct addrinfo **res);

typedef int socklen_t;

int
WS2_32_getnameinfo(const struct sockaddr * sa, 
                   socklen_t    salen,
                   char         *host,
                   size_t        hostlen,
                   char         *serv,
                   size_t        servlen,
                   int          flags);


void
WS2_32_freeaddrinfo(struct addrinfo *ai);


struct addrinfo {
	int	ai_flags;	/* AI_PASSIVE, AI_CANONNAME, AI_NUMERICHOST */
	int	ai_family;	/* PF_xxx */
	int	ai_socktype;	/* SOCK_xxx */
	int	ai_protocol;	/* 0 or IPPROTO_xxx for IPv4 and IPv6 */
	size_t	ai_addrlen;	/* length of ai_addr */
	char	*ai_canonname;	/* canonical name for hostname */
	struct	sockaddr *ai_addr;	/* binary address */
	struct	addrinfo *ai_next;	/* next structure in linked list */
};

/*
 * Error return codes from getaddrinfo()
 */
#define	EAI_ADDRFAMILY	 1	/* address family for hostname not supported */
#define	EAI_AGAIN	 2	/* temporary failure in name resolution */
#define	EAI_BADFLAGS	 3	/* invalid value for ai_flags */
#define	EAI_FAIL	 4	/* non-recoverable failure in name resolution */
#define	EAI_FAMILY	 5	/* ai_family not supported */
#define	EAI_MEMORY	 6	/* memory allocation failure */
#define	EAI_NODATA	 7	/* no address associated with hostname */
#define	EAI_NONAME	 8	/* hostname nor servname provided, or not known */
#define	EAI_SERVICE	 9	/* servname not supported for ai_socktype */
#define	EAI_SOCKTYPE	10	/* ai_socktype not supported */
#define	EAI_SYSTEM	11	/* system error returned in errno */
#define	EAI_BADHINTS	12
#define	EAI_PROTOCOL	13
#define	EAI_MAX		14

/*
 * Flag values for getnameinfo()
 */
#define	NI_NOFQDN	0x00000001
#define	NI_NUMERICHOST	0x00000002
#define	NI_NAMEREQD	0x00000004
#define	NI_NUMERICSERV	0x00000008
#define	NI_DGRAM	0x00000010
#define NI_WITHSCOPEID	0x00000020


#endif	/* _WS2TCPIP_H_ */

