/*       WSIPX.H -- Winsock 2 Extensions for IPX networks
 *
 *  This file contains IPX/SPX specific information for use by
 *  Winsock 2 compabable applications.  Include this file below
 *  WINSOCK.H to enable IPX features in your application.
 *
 *                   Rev 0.3, Feb 23, 1995  
 */

#ifndef  _WSIPX_
#define  _WSIPX_

#pragma pack(1)

/* Transparant sockaddr definition for address family AF_IPX */
 
typedef struct sockaddr_ipx {
   u_short  sa_family;
   u_char   sa_netnum[4];
   u_char   sa_nodenum[6];
   unsigned short sa_socket;

} SOCKADDR_IPX, *PSOCKADDR_IPX, FAR *LPSOCKADDR_IPX;



/* Protocol types within protocol family PF_IPX 
 *
 * Protocol family PF_IPX reserves protocol id 0 - 255 for IP-conforming
 * protocol identifiers.
 *
 */

#define NSPROTO_UNSPEC        0
#define NSPROTO_IPX        1000
#define NSPROTO_SPX        1256
#define NSPROTO_SPXII      1257

/* Socket options for IPX level NSPROTO_IPX */

#define IPX_CATEGORY         NSPROTO_IPX

#define IPX_CHECKSUM         0x0001
#define IPX_PRIMARY          0x0002
#define IPX_TXPKTSIZE        0x1001
#define IPX_RXPKTSIZE        0x1002
#define IPX_TXMEDIASIZE      0x1003
#define IPX_RXMEDIASIZE      0x1004


/* Socket options for SPX level NSPROTO_SPX */

#define SPX_CATEGORY         NSPROTO_SPX

#define SPX_CHECKSUM         IPX_CHECKSUM
#define SPX_PRIMARY          IPX_PRIMARY
#define SPX_RAWSPX           0x0010
#define SPX_TXPKTSIZE        IPX_TXPKTSIZE
#define SPX_RXPKTSIZE        IPX_RXPKTSIZE
#define SPX_TXMEDIASIZE      IPX_TXMEDIASIZE
#define SPX_RXMEDIASIZE      IPX_RXMEDIASIZE


/*  net,node,socket portion of IPX header */

#define IPX_NET_SIZE    4
#define IPX_NODE_SIZE   6
#define IPX_SOCKET_SIZE 2

/* WSIpxAddr -- Ipx/Spx header net,node address structure */

typedef struct WSIpxAddrStruc
{
	  u_long    Net;
	  u_char    Node[IPX_NODE_SIZE];
	  u_short   Socket;
	  
} WSIpxAddr,*PWSIpxAddr,FAR *LPWSIpxAddr;

#define WSIpxNode0To3(pIpxAddr)         (*(UINT32*)(&((PWSIpxAddr*)pIpxAddr)->Node[0])
#define WSIpxNode4To5(pIpxAddr)         (*(UINT16*)(&((PWSIpxAddr*)pIpxAddr)->Node[3])

/* WSIpxHeader -- IPX header structure when in SOCK_RAW mode */

typedef struct WSIpxHeaderStruc
{
	  u_short     Checksum;               // 0x00
	  u_short     Length;                 // 0x02
	  u_char      XportCtl;               // 0x04
	  u_char      PktType;                // 0x05
	  WSIpxAddr   DestAddr;               // 0x06
	  WSIpxAddr   SrcAddr;                // 0x12
} WSIpxHeader, *PWSIpxHeader,FAR *LPWSIpxHeader;   // 0x1E total length

/* Standard IPX packet types */

#define   IPXTYPE_UNKNOWN         0x00
#define   IPXTYPE_RIP             0x01
#define   IPXTYPE_ECHO            0x02
#define   IPXTYPE_ERROR           0x03
#define   IPXTYPE_IPX             0x04
#define   IPXTYPE_SPX             0x05
#define   IPXTYPE_NCP             0x11
#define   IPXTYPE_NETBIOS         0x14
#define   IPXTYPE_INTERNET_BROADCAST   IPT_NETBIOS

/* WSSpxHeader -- SPX Header structure when in SPXL_SPXRAW mode. */

typedef struct WSSpxHeaderStruc
{
	  WSIpxHeader  IpxHdr;              // 0x00
	  u_char       ConnCtrl;            // 0x1E
	  u_char       DataStreamType;      // 0x1F
	  u_short      SrcConnId;           // 0x20
	  u_short      DstConnId;           // 0x22
	  u_short      SendSeq;             // 0x24
	  u_short      AckSeq;              // 0x26
	  u_short      AllocNum;            // 0x28
} WSSpxHeader, *PWSSpxHeader,FAR *LPWSSpxHeader;   // 0x2A (42) size

/* Connection Control Bits */

#define   SPX_SYSTEM_PACKET_BIT       0x80
#define   SPX_SEND_ACK_BIT            0x40
#define   SPX_ATTENTION_BIT           0x20
#define   SPX_END_OF_MESSAGE_BIT      0x10

/* Data Stream Types.
 *
 * Values in the range 0 - 0xfd are user-definable.
 */

#define   SPX_HANG_UP                 0xFE
#define   SPX_HANG_UP_ACK             0xFF


/* a sampling of well-known socket types in network hi-lo order.
 * use ntohl() for local representation.
 */

#define   IPXSKT_DYNAMIC                   0x0000
#define   IPXSKT_NCP                       0x5104
#define   IPXSKT_SAP                       0x5204
#define   IPXSKT_RIP                       0x5304
#define   IPXSKT_NETBIOS                   0x5504
#define   IPXSKT_DIAGNOSTICS               0x5604
#define   IPXSKT_PING                      0x8690


#endif /* _WSIPX_ */
