#
#  A sample Makefile for the NetWare loadable modules making
#  on Linux and Win32 (Cygwin) platforms with the GNU utilities
#
#  Written by Pavel Novy <novy@feld.cvut.cz>
#  Version 1.0.21 (2001-12-23)
#

NLMSTUFF      := $(NLMSTUFF)
NDKLIB         = $(LIBC)
ZLIB           = ../..
GNU-BUILD      = $(ZLIB)/build/netware-GNU

TARGET         = zlib
BUILD          =
MAKEFILE       = $(TARGET).Makefile
CFLAGS         = #-save-temps #-v
DEFINES        = -DN_PLAT_NLM
INCLUDES       =
LIBRARIES      =
SOURCE_DEP     =
TARGET_DEP     = $(GNU-BUILD)/$(TARGET).imp
SOURCES        = $(ZLIB)/adler32.c \
		 $(ZLIB)/compress.c \
		 $(ZLIB)/crc32.c \
		 $(ZLIB)/gzio.c \
		 $(ZLIB)/uncompr.c \
		 $(ZLIB)/deflate.c \
		 $(ZLIB)/trees.c \
		 $(ZLIB)/zutil.c \
		 $(ZLIB)/inflate.c \
		 $(ZLIB)/infblock.c \
		 $(ZLIB)/inftrees.c \
		 $(ZLIB)/infcodes.c \
		 $(ZLIB)/infutil.c \
		 $(ZLIB)/inffast.c

DESCRIPTION    = zlib 1.1.3 [$(NLMSTUFF_SIGN)]
VERSION        = 1,1,3
DATE           =
COPYRIGHT      = Copyright \(c\) 1995-1998 Jean-loup Gailly and Mark Adler
THREADNAME     = $(TARGET)_p
SCREENNAME     = $(DESCRIPTION)#NONE

TYPE           = nlm# nlm | lan | dsk | nam | a
OPTIONS        = #pseudopreemption#debug multiple os_domain pseudopreemption reentrant synchronize
FLAG_ON        = 64#64 for autounload
XDCDATA        =
START          =# _Prelude
EXIT           =# _Stop
CHECK          =
STACK          = 8192
PRELUDE        = $(NLMSTUFF)/imports/nopre0.o
EXPORTS        = @$(GNU-BUILD)/$(TARGET).imp
IMPORTS        =
EXPORTFILES    =
IMPORTFILES    = libc
MODULES        = libc

include $(NLMSTUFF)/Makefile.GNU
