/* main.c
 * main() and mainloop() functions
 * 
 * Copyright (C) 2002-2003 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: main.c 1.10 Fri, 30 Aug 2002 20:13:05 -0400 pahan $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include<winsock2.h>
#include<windows.h>
#include<stdio.h>
#include<conio.h>
#include"rcon.h"
#include"getopt.h"


HANDLE hconout, hconin;
char proxy[128];
int useSSL;
int proxySPX;
struct HINSTANCE__ *SSLLibHandle;
struct HINSTANCE__ *SSLUtilHandle;
int programTerminate;
int syncScreen;

#ifdef USE_SSL
int main_initSSL() {
	SSLLibHandle = LoadLibrary("ssleay32.dll");
	if (SSLLibHandle == 0)
	{
		SSLLibHandle = LoadLibrary("libssl32.dll");
	}
	SSLUtilHandle = LoadLibrary("libeay32.dll");

	if (SSLLibHandle == 0 || SSLUtilHandle == 0)
		return 0;

	SSL_get_error_RT = (SSL_get_error_) GetProcAddress(SSLLibHandle, "SSL_get_error");
	SSL_write_RT = (SSL_write_) GetProcAddress(SSLLibHandle, "SSL_write"); 
	SSL_read_RT = (SSL_read_) GetProcAddress(SSLLibHandle, "SSL_read");
	SSL_library_init_RT = (SSL_library_init_) GetProcAddress(SSLLibHandle, "SSL_library_init");
	SSL_load_error_strings_RT = (SSL_load_error_strings_) GetProcAddress(SSLLibHandle, "SSL_load_error_strings");
	SSLv3_client_method_RT = (SSLv3_client_method_) GetProcAddress(SSLLibHandle, "SSLv3_client_method");
	SSL_CTX_new_RT = (SSL_CTX_new_) GetProcAddress(SSLLibHandle, "SSL_CTX_new");
	SSL_CTX_free_RT = (SSL_CTX_free_) GetProcAddress(SSLLibHandle, "SSL_CTX_free");
	SSL_new_RT = (SSL_new_) GetProcAddress(SSLLibHandle, "SSL_new");
	SSL_free_RT = (SSL_free_) GetProcAddress(SSLLibHandle, "SSL_free");
	SSL_set_fd_RT = (SSL_set_fd_) GetProcAddress(SSLLibHandle, "SSL_set_fd");
	SSL_connect_RT = (SSL_connect_) GetProcAddress(SSLLibHandle, "SSL_connect");
	SSL_shutdown_RT = (SSL_shutdown_) GetProcAddress(SSLLibHandle, "SSL_shutdown");

	return 1;
}
#endif //USE_SSL

// initialize the console
void main_initscr() {
    COORD c;
    SMALL_RECT r;
    CONSOLE_SCREEN_BUFFER_INFO csbo;
//    DWORD temp;
    // get a brand-new console
    FreeConsole();
    AllocConsole();
    // hack-around for Win2k bug
    if(GetConsoleOutputCP() == 866) {
        SetConsoleOutputCP(1251);
    }
    // a similar workaround for Central Europe
    if(GetConsoleOutputCP() == 852) {
        SetConsoleOutputCP(1250);
    }
    hconout = GetStdHandle(STD_OUTPUT_HANDLE);
    hconin = GetStdHandle(STD_INPUT_HANDLE);
    SetConsoleMode(hconin, 0);
    // resize
    GetConsoleScreenBufferInfo(hconout, &csbo);
    c = GetLargestConsoleWindowSize(hconout);
    /* define the new console window size and scroll position */
    r.Right = (SHORT) (MIN(XSIZE, c.X) - 1);
    r.Bottom = (SHORT) (MIN(YSIZE, c.Y) - 1);
    r.Left = r.Top = (SHORT) 0;
    /* define the new console buffer size */
    c.X = XSIZE;
    c.Y = YSIZE;
    /* if the current buffer is larger than what we want, resize the */
    /* console window first, then the buffer */
    if((DWORD) csbo.dwSize.X * csbo.dwSize.Y > (DWORD) XSIZE * YSIZE) {
        SetConsoleWindowInfo(hconout, TRUE, &r);
        SetConsoleScreenBufferSize(hconout, c);
    }
    /* if the current buffer is smaller than what we want, resize the */
    /* buffer first, then the console window */
    if((DWORD) csbo.dwSize.X * csbo.dwSize.Y < (DWORD) XSIZE * YSIZE) {
        SetConsoleScreenBufferSize(hconout, c);
        SetConsoleWindowInfo(hconout, TRUE, &r);
    }
    /* if the current buffer *is* the size we want, don't do anything! */
    c.X = 0;
    c.Y = 0;
}

void main_usage()
{
	fprintf(stderr,"rconip [opts] [host[:port]] [password]\n");
	fprintf(stderr,"opts:\n");
	fprintf(stderr,"\n");
#ifdef USE_SSL
	fprintf(stderr,"    -s\n");
	fprintf(stderr,"OR  --ssl     Connect using SSL\n");
#endif
	fprintf(stderr,"    -?\n");
	fprintf(stderr,"OR  --help    Show this usage\n");
	fprintf(stderr,"    -p host   Connect via Proxy host\n");
	fprintf(stderr,"    --spx     Proxy connects with SPX\n");
	fprintf(stderr,"    --sync    Start in screen sync mode (toggle with Alt-F6)\n");
	fprintf(stderr,"\nPress any key to exit..\n");
	getch();
	exit(1);
}


int main(int argc, char **argv) {
    WSADATA wsa;
#ifdef USE_SSL
    int c;
#endif

	proxy[0]='\0';
	proxySPX=0;
	useSSL=0;
	programTerminate=0;
	syncScreen=0;
    opterr = 0;
    while ((c = getopt (argc, argv, "s-:p:?")) != -1)
	{
		switch (c)
		{
			case '?':
				main_usage();
				break;
#ifdef USE_SSL
			case 's':
				useSSL = 1;
				break;
#endif
			case 'p':
				strcpy(proxy,optarg);
				break;
			case '-':
#ifdef USE_SSL
				if (strstr(strupr(optarg),"SSL")) useSSL = 1;
#endif
				if (strstr(strupr(optarg),"SPX")) proxySPX = 1;
				if (strstr(strupr(optarg),"SYNC")) syncScreen = 1;
				if (strstr(strupr(optarg),"HELP")) main_usage();
				break;
		}
	}

	if (strlen(proxy) && useSSL)
	{
		fprintf(stderr,"\nCan not use SSL with a proxy\n\n");
		exit (1);
	}

#ifdef USE_SSL
	if (useSSL)
		useSSL=main_initSSL();
#else
	useSSL=FALSE;
#endif

    main_initscr();


    if(WSAStartup(MAKEWORD(2,2), &wsa)) {
        PERR "Unable to initialize WinSock (%d)", WSAGetLastError());
        menu_disperr(globerr);
        return 1;
    }

    if(argv[optind]==NULL) {
        slist_main(NULL);
    } else if(argv[optind+1]==NULL) {
        slist_main(argv[optind]);
    } else if(argv[optind+1]!=NULL) {
        rcon_session(argv[optind], argv[optind+1], 0);
    }

#ifdef USE_SSL
	FreeLibrary(SSLLibHandle);
	FreeLibrary(SSLUtilHandle);
#endif
    WSACleanup();
    return 0;
}
