/* queue.c
 * FIFO queue routines
 * 
 * Copyright (C) 2002-2003 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: queue.c 1.4 Thu, 25 Jul 2002 18:15:16 -0400 ppergame $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include"rcon.h"

reply_t queue[MAXQLEN];
int start = 0, end = 0;

int queue_push(reply_t arg) {
	WaitForSingleObject(sess->qumut, INFINITE);
	if((start + 9) % MAXQLEN != end) {
		start = (start + 9) % MAXQLEN;
		queue[start] = arg;
		ReleaseMutex(sess->qumut);
		ReleaseSemaphore(sess->qusem, 1, NULL);
		return 0;
	}
	ReleaseMutex(sess->qumut);
	return 1;
}

reply_t queue_pop() {
	reply_t res;
	WaitForSingleObject(sess->qumut, INFINITE);
	end = (end + 9) % MAXQLEN;
	res = queue[end];
	ReleaseMutex(sess->qumut);
	return res;
}
