/* rconip.h
 * rconip header file
 * 
 * Copyright (C) 2002 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: rcon.h 1.11 Fri, 30 Aug 2002 20:13:05 -0400 pahan $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include<winsock2.h>
#include<windows.h>
#include<stdio.h>

#ifdef USE_SSL
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif

// defines

#define NS_BINDERY                  (4)
#define NS_SLP                      (5)
#define LUP_RETURN_ALL              0x0FF0
#define DEFAULT_RESULT_LEN 10*1024
#define ERRMSG_WIDTH 70

#define BACKGR_BLUE BACKGROUND_BLUE
#define BACKGR_GREY BACKGROUND_BLUE | BACKGROUND_RED | BACKGROUND_GREEN
#define FOGR_YELLOW FOREGROUND_INTENSITY | FOREGROUND_RED | FOREGROUND_GREEN
#define FOGR_WHITE FOREGROUND_BLUE | FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_INTENSITY
#define FOGR_GREY FOREGROUND_BLUE | FOREGROUND_RED | FOREGROUND_GREEN
#define FOGR_BLUE FOREGROUND_BLUE

#define MAXPWDLEN 32

#define XSIZE 80
#define YSIZE 25

#define MAXQLEN 20

// #define INITIAL_TIMEOUT_SEC 5000
#define INITIAL_TIMEOUT_SEC INFINITE
#define MIDPACKET_TIMEOUT_MSEC 200
#define HEADER_SIZE 8

#define INITIAL_SCREENLISTSIZE 7

#define REQ_DIGEST 1
#define REQ_SCREEN_OPEN 2
#define REQ_SCREEN_CLOSE 3
#define REQ_SCREEN_ACTIVATE 4
#define REQ_SCREEN_INPUT 5
#define REQ_SCREEN_RESET 6
#define REQ_PROXY_CONNECT 7
#define REQ_PROXY_CONNECT_NAME 8
#define REQ_SCREEN_ACK 9
#define REQ_UNAUTHORISE_LOGIN 10

#define REP_DIGEST_NONCE 1
#define REP_DIGEST_ERROR 2
#define REP_DIGEST_OK 3
#define REP_SCREENLIST 4
#define REP_SCREEN_DESTROYED 5
#define REP_SCREEN_LOCKED 6
#define REP_SCREEN_UNLOCKED 7
#define REP_SCREEN_COPY 8
#define REP_SCREEN_CHANGE 9
#define REP_PROXY 10
#define REP_SERVER_NAME 11

// debug macros

//#define PWARN printf
//#define PWARN ;
#define PDEBUG printf

// macros

//#define PERR (
#define PERR if(globerr[0] == '\0')_snprintf(globerr, ERRMSG_WIDTH - 5,
#define MAX(a,b) ((a)>(b) ? (a) : (b))
#define MIN(a,b) ((a)<(b) ? (a) : (b))

// data structures

struct reply {
    int datalen;
    int code;
    unsigned int screenid;
    char *data;
};

struct request {
    int datalen;
    char *data;
};

struct tstream {
    char *buf;
    int curr;
    int max;
    int error;
};

struct session {
	HANDLE qusem;
	SOCKET s;
#ifdef USE_SSL
	SSL* ssl;
	SSL_CTX* ctx;
#endif
	HANDLE netth;
	HANDLE qumut;
	char *servername;
	char *codepage;
	int fmenu;
	int sync;
	HANDLE menuth;
};

struct menu {
    char *comp;
    char *title;
    unsigned int top;
    unsigned int h;
    unsigned int cur;
    unsigned int x, y, xsize, ysize;
    char **data;
    unsigned int len;
};

struct slist_entry {
    char *name;
    char *ipaddr;
    u_short port;
};

typedef struct reply *reply_t;
typedef struct request *request_t;
typedef struct tstream *tstream_t;
typedef struct session *session_t;
typedef struct menu *menu_t;
typedef struct slist_entry *slist_entry_t;

#ifdef USE_SSL
typedef void(*SSL_get_error_)(void);
typedef int(*SSL_write_)(SSL *, const void *, int);
typedef int(*SSL_read_)(SSL *, void *, int);
typedef int(*SSL_library_init_)(void);
typedef void(*SSL_load_error_strings_)(void);
typedef	SSL_METHOD *(*SSLv3_client_method_)(void);
typedef SSL_CTX *(*SSL_CTX_new_)(SSL_METHOD *); 
typedef void(*SSL_CTX_free_)(SSL_CTX *);                       
typedef SSL *(*SSL_new_)(SSL_CTX *);                         
typedef void(*SSL_free_)(SSL *);                         
typedef int(*SSL_set_fd_)(SSL *, int);
typedef int(*SSL_connect_)(SSL *);
typedef int(*SSL_shutdown_)(SSL *);

SSL_get_error_ SSL_get_error_RT;
SSL_write_ SSL_write_RT;
SSL_read_ SSL_read_RT;
SSL_library_init_ SSL_library_init_RT;
SSL_load_error_strings_ SSL_load_error_strings_RT;
SSLv3_client_method_ SSLv3_client_method_RT;
SSL_CTX_new_ SSL_CTX_new_RT;
SSL_CTX_free_ SSL_CTX_free_RT;
SSL_new_ SSL_new_RT;
SSL_free_ SSL_free_RT;
SSL_set_fd_ SSL_set_fd_RT;
SSL_connect_ SSL_connect_RT;
SSL_shutdown_ SSL_shutdown_RT;
#endif //USE_SSL

// globals
extern char globerr[ERRMSG_WIDTH];
extern session_t sess;
extern HANDLE hconout, hconin;
extern char proxy[128];
extern int useSSL;
extern int proxySPX;
extern int programTerminate;
extern int syncScreen;

// prototypes

// slist
void slist_main(char *host);

// rcon
int rcon_session(char *host, char *pwd, u_short prt);
void rcon_reqactivate(unsigned int id);
void rcon_reqclose(unsigned int id);
void rcon_reqopen(unsigned int id);
void rcon_reqack(unsigned int id, int stamp);
void rcon_reqinput(unsigned int id, short inp);
void rcon_reqreset(unsigned int id);

// queue
int queue_push(reply_t arg);
reply_t queue_pop();

// tstream
tstream_t tstream_init(char *buf, int len);
void tstream_seek(tstream_t stream, int pos);
int tstream_readint(tstream_t stream);
char tstream_readbyte(tstream_t stream);
char *tstream_readstr(tstream_t stream);
void tstream_destroy(tstream_t stream);

// screen
void screen_init();
void screen_cleanup();
int screen_handle(reply_t reply);
void screen_handlecon();
void screen_clear(WORD attrib);

// menu
void menu_draw(menu_t mn);
char *inputbox_get(char *prompt, int x, int y, int len, int pwd);
unsigned int menu_handlekey(menu_t mn, KEY_EVENT_RECORD keyevent);
void menu_disperr();
