/* screen.c
 * Screen update routines
 * 
 * Copyright (C) 2002-2003 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: screen.c 1.11 Fri, 30 Aug 2002 20:13:05 -0400 pahan $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include<winsock2.h>
#include<windows.h>
#include<process.h>
#include<stdlib.h>
#include"rcon.h"

struct screen {
    unsigned int id;
    char *name;
};

typedef struct screen *screen_t;

HANDLE slistmut;
screen_t *screenlist;
unsigned int activescr=-1;
int numscr;
int currscr;
char expanded[8000];
char content[4000];
int cursorx, cursory;

int screen_find(unsigned int id) {
    int i;
    for(i = 0; i < numscr; i++)
        if(screenlist[i]->id == id) {
            return i;
        }
    return -1;
}

char *screen_getname(unsigned int id) {
    int i;
    for(i = 0; i < numscr; i++)
        if(screenlist[i]->id == id) {
            return(screenlist[i]->name);
        }
    return(NULL);
}

int screen_find_by_name(char *name) {
    int i;
    for(i = 0; i < numscr; i++)
        if(!strcmp(screenlist[i]->name, name)) {
            return i;
        }
    return -1;
}

void screen_changecur(int ind) {
    if(currscr != -1) {
        rcon_reqclose(screenlist[currscr]->id);
    }
    currscr = ind;
    if(currscr == -1) {
        currscr = 0;
    }
    rcon_reqopen(screenlist[currscr]->id);
}

unsigned __stdcall screen_menuthread(void *arg) {
    HANDLE handles[2];
    struct menu mn;
    int brk = 0, l, res, i, currind, len = numscr;
    INPUT_RECORD ir;
    DWORD temp;
    char **scr = malloc(len * sizeof(char *));
    for(i = 0; i < len; i++)
        scr[i] = strdup(screenlist[i]->name);
    mn.title = "  Choose a screen";
    mn.cur = 0;
    mn.data = scr;
    mn.len = numscr;
    mn.top = 0;
    mn.x = 20;
    mn.y = 8;
    mn.xsize = 40;
    mn.ysize = 10;
    mn.comp = malloc(mn.xsize + 1);
    memset(mn.comp, 0, mn.xsize + 1);
    menu_draw(&mn);
    currind = currscr != -1 ? screenlist[currscr]->id : -1;

    brk = 0;
    handles[0] = hconin;
    handles[1] = sess->netth;
    while(!brk) {
        res = WaitForMultipleObjects(2, handles, 0, INFINITE);
        switch(res) {
        case WAIT_OBJECT_0:
            ReadConsoleInput(hconin, &ir, 1, &temp);
            if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown) {
                for(l = 0; l < ir.Event.KeyEvent.wRepeatCount; l++) {
                    res = menu_handlekey(&mn, ir.Event.KeyEvent);
                    if(res == 2) {  // ESC Pressed
                        sess->fmenu = 3;
                        brk = 1;
                        WaitForSingleObject(slistmut, INFINITE);
                        screen_changecur(screen_find(currind));
                        ReleaseMutex(slistmut);
                    } else if(res == 3) { // Enter Pressed
                        brk = 1;
                        WaitForSingleObject(slistmut, INFINITE);
                        res = screen_find_by_name(mn.data[mn.cur]);
                        if(res == -1) {
                            rcon_reqreset(screenlist[currscr]->id);
                            sess->fmenu = 3;
                        }
                        sess->fmenu = 3;
                        screen_changecur(res);
                        ReleaseMutex(slistmut);
                    }
                }
            }
            break;
        case WAIT_OBJECT_0 + 1:
            brk = 1;
            break;
        }
    }
    free(mn.comp);
    for(i = 0; i < len; i++)
        free(scr[i]);
    free(scr);

    SetEvent(arg);
    return 0;
}

unsigned __stdcall screen_exitthread(void *arg) {
    HANDLE handles[2];
    struct menu mn;
    int brk = 0, l, res;
    INPUT_RECORD ir;
    DWORD temp;
    char *options[] = {"Yes","No"};

    mn.title = "  Exit Remote Console IP?";
    mn.cur = 0;
    mn.data = options;
    mn.len = 2;
    mn.top = 0;
    mn.x = 25;
    mn.y = 8;
    mn.xsize = 30;
    mn.ysize = 3;
    mn.comp = malloc(mn.xsize + 1);
    memset(mn.comp, 0, mn.xsize + 1);
    menu_draw(&mn);

    brk = 0;
    handles[0] = hconin;
    handles[1] = sess->netth;
    while(!brk) {
        res = WaitForMultipleObjects(2, handles, 0, INFINITE);
        switch(res) {
        case WAIT_OBJECT_0:
            ReadConsoleInput(hconin, &ir, 1, &temp);
            if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown) {
                for(l = 0; l < ir.Event.KeyEvent.wRepeatCount; l++) {
                    res = menu_handlekey(&mn, ir.Event.KeyEvent);
		    if(res == 2) { // ESC pressed
                        sess->fmenu = 3;
                        brk = 1;
                        WaitForSingleObject(slistmut, INFINITE);
                        screen_changecur(screen_find(screenlist[currscr]->id));
                        ReleaseMutex(slistmut);
                    } else if(res == 3) { // Enter pressed
			brk = 1;
			if (mn.cur == 0) { // Option = "Yes"
                            sess->fmenu = 2;
			    programTerminate=1;
			}
			else // Refresh the screen
			{
	                    sess->fmenu = 3;
                            WaitForSingleObject(slistmut, INFINITE);
                            screen_changecur(screen_find(screenlist[currscr]->id));
                            ReleaseMutex(slistmut);
			}
                    }
                }
            }
            break;
        case WAIT_OBJECT_0 + 1:
            brk = 1;
            break;
        }
    }

    SetEvent(arg);
    return 0;
}

void screen_reattr(WORD *ne, char *ol, int count) {
    int i;
    for(i = 0; i < count; i++)
        ne[i] = ol[i];
}

int screen_enhkey(KEY_EVENT_RECORD keyevent) {
    return keyevent.dwControlKeyState & ENHANCED_KEY;
}

int screen_shiftdown(KEY_EVENT_RECORD keyevent) {
    return keyevent.dwControlKeyState & SHIFT_PRESSED;
}

int screen_ctrldown(KEY_EVENT_RECORD keyevent) {
    return keyevent.dwControlKeyState & (LEFT_CTRL_PRESSED | RIGHT_CTRL_PRESSED);
}

int screen_altdown(KEY_EVENT_RECORD keyevent) {
    return keyevent.dwControlKeyState & (LEFT_ALT_PRESSED | RIGHT_ALT_PRESSED);
}

int screen_altfnkey(int key) {
    unsigned tmp;
    HANDLE initev;

	switch(key) {
    case 1: // display and handle window list
        sess->fmenu = 2;
        initev = CreateEvent(NULL, 1, 0, NULL);
        sess->menuth = (HANDLE)_beginthreadex(NULL, 0, screen_menuthread, initev, 0, &tmp);
        WaitForSingleObject(initev, INFINITE);
        CloseHandle(initev);

        if ((sess->sync == 1) && (currscr != -1)) {
            rcon_reqactivate(screenlist[currscr]->id);
		}
        break;
    case 2: // terminate connection
        sess->fmenu = 2;
		programTerminate=0;
        initev = CreateEvent(NULL, 1, 0, NULL);
        sess->menuth = (HANDLE)_beginthreadex(NULL, 0, screen_exitthread, initev, 0, &tmp);
        WaitForSingleObject(initev, INFINITE);
        CloseHandle(initev);

		if (programTerminate == 1)
		{
#ifdef USE_SSL
			if (useSSL)
			{
				SSL_shutdown_RT(sess->ssl);
				shutdown(sess->s, SD_SEND);
				SSL_shutdown_RT(sess->ssl);
			} else
#endif
				shutdown(sess->s, SD_BOTH);
		}
        break;
    case 3: // previous window
        if(currscr != -1) {
            int newcurr;
            WaitForSingleObject(slistmut, INFINITE);
            if(currscr == 0) {
                newcurr = numscr - 1;
            } else {
                newcurr = currscr - 1;
            }
            screen_changecur(screen_find(screenlist[newcurr]->id));
	        if ((sess->sync == 1) && (currscr != -1)) {
	            rcon_reqactivate(screenlist[currscr]->id);
			}
            ReleaseMutex(slistmut);
        }
        break;
    case 4: // next window
        if(currscr != -1) {
            int newcurr;
            WaitForSingleObject(slistmut, INFINITE);
            if(currscr == numscr - 1) {
                newcurr = 0;
            } else {
                newcurr = currscr + 1;
            }
            screen_changecur(screen_find(screenlist[newcurr]->id));
	        if ((sess->sync == 1) && (currscr != -1)) {
	            rcon_reqactivate(screenlist[currscr]->id);
			}
            ReleaseMutex(slistmut);
        }
        break;
    case 5: // activate window
        if(currscr != -1) {
            rcon_reqactivate(screenlist[currscr]->id);
        }
        break;
    case 6: // toggle sync
		if (sess->sync == 0)
			sess->sync = 1;
		else
			sess->sync = 0;

        if(currscr != -1) {
            rcon_reqactivate(screenlist[currscr]->id);
        }
        screen_changecur(screen_find(screenlist[currscr]->id));

		break;
    default:
        return 0;
    }
    return 1;
}

int screen_setcontent(reply_t reply, int redraw) {
//    HANDLE tmp;
    unsigned long temp;
	char scrname[128];
	char scrsync[10];
//    int dump = 0;
	CONSOLE_CURSOR_INFO cinfo;
    WORD attr[2000];
    int stamp, i, k, j, state;
    unsigned char b1, b2, xpos, ypos;
    COORD coord;
    tstream_t stream = tstream_init(reply->data, reply->datalen);
    stamp = tstream_readint(stream);
    xpos = tstream_readbyte(stream);
    ypos = tstream_readbyte(stream);
/*    if(dump) {
        tmp = CreateFile("blah", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
        WriteFile(tmp, reply->data, reply->datalen, &temp, NULL);
        CloseHandle(tmp);
    }*/
    i = 0;
    k = 0;
    b2 = 0;
    state = 0;
    while(stream->curr < stream->max && i < 4000) {
        b1 = tstream_readbyte(stream);
        switch(state) {
        case 0: // base state
            switch(b1) {
            case 27:
                state = 1;
                break;
            case 28:
                state = 3;
                break;
            case 29:
                state = 6;
                break;
            default:
                expanded[i++] = b1;
            }
            break;
        case 1: // repeat1_1
            b2 = b1;
            state = 2;
            break;
        case 2: // repeat1_2
            k = b1;
            if(i + k > 8000) {
                break;
            }
            if(b2 == 29) {
                for(j = 0; j < k/2; j++)
                    expanded[i++] = 29;
                if(k % 2) {
                    state = 6;
                } else {
                    state = 0;
                }
            } else {
                for(j = 0; j < k; j++)
                    expanded[i++] = b2;
                state = 0;
            }
            break;
        case 3: // repeat2_1
            b2 = b1;
            state = 4;
            break;
        case 4: // repeat2_2
            k = b1;
            state = 5;
            break;
        case 5: // repeat2_3
            k += b1 << 8;
            if(i + k > 8000) {
                break;
            }
            for(j = 0; j < k; j++)
                expanded[i++] = b2;
            state = 0;
            break;
        case 6: // escape
            switch(b1) {
            case 1: // 27
                expanded[i++] = 27;
                break;
            case 2: // 28
                expanded[i++] = 28;
                break;
            case 29: // 29
                expanded[i++] = 29;
                break;
            }
            state = 0;
            break;
        }
    }
    if(i != 4000) {
        return 1;
    }
    tstream_destroy(stream);
    if(redraw) {
        for(i = 0, j = 2000; i < 2000; i++, j++) {
            content[i] = expanded[i];
            content[j] = expanded[j];
        }
    } else {
        for(i = 0, j = 2000; i < 2000; i++, j++) {
            content[i] ^= expanded[i];
            content[j] ^= expanded[j];
        }
    }
    if(sess->fmenu == 3) {
        coord.X = 0;
        coord.Y = 0;
        WriteConsoleOutputCharacter(hconout, (char *)content, 2000, coord, &temp);
        screen_reattr(attr, content + 2000, 2000);
        WriteConsoleOutputAttribute(hconout, attr, 2000, coord, &temp);
        cursorx = xpos;
        cursory = ypos;
        coord.X = cursorx;
        coord.Y = cursory;
		GetConsoleCursorInfo(hconout,&cinfo);
		if(xpos==255 || ypos==255)
			cinfo.bVisible=FALSE;
		else
			cinfo.bVisible=TRUE;
		SetConsoleCursorInfo(hconout,&cinfo);
        SetConsoleCursorPosition(hconout, coord);

		if (sess->sync == 1) strcpy(scrsync,"(S) ");
		else strcpy(scrsync,"");

		if(useSSL)
			sprintf(scrname,"%s%s [SSL]: %s",scrsync,sess->servername,screen_getname(reply->screenid));
		else
			sprintf(scrname,"%s%s: %s",scrsync,sess->servername,screen_getname(reply->screenid));

		if (activescr == reply->screenid) strcat(scrname, " (Active)");
		SetConsoleTitle(scrname);
    }
    rcon_reqack(reply->screenid, stamp);
    return 0;
}

short screen_keymap(KEY_EVENT_RECORD keyevent) {
    int i = 0;
    int flag = 1;
    int j = keyevent.wVirtualKeyCode;
/*    char s[1024];
    sprintf(s, "%d wVirtualKeyCode", j);
    OutputDebugString(s);*/
    switch(j) {
    case VK_HOME:
        i = 71;
//        if(screen_ctrldown(keyevent))
//            i = 119;
        break;
        
    case VK_END:
        i = 79;
//        if(screen_ctrldown(keyevent))
//            i = 117;
        break;
        
    case VK_PRIOR:
        i = 73;
        if(screen_ctrldown(keyevent))
            i = 124;
        break;
        
    case VK_NEXT:
        i = 81;
        if(screen_ctrldown(keyevent))
            i = 125;
        break;

    case VK_UP:
        i = 72;
        break;

    case VK_DOWN:
        i = 80;
        break;

    case VK_LEFT:
        i = 75;
        break;

    case VK_RIGHT:
        i = 77;
        break;

    case VK_F1:
    case VK_F2:
    case VK_F3:
    case VK_F4:
    case VK_F5:
    case VK_F6:
    case VK_F7:
    case VK_F8:
    case VK_F9:
    case VK_F10:
        i = (j - 112) + 59;
        if(screen_shiftdown(keyevent)) {
            i += 25;
        } else {
            if(screen_ctrldown(keyevent)) {
                i += 35;
            } else {
                if(screen_altdown(keyevent)) {
                    i += 45;
                    if(screen_altfnkey((j - 112) + 1)) {
                        i = 0;
                    }
                }
            }
        }
        break;

	case VK_MULTIPLY:
		if (!(keyevent.dwControlKeyState & NUMLOCK_ON))
		{
			screen_altfnkey(1);
			i = 255;
		}
		break;

	case VK_ADD:
		if (!(keyevent.dwControlKeyState & NUMLOCK_ON))
		{
	        screen_altfnkey(4);
			i = 255;
		}
		break;

	case VK_SUBTRACT:
		if (!(keyevent.dwControlKeyState & NUMLOCK_ON))
		{
			screen_altfnkey(3);
			i = 255;
		}
		break;

	case VK_DIVIDE:
		if (!(keyevent.dwControlKeyState & NUMLOCK_ON))
		{
	        screen_altfnkey(2);
			i = 255;
		}
		break;

    case VK_RETURN:
 		if (!(keyevent.dwControlKeyState & NUMLOCK_ON) && keyevent.dwControlKeyState & ENHANCED_KEY)
		{
	        screen_altfnkey(5);
			i = 255;
		}
		else
		{
			i = 13;
		    flag = 0;
		}
        break;

    case VK_INSERT:
        i = 82;
        break;

    case VK_ESCAPE:
        i = 27;
        flag = 0;
        break;

    case VK_DELETE:
        i = 83;
        break;

    case VK_BACK:
        i = 8;
        flag = 0;
        break;

    case VK_TAB:
        if(screen_shiftdown(keyevent))
        {
            i = 15;
        } else {
            i = 9;
            flag = 0;
        }
        break;
    }

    if(!flag) {
        i <<= 8;
    }
    return (short)i;
}

short screen_charmap(char c) {
    return (short)(c << 8);
}

int screen_createlist(reply_t reply) {
    int i = 0, j;
	tstream_t stream = tstream_init(reply->data, reply->datalen);

    activescr = reply->screenid;
    currscr = -1;
    while(1) {
        for(; stream->curr < stream->max && i < numscr; i++) {
            screenlist[i]->id = tstream_readint(stream);
            free(screenlist[i]->name);
            screenlist[i]->name = tstream_readstr(stream);
            if(screenlist[i]->id == reply->screenid) {
                currscr = i;
            }
        }
        if(stream->error) {
            PERR "Invalid data received");
            return 1;
        }
        if(stream->curr < stream->max) {
            numscr++;
            screenlist = realloc(screenlist, numscr * sizeof(screen_t));
            screenlist[numscr - 1] = (screen_t)malloc(sizeof(struct screen));
            screenlist[numscr - 1]->name = NULL;
        } else if(i < numscr) {
            for(j = numscr; j > i; j--) {
                free(screenlist[j - 1]->name);
                free(screenlist[j - 1]);
            }
            numscr = i;
            screenlist = (screen_t *)realloc(screenlist, numscr * sizeof(screen_t));
            break;
        } else {
            break;
        }
    }
	if(reply->screenid == 0L) currscr = 1;
    tstream_destroy(stream);
    return 0;
}

void screen_init() {
    int i;
    numscr = INITIAL_SCREENLISTSIZE;
    screenlist = malloc(numscr * sizeof(screen_t));
    currscr = -1;
    for(i = 0; i < numscr; i++) {
        screenlist[i] = malloc(sizeof(struct screen));
        screenlist[i]->name = NULL;
    }
    slistmut = CreateMutex(NULL, 0, NULL);
}

void screen_cleanup() {
    int i;
    if(sess->fmenu == 2) {
        WaitForSingleObject(sess->menuth, INFINITE);
        CloseHandle(sess->menuth);
    }
    for(i = 0; i < numscr; i++) {
        free(screenlist[i]->name);
        free(screenlist[i]);
    }
    free(screenlist);
    CloseHandle(slistmut);
}

int screen_handle(reply_t reply) {
    switch(reply->code) {
    case REP_SCREENLIST:
        WaitForSingleObject(slistmut, INFINITE);
        if(currscr != -1) {
            rcon_reqclose(screenlist[currscr]->id);
        }
        if(screen_createlist(reply)) {
            ReleaseMutex(slistmut);
            free(reply->data);
            free(reply);
            return 1;
        }
        rcon_reqopen(screenlist[currscr]->id);
        ReleaseMutex(slistmut);
        break;
    case REP_SCREEN_DESTROYED:
        WaitForSingleObject(slistmut, INFINITE);
        currscr = -1;
        ReleaseMutex(slistmut);
        break;
    case REP_SCREEN_LOCKED:
        break;
    case REP_SCREEN_UNLOCKED:
        break;
    case REP_SCREEN_COPY:
        WaitForSingleObject(slistmut, INFINITE);
        if(currscr == -1 || screenlist[currscr]->id != reply->screenid) 
		{
            currscr = screen_find(reply->screenid);
            if(currscr == -1) {
                free(reply->data);
                free(reply);
                ReleaseMutex(slistmut);
                PERR "Invalid data received");
                return 1;
            }
        }
        if(screen_setcontent(reply, 1)) {
            free(reply->data);
            free(reply);
            ReleaseMutex(slistmut);
            return 1;
        }
        ReleaseMutex(slistmut);
        break;
    case REP_SCREEN_CHANGE:
        WaitForSingleObject(slistmut, INFINITE);
        if(currscr != -1 && screenlist[currscr]->id == reply->screenid) {
            if(screen_setcontent(reply, 0)) {
                free(reply->data);
                free(reply);
                ReleaseMutex(slistmut);
                return 1;
            }
        }
        ReleaseMutex(slistmut);
        break;
    }
    free(reply->data);
    free(reply);
    return 0;
}

void screen_handlecon() {
    INPUT_RECORD ir;
    DWORD temp;
    WORD l;
    short i;
    ReadConsoleInput(hconin, &ir, 1, &temp);
    if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown) {
        for(l = 0; l < ir.Event.KeyEvent.wRepeatCount; l++) {
            i = screen_keymap(ir.Event.KeyEvent);
            if(!i)
                i = screen_charmap(ir.Event.KeyEvent.uChar.AsciiChar);
            if(i && currscr != -1 && i != 255)
                rcon_reqinput(screenlist[currscr]->id, i);
        }
    }
}

void screen_clear(WORD attrib) {
    COORD c;
    DWORD temp;
	CONSOLE_CURSOR_INFO cinfo;
    c.X = 0;
    c.Y = 0;
    FillConsoleOutputCharacter(hconout, ' ', 2000, c, &temp);
    FillConsoleOutputAttribute(hconout, attrib, 2000, c, &temp);
	GetConsoleCursorInfo(hconout,&cinfo);
	cinfo.bVisible=FALSE;
	SetConsoleCursorInfo(hconout,&cinfo);
}
