/* slist.c
 * Server list routines
 * 
 * Copyright (C) 2002-2003 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: slist.c 1.11 Fri, 30 Aug 2002 20:13:05 -0400 pahan $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include<winsock2.h>
#include<windows.h>
#include<process.h>
#include<stdlib.h>
#include<ctype.h>
#include<dict.h>
#include"rcon.h"

// debug macros
//#define SLIST_FILE

/* $Format: "static char* version = \"$ProjectVersion$\";"$ */
static char* version = "VeRsIoN=2.5";
static char* copyright = "CoPyRiGhT=Copyright (C) 2002-2005 Paul Pergamenshchik";
// static strings
static const char sGet[] = "Getting server list, press Escape to stop...";

// module globals
HANDLE hretr;
HANDLE lookup;
dict *servers;
int fabort;
char **svr;
int dictind;

int slist_iter(const void *a, void *b) {
    svr[dictind++] = (char *)a;
    return 1;
}

void slist_free_item(void *a) {
    slist_entry_t entry = (slist_entry_t)a;
    free(entry->ipaddr);
    free(entry);
}

#ifdef SLIST_FILE
unsigned __stdcall slist_retrth(void *arg) {
    FILE *f;
    char str[4096];
    char *nind, *name, *t;
    unsigned int i;
    slist_entry_t entry;
    f = fopen("g:\\rconsolej\\rconip\\lines.dat", "r");
    SetEvent(arg);
    fgets(str, 4095, f);
    while(!feof(f)) {
        if(fabort) {
            break;
        }
        str[strlen(str) - 1] = '\0';
        nind = strrchr(str, ';');
        name = malloc(strlen(nind));
        strcpy(name, nind + 1);
        // grope name to something edible
        if(strcmp(name, "255.255.255.255")) { // not already INADDR_BROADCAST
            if(inet_addr(name) == INADDR_NONE) { // cut domain part
                t = strchr(name, '.');
                if(t) {
                    t[0] = '\0';
                }
            }
        }
        for(i = 0; i < strlen(name); i++)
            name[i] = toupper(name[i]);
        nind[0] = '\0';
        nind = strrchr(str, ':');
        entry = malloc(sizeof(struct slist_entry));
        entry->name = name;
        entry->port = atoi(nind + 1);
        nind[0] = '\0';
        nind = strrchr(str, '/');
        entry->ipaddr = malloc(strlen(nind));
        strcpy(entry->ipaddr, nind + 1);
        dict_insert(servers, name, entry, 1);
        fgets(str, 4095, f);
    }
    fclose(f);
    return 0;
}

#else // SLIST_FILE

unsigned __stdcall slist_retrth(void *arg) {
    GUID rcon_guid = { 0x38bdc991, 0xbedf, 0x4bd9, { 0x90, 0x1b, 0xe2, 0x35, 0x6d, 0x50, 0xaa, 0x84 } };
    WSANSCLASSINFO rconservers[1];
    WSASERVICECLASSINFO rconserverinfo = {&rcon_guid, "rconinfo", 1, rconservers};
    WSAQUERYSET queryBuffer;
    LPWSAQUERYSET lpResults = NULL;
    u_long iResultsLength = DEFAULT_RESULT_LEN;
    unsigned int rcode, i;
    char *name, *nind, *t;
    slist_entry_t entry;

    
    SetEvent(arg);
	rconservers[0].lpszName    = "rconsole";
	rconservers[0].dwNameSpace = NS_SLP;
	rconservers[0].dwValueType = REG_SZ;

	if (useSSL)
	{
		rconservers[0].dwValueSize = 22;
		rconservers[0].lpValue     = "securerconsole.novell";
	}
	else
	{
		rconservers[0].dwValueSize = 16;
		rconservers[0].lpValue     = "rconsole.novell";
	}

    rcode = WSAInstallServiceClass(&rconserverinfo);
    if(rcode) {
//		PERR "Error: %d with call WSAInstallServiceClass", WSAGetLastError());
        return 1;
    }
    
    memset((char *)&queryBuffer, 0, sizeof(WSAQUERYSET));
    queryBuffer.dwSize = sizeof(WSAQUERYSET);
    queryBuffer.lpszServiceInstanceName = NULL;
    queryBuffer.lpServiceClassId = &rcon_guid;
    queryBuffer.lpVersion = NULL;
    queryBuffer.lpszComment = NULL;
    queryBuffer.dwNameSpace = NS_SLP;
    queryBuffer.lpNSProviderId = NULL;
    queryBuffer.lpszContext = NULL;
    queryBuffer.dwNumberOfProtocols = 0;
    queryBuffer.lpafpProtocols = NULL;
    queryBuffer.lpszQueryString = NULL;
    queryBuffer.dwNumberOfCsAddrs = 0;
    queryBuffer.lpcsaBuffer = NULL;
    queryBuffer.dwOutputFlags = 0;
    queryBuffer.lpBlob = NULL;
    
    rcode = WSALookupServiceBegin(&queryBuffer, LUP_RETURN_ALL, &lookup);
    if(rcode) {
//		WSARemoveServiceClass(&rcon_guid);
//		PERR "Error: %d with call WSALookupServiceBegin", WSAGetLastError());
        return 1;
    }

    do {
        free(lpResults);
        lpResults = NULL;
        lpResults = malloc(iResultsLength);

        if(fabort) {
            break;
        }

        rcode = WSALookupServiceNext(lookup, 0, &iResultsLength, lpResults);
        if(SOCKET_ERROR == rcode) {
            switch(WSAGetLastError())
            {
            case WSAEFAULT:
                rcode = 0;
                break;
            case WSAENOMORE:
            case WSA_E_NO_MORE:
            case WSAECANCELLED:
            case WSA_E_CANCELLED:
                break;
            default:
//              PERR "\r\nError: %d with WSALookupServiceNext\r\n", WSAGetLastError());
                break;
            }
        } else {
            nind = strrchr(lpResults->lpszQueryString, ';');
	    if (nind != NULL)
	    {
                name = malloc(strlen(nind));
                strcpy(name, nind + 1);
	    }
	    else
	    {
            	nind = strrchr(lpResults->lpszQueryString, '/');
                if (nind != NULL)
                {
                    name = malloc(strlen(nind));
                    strcpy(name, nind + 1);
                }
		else break;
            }
            // grope name to something edible
            if(strcmp(name, "255.255.255.255")) { // not already INADDR_BROADCAST
                if(inet_addr(name) == INADDR_NONE) { // cut domain part
                    t = strchr(name, '.');
                    if(t) {
                        t[0] = '\0';
                    }
                }
            }
            for(i = 0; i < strlen(name); i++)
                name[i] = toupper(name[i]);
            nind[0] = '\0';

            entry = malloc(sizeof(struct slist_entry));
            entry->name = name;

            nind = strrchr(lpResults->lpszQueryString, ':');
            if (nind != NULL)
            {
                entry->port = atoi(nind + 1);
                nind[0] = '\0';
                nind = strrchr(lpResults->lpszQueryString, '/');
                if (nind != NULL)
                {
                    entry->ipaddr = malloc(strlen(nind));
                    strcpy(entry->ipaddr, nind + 1);
                }
            }
            dict_insert(servers, name, entry, 1);
        }
    } while(!rcode);
    WSALookupServiceEnd(lookup);
//    WSARemoveServiceClass(&rcon_guid);  //Enabled causes slow slp discovery
    free(lpResults);
    return 0;
}
#endif // SLIST_FILE

void slist_drawheader() {
    DWORD temp;
    COORD c;
	char filler[80];
	unsigned int x;
    char *line = malloc(80);
    // draw top border
    line[0] = (char)201; // top left double corner
    memset(line + 1, 205, 80 - 2); // horizontal double line
    line[80 - 1] = (char)187; // top right double corner
    c.X = 0;
    c.Y = 0;
    WriteConsoleOutputCharacter(hconout, line, 80, c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_BLUE | BACKGR_GREY, 80, c, &temp);
    // draw bottom border
    line[0] = (char)200; // bottom left double corner
    line[80 - 1] = (char)188; // bottom right corner
    c.Y = 2;
    WriteConsoleOutputCharacter(hconout, line, 80, c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_BLUE | BACKGR_GREY, 80, c, &temp);
    // draw version message
	for (x=0; x<(80-19-strlen(version+8)-strlen(copyright+10)-4); x++)
		filler[x]=' ';
	filler[x]='\0';
	if (useSSL)
	{
		filler[strlen(filler)-5]='\0';
		sprintf(line, "%c Remote Console IP v%s SSL %s%s", 186, version+8, filler, copyright+10); // vertical double line
	}
	else
	{
		sprintf(line, "%c Remote Console IP v%s%s%s", 186, version+8, filler, copyright+10); // vertical double line
	}
//	sprintf(line, "%c Remote IP console %s            %s", 186, version+8, copyright+10); // vertical double line
    memset(line + strlen(line), 32, 80 - strlen(line));
    line[80 - 1] = (char)186; // vertical double line
    c.Y = 1;
    WriteConsoleOutputCharacter(hconout, line, 80, c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_BLUE | BACKGR_GREY, 80, c, &temp);
    // draw license message
/*  sprintf(line, "%c GPL blah free software blah blah", 186, version); // vertical double line
    memset(line + strlen(line), 32, 80 - strlen(line));
    line[80 - 1] = (char)186; // vertical double line
    c.Y = 2;
    WriteConsoleOutputCharacter(hconout, line, 80, c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_BLUE | BACKGR_GREY, 80, c, &temp);*/
    free(line);
}

void slist_getslist() {
    int res, brk = 0;
    DWORD temp;
    HANDLE handles[2];
    COORD c;
    INPUT_RECORD ir;
    HANDLE initev;
    c.X = 20;
    c.Y = 10;
    WriteConsoleOutputCharacter(hconout, sGet, strlen(sGet), c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_GREY | BACKGR_BLUE, strlen(sGet), c, &temp);
    c.X = 0;
    c.Y = 1;
    if(servers) {
        dict_destroy(servers, 1);
    }
    servers = rb_dict_new(stricmp, free, slist_free_item);
    initev = CreateEvent(NULL, 1, 0, NULL);
    hretr = (HANDLE)_beginthreadex(NULL, 0, slist_retrth, initev, 0, (unsigned *)&temp);
    WaitForSingleObject(initev, INFINITE);
    CloseHandle(initev);
    handles[0] = hconin;
    handles[1] = hretr;
    fabort = 0;
    while(!brk) {
        res = WaitForMultipleObjects(2, handles, 0, INFINITE);
        switch(res) {
        case WAIT_OBJECT_0:
            ReadConsoleInput(hconin, &ir, 1, &temp);
            if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown && ir.Event.KeyEvent.wVirtualKeyCode == VK_ESCAPE) {
                fabort = 1;
                WaitForSingleObject(hretr, INFINITE);
                brk = 1;
            }
            break;
        case WAIT_OBJECT_0 + 1:
            brk = 1;
            break;
        }
    }
    CloseHandle(hretr);
    res = dict_count(servers);
    dictind = 0;
    if (svr!=NULL)
		free(svr);
    if (res!=0)
	{
		svr = malloc(res * sizeof(char *));
		dict_walk(servers, slist_iter);
	}
    c.X = 20;
    c.Y = 10;
    FillConsoleOutputCharacter(hconout, 32, strlen(sGet), c, &temp);
    FillConsoleOutputAttribute(hconout, FOGR_GREY | BACKGR_BLUE, strlen(sGet), c, &temp);
}

void slist_exit(void)
{
    struct menu mn;
    int brk = 0, l, res;
    INPUT_RECORD ir;
    DWORD temp;
    char *options[] = {"Yes","No"};

    mn.title = "  Exit Remote Console IP?";
    mn.cur = 0;
    mn.data = options;
    mn.len = 2;
    mn.top = 0;
    mn.x = 25;
    mn.y = 12;
    mn.xsize = 30;
    mn.ysize = 3;
    mn.comp = malloc(mn.xsize + 1);
    memset(mn.comp, 0, mn.xsize + 1);
    menu_draw(&mn);

    brk = 0;
    while(!brk) 
	{
		ReadConsoleInput(hconin, &ir, 1, &temp);
        if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown) 
		{
			for(l = 0; l < ir.Event.KeyEvent.wRepeatCount; l++) 
			{
				res = menu_handlekey(&mn, ir.Event.KeyEvent);
	            if(res == 2) 
				{ // ESC pressed
					brk = 1;
				} else if(res == 3) 
				{ // Enter pressed
					brk = 1;
					if (mn.cur == 0) { // Option = "Yes"
						programTerminate=1;
					}
				}
			}
		}
	}
}

void slist_main(char *host) {
    INPUT_RECORD ir;
    char *hst, *pwd;
    int brk, brk2;
    DWORD temp;
    int l, res;
    struct menu mn;
    screen_clear(BACKGR_BLUE);
    slist_drawheader();

    if(host!=NULL) {
        pwd = inputbox_get(" Password: ", 16, 10, MAXPWDLEN, 1);
        if(pwd) {
            rcon_session(host, pwd, 0);
        }
        return;
    }

	svr = NULL;
	mn.title = "  Available servers";
	mn.cur = 0;
	mn.top = 0;
	mn.x = 20;
	mn.y = 8;
	mn.xsize = 40;
	mn.ysize = 10;

	brk2=0;
	while (!brk2) {
	    servers = NULL;
		mn.comp = malloc(mn.xsize + 1);
		memset(mn.comp, 0, mn.xsize);
		screen_clear(BACKGR_BLUE);
		slist_drawheader();
	    slist_getslist();

		mn.data = svr;
		mn.len = dictind;

		if(mn.len == 0) {
			mn.top = mn.cur = 0;
		} else {
			if(mn.top >= mn.len) {
				mn.top = mn.len - 1;
			}
			if(mn.cur >= mn.len) {
				mn.cur = mn.len - 1;
			}
		}
		menu_draw(&mn);

		brk = 0;
		while(!brk) {
	        ReadConsoleInput(hconin, &ir, 1, &temp);
			if(ir.EventType == KEY_EVENT && ir.Event.KeyEvent.bKeyDown) {
	            for(l = 0; l < ir.Event.KeyEvent.wRepeatCount; l++) {
		            res = menu_handlekey(&mn, ir.Event.KeyEvent);
					if(res == 2) {  // Escape 
						brk = 1;
						break;
					} else if(res == 4) { // Insert
						hst = inputbox_get(" Enter hostname or IP address: ", 3, 10, 40, 0);
						screen_clear(BACKGR_BLUE);
						slist_drawheader();
						menu_draw(&mn);
						if(hst) {
							pwd = inputbox_get(" Password: ", 16, 10, MAXPWDLEN, 1);
							if(pwd) {
								if(!rcon_session(hst, pwd, 0)) {
									screen_clear(BACKGR_BLUE);
									slist_drawheader();
									menu_draw(&mn);
									mn.data = svr;
									if(mn.len == 0) {
										mn.top = mn.cur = 0;
									} else {
										if(mn.top >= mn.len) {
											mn.top = mn.len - 1;
										}
										if(mn.cur >= mn.len) {
											mn.cur = mn.len - 1;
										}
									}
								}
								free(pwd);
							}
							free(hst);
						}
						screen_clear(BACKGR_BLUE);
						slist_drawheader();
						menu_draw(&mn);
					} else if(res == 3) { // Enter
						pwd = inputbox_get(" Password: ", 16, 10, MAXPWDLEN, 1);
						if(pwd) {
							slist_entry_t sel = dict_search(servers, mn.data[mn.cur]);
							if(!rcon_session(sel->ipaddr, pwd, htons(sel->port))) {
								screen_clear(BACKGR_BLUE);
								slist_drawheader();
								menu_draw(&mn);
								mn.data = svr;
								if(mn.len == 0) {
									mn.top = mn.cur = 0;
								} else {
									if(mn.top >= mn.len) {
										mn.top = mn.len - 1;
									}
									if(mn.cur >= mn.len) {
										mn.cur = mn.len - 1;
									}
								}
							}
							free(pwd);
						}
						screen_clear(BACKGR_BLUE);
						slist_drawheader();
				        mn.comp[0] = '\0'; // Clear keyboard buffer.
						menu_draw(&mn);
					}
				}
			}
		}

		programTerminate=0;
		screen_clear(BACKGR_BLUE);
		slist_drawheader();
		slist_exit();
		if (programTerminate==1) {
			brk2=1;
		}
    }
    free(mn.comp);
    dict_destroy(servers, 1);
}
