/* tstream.c
 * nasty hack for a Java-like input stream
 * 
 * Copyright (C) 2002-2003 Paul Pergamenshchik <pp64@cornell.edu>
 *
 * $Id: tstream.c 1.6 Fri, 30 Aug 2002 20:13:05 -0400 pahan $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include<stdlib.h>
#include"rcon.h"

tstream_t tstream_init(char *buf, int len) {
    tstream_t res = malloc(sizeof(struct tstream));
    res->buf = buf;
    res->curr = 0;
    res->max = len;
    res->error = 0;
    return res;
}

void tstream_seek(tstream_t stream, int pos) {
    stream->curr = MIN(pos, stream->max);
}

int tstream_readint(tstream_t stream) {
    int res;
    if(stream->max - stream->curr < 4) {
        stream->error = 1;
//      MessageBox(NULL, "readint EOF", "tstream error", 0);
        return -1;
    }
    res =   ((unsigned char)(stream->buf[stream->curr]) << 24) + ((unsigned char)(stream->buf[stream->curr + 1]) << 16) +
            ((unsigned char)(stream->buf[stream->curr + 2]) << 8) + (unsigned char)(stream->buf[stream->curr + 3]);
    stream->curr += 4;
    return res;
}

char tstream_readbyte(tstream_t stream) {
    if(stream->max == stream->curr) {
        stream->error = 1;
//      MessageBox(NULL, "readbyte EOF", "tstream error", 0);
        return -1;
    }
    return stream->buf[stream->curr++];
}

char *tstream_readstr(tstream_t stream) {
    int n = stream->curr;
    char *newstr = NULL;
    if(stream->max == stream->curr) {
        stream->error = 1;
//      MessageBox(NULL, "readstr EOF", "tstream error", 0);
        return NULL;
    }
    while(n < stream->max && stream->buf[n] != '\0')
        n++;
    newstr = malloc(n - stream->curr + 1);
    strncpy((char *)newstr, (char *)(stream->buf + stream->curr), n - stream->curr);
    newstr[n - stream->curr] = '\0';
    stream->curr = n;
    if(n < stream->max && stream->buf[n] == '\0') {
        stream->curr++;
    }
    return newstr;
}

void tstream_destroy(tstream_t stream) {
    free(stream);
}
