#include "d:\bc4\include\nwcaldef.h" //NWCallsInit, NWGetDefaultConnectionID, NWGetConnectionNumber, NWGetConnectionInformation
#include "d:\bc4\include\nwserver.h" //NWGetFileServerVersionInfo
#include "d:\bc4\include\nwmisc.h"
#include "d:\bc4\include\nwconnec.h"
#include "d:\bc4\include\nwfse.h"
#include "d:\bc4\include\nwvol.h"
#include "d:\bc4\include\nwalias.h"
// #include "d:\cstuff\projects\nwcalls.c"

#include <dos.h>
#include <stdio.h>

#ifndef FAR
  #define FAR far
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif

typedef struct
  { char volname[16];
	NWVOL_NUM volNumber;
	DWORD totalBlocks;
	DWORD sectorsPerBlock;
	DWORD availableBlocks;
	DWORD totalDirEntries;
	DWORD availableDirEntries;
  } volstruct;

void nwcalls(void);
void nwgetvolumeinfo(void);
void printinfo(void);
void getvolumeinfo(void);
void readinfo(void);

  WORD appNum;
  NWCONN_HANDLE connHandle;
  VERSION_INFO fsinfo;

  DWORD serialNum, startNum=0;
//  NWLAN_CONFIG lanConfig;
//  DWORD lanBoardNumber =0;
  NWFSE_SERVER_SET_CATEGORIES setinfo;
  volstruct volinfo[64];
  char server[48];
  VOL_STATS volumeinfo;
  int volcounter = 0;

void main(int argc, char *argv[])
{
  clrscr();
  if (argc == 2)
  {  printf("\n\nFILE: FSINFO.EXE");
	 printf("\n\nSyntax: fsinfo");
	 printf("\n\nSummary: Collect information on a file server.");
	 printf("\nThe F: drive must be mapped to the root of SYS: in order for it to work.");
	 printf("\nIf this drive is not mapped, the autoexec.ncf and system login script are");
	 printf("\nnot appended to the output file.");
	 exit(1);
  }
  printf("\nPlease wait. . .Checking Network Info. . .");
  nwcalls();
  printinfo();
  getvolumeinfo();
  readinfo();
} //main

void printinfo()
{ int loop=0;
  FILE *out;
  struct date d;
  struct time t;

  gettime(&t);
  getdate(&d);
  if ((out = fopen("FSINFO.OUT", "wt")) == NULL)
	fprintf(stderr, "Cannot open FSINFO.OUT\n");

  fprintf(out,"\nFile Server Infomation Output File");
  fprintf(out,"\nInformation Collected on: %02d/%02d/%d at %02d:%02d:%02d\n",d.da_mon,d.da_day,d.da_year,t.ti_hour,t.ti_min,t.ti_sec);
  fprintf(out,"\nServer Name:  %s",server);
  fprintf(out,"\nNetWare Ver:  %d.%d",fsinfo.fileServiceVersion,fsinfo.fileServiceSubVersion);
  fprintf(out,"\nMaximum Conn: %d",fsinfo.maximumServiceConnections);
  fprintf(out,"\nSerial Num:   %lx",serialNum);
  fprintf(out,"\nApp Number:   %04x",appNum);
  fprintf(out,"\nRev. level:   %d",fsinfo.revision);
  fprintf(out,"\nSFT Level:    %d",fsinfo.SFTLevel);
  fprintf(out,"\nTTS Level:    %d",fsinfo.TTSLevel);
  fprintf(out,"\nRestriction:  %d",fsinfo.restrictionLevel);
  fprintf(out,"\nMax Volumes:  %d",fsinfo.maxNumberVolumes);
  fprintf(out,"\n");
  fclose(out);
} //printinfo

void getvolumeinfo()
{ WORD nwrc;
  char volName[16], teststring[50], *sys_errlist[80], achar;
  int loop=0, errno=0;
  FILE *in;
  char volumespace[12],filespace[12],remainingspace[12];

  for (loop=0;loop<=fsinfo.maxNumberVolumes;loop++)
  {  nwrc =  NWGetVolumeName(connHandle, loop, (char NWFAR *)&volName);
	 if ((nwrc != 0x89FF) && (strlen(volName) > 0))
	 {  strcpy(volinfo[loop].volname,volName);
		NWGetVolumeNumber(connHandle, volName, (NWVOL_NUM NWFAR *)&volinfo[loop].volNumber);
		volcounter++;
	 } // if
  } // for
  for (loop=0;loop<volcounter-1;loop++)
  {  strcpy(teststring,"chkvol ");
	 strncat(teststring,volinfo[loop].volname,strlen(volinfo[loop].volname));
	 strncat(teststring," >> fsinfo.out",16);
	 if ((system(teststring)) != 0)
	 {  printf("\n");
		perror(sys_errlist[errno]);
		printf("\n");
	 }
  } // for
} //getvolumeinfo

void readinfo()
{
  FILE *in, *out;

  if ((in = fopen("F:\\SYSTEM\\AUTOEXEC.NCF", "rt")) == NULL)
	printf(stderr, "Cannot open F:\\SYSTEM\\AUTOEXEC.NCF.\n");
  else
  {  if ((out = fopen("FSINFO.OUT", "a+"))	== NULL)
	   printf(stderr, "Cannot open output file.\n");
	 fprintf(out,"\n********** START AUTOEXEC.NCF **********\n");
	 while (!feof(in))
	   fputc(fgetc(in), out);
	 fclose(in);
	 fprintf(out,"\n********** END AUTOEXEC.NCF **********\n");
	 fclose(out);
  }
  if ((in = fopen("F:\\PUBLIC\\NET$LOG.DAT", "rt")) == NULL)
	printf(stderr, "Cannot open F:\\PUBLIC\\NET$LOG.DAT.\n");
  else
  { if ((out = fopen("FSINFO.OUT", "a+")) == NULL)
	  printf(stderr, "Cannot open output file.\n");
	fprintf(out,"\n********** START SYSTEM LOGIN SCRIPT **********\n");
	while (!feof(in))
	  fputc(fgetc(in), out);
	fclose(in);
	fprintf(out,"\n********** END SYSTEM LOGIN SCRIPT **********\n");
	fclose(out);
  }
} //read info


void nwcalls()
{ WORD nwrc;

  nwrc = (NWCallsInit(NULL, NULL));
  if (nwrc != 0x0000)
  {  printf("\nNWCallsInit failed: %04x",nwrc);
	 exit(1);
  }

  nwrc = (NWGetDefaultConnectionID(&connHandle));
  if (nwrc != 0x0000)
  {  printf("\nNWGetDefaultConnectionID failed: %04x",nwrc);
	 exit(1);
  }

  nwrc = (NWGetFileServerVersionInfo(connHandle, (VERSION_INFO FAR *)&fsinfo));
  if (nwrc != 0x0000)
  {  printf("\nNWGetFileServerVersionInfo failed: %x",nwrc);
	 exit(1);
  }
  strcpy(server,fsinfo.serverName);

  nwrc = (NWGetNetworkSerialNumber(connHandle, (DWORD NWFAR *)&serialNum, (WORD NWFAR *)&appNum));
  if (nwrc != 0x0000)
  {  printf("\nNWGetNetworkSerialNumber failed: %04x",nwrc);
	 exit(1);
  }
} //nwcalls


/* nwrc = (NWGetActiveLANBoardList (connHandle, (DWORD) startNum, (NWFSE_ACTIVE_LAN_BOARD_LIST NWFAR *)&NICList));
  nwrc = (NWGetFSLANDriverConfigInfo(connHandle, (DWORD) lanBoardNumber, (NWLAN_CONFIG NWFAR *)&lanConfig));
  if (nwrc != 0x0000)
  {
	printf("\nNWGetActiveLANBoardList failed: %04x",nwrc);
	printf("\nNWGetFSLANDriverConfigInfo failed: %04x",nwrc);
	printf("\n%d\t%d",startNum,FSE_MAX_NUM_OF_LANS);
	exit(1);
  }
*/

/*  nwrc = (NWGetServerSetCategories(connHandle, (DWORD) startNum, (NWFSE_SERVER_SET_CATEGORIES NWFAR *)&setinfo));
  if (nwrc != 0x0000)
  {  printf("\nNWGetServerSetCategories failed: %04x",nwrc);
	 printf("\n%d",setinfo.nextSequenceNumber);
	 startNum);
	 exit(1);
  }
*/

/*  printf("\nstartNum is %x",startNum);
  nwrc = NWGetMediaMgrObjList(connHandle, (DWORD) startNum, (DWORD) FSE_VOLUME_OBJECT, (NWFSE_MEDIA_MGR_OBJ_LIST NWFAR *)&objList);
  if (nwrc != 0x0000)
  {  printf("\nNWGetMediaMgrObjList failed: %04x",nwrc);
	 printf("\nstartNum is %d",startNum);
	 exit(1);
  }
  printf("YES");getch();
*/

/*  for (loop=0;loop<volcounter-1;loop++)
  {  nwrc = NWGetVolumeInfoWithNumber(connHandle,volinfo[loop].volNumber,NULL,
  (DWORD NWFAR *)&volinfo[loop].totalBlocks,(DWORD NWFAR *)&volinfo[loop].sectorsPerBlock,(DWORD NWFAR *)&volinfo[loop].availableBlocks,(DWORD NWFAR *)&volinfo[loop].totalDirEntries,(DWORD NWFAR *)&volinfo[loop].availableDirEntries, NULL);
	 printf("\n%d %s:",volinfo[loop].volNumber,volinfo[loop].volname);
	 printf("\n%lu\t%lu\t%lu\t%lu\t%lu",volinfo[loop].totalBlocks,
	 volinfo[loop].sectorsPerBlock,volinfo[loop].availableBlocks,
	 volinfo[loop].totalDirEntries,volinfo[loop].availableDirEntries);
  }
*/

/*  nwrc = NWGetVolumeStats(connHandle, 0, (VOL_STATS NWFAR *)&volumeInfo);
  if (nwrc != 0x0000)
  {  printf("\nNWGetVolumeStats failed: %04x",nwrc);
	 exit(1);
  }
  printf("\nit worked");getch();
*/