NETMAP

NAAM
        NETMAP - display a floor-plan of a Novell-
                 network

SYNOPSIS
        NETMAP [/?|/H|/N]
        

BESCHRIJVING
        NETMAP displays the ground-plan of a network running 
        Novell's Advanced Netware version 2.0A and up. 

        On this ground-plan, which can be made with a 
        normal text-editor (PC-Write, WP), all connections 
        with the current fileserver are displayed.
        
        Installation

        Invoking NETPAK.EXE will result in the next files:
        
        NETMAP.EXE  - the program itself
        NETMAP.DEF  - ASCII-file with workstation-data
        NETMAP.PWC  - non-ASCII file for color-settings
                      (set for MONOCHROME operation,
                      see also REMARKS (COLOR.PWC))
        NETMAP.PWD  - ASCII file with monitor-type settings
        NETMAP.MAN  - NETMAP's manual-pages
        NETMAP.HIS  - NETMAP's history file 
        NETMAP.Mxx  - file with floor-plan of floor number
                      xx (x from 0..9)

        To use NETMAP it will be necessary to adapt
        NETMAP.Mxx and NETMAP.DEF to the local situation. 
        This can be done with a text-editor, preferably one 
        with facilities for column-operations and inserting 
        non-ASCII characters, such as PC-Write or 
        WordPerfect. 

        NETMAP.Mxx:
        First you have to make up the necessary ground-plans 
        in these files, in a way similar to the example 
        floor-plans of the Artefact-building. Keep in mind 
        that every network-object (workstation, server, 
        printer) will occupy a field of 2 x 8 characters on 
        the floor-plan: 

        ........ 
        ........ 


        NETMAP.DEF:
        Next to the floor-plans in the NETMAP.Mxx files the 
        workstation-definition-file has to be filled in. 
        NETMAP.DEF contains all network-objects to be 
        displayed and the floor-level NETMAP will display 
        first. Each workstation will need the next data 
        successively: 
        
        object type - physical address - floor-number - column - row - any comments

        e.g.:
        STATION           80                  0           40      2     # Sales dept.: Bas

        The values of columns and rows have to correspond 
        with the position in the floor-plan file of the 
        upper-left corner of the 2 x 8 field in which the 
        object is displayed. (The upper-left corner of the 
        floor-plan itself corresponds to row 0, column 0) 
        
        To travel through the floor-plan the <TAB>-key is 
        used. Network-objects are visited in ascending row-
        order, so it is best to sort the NETMAP.DEF in 
        row-order first. (Within a row on column-order)

        When NETMAP.DEF and the NETMAP.Mxx files have been
        edited all NETMAP.* should be copied to a directory, 
        such as SYS:\PUBLIC. If your search-path has been 
        made to point to this directory, you can start 
        NETMAP from any directory on the network.
        
        Invoking NETMAP

        NETMAP /? 
        NETMAP /H
            displays a short explanation of the available 
            options

        NETMAP /N
            will start NETMAP without its first screen


        Use of NETMAP

        After invoking NETMAP you will find yourself at the 
        upper-left of the floor-plan of the floor-level 
        specified in NETMAP.DEF. 
        Connections are displayed with the current user's 
        name and the logical stationnumber. 
        
        Important keys:

        <Tab>           go to the next connection
        <Shift-Tab>     go to the preceding connection
        <PgUp>          go up one floor
        <PgDn>          go down one floor
        <F1>            display a short HELP-page
        <Shift-F1>      show the color-setting menus
        <Ctrl-F1>       DOS-exit (starting COMMAND.COM and
                        keeping NETMAP memory-resident)
                        EXIT to return to NETMAP
        <Esc>           leave the window
        <F10>           leave NETMAP
        <Return>        show information on the selected 
                        connection
        

REMARKS
        To use NETMAP with color-monitors the file 
        COLOR.PWC is added.
        To activate the settings in this file it has to be 
        renamed:
        REN NETMAP.PWC MONO.PWC
        REN COLOR.PWC NETMAP.PWC 

        Changing colors on a monochrome screen will result 
        in strange settings for a color-monitor.
        
        Further information: Bas G.J. van den Berg 
        Artefact 
        Nassaulaan 2A 
        2628 GH  DELFT 
        THE NETHERLANDS
        TEL  +31 15 621246 
        FAX  +31 15 618202
        BBS  +31 15 620790 



