NETMAP V1.4


NAME
        NETMAP - display a floor plan of a Novell-network


SYNOPSIS
        NETMAP [/?|/H|/N]

        
DESCRIPTION
        NETMAP displays the ground-plan of a network running Novell's 
        Advanced Netware version 2.0A and up. NETMAP will display the 
        location of connected workstations, as well as their current 
        status and user. 
        
        On this ground-plan, which can be made with a normal text-editor 
        (PC-Write, WP), all connections with the current fileserver are 
        displayed. 
        
    
        INSTALLING NETMAP

        To install NETMAP V1.4 you should create a directory to hold the 
        contents of NM14.ZIP. PKZIP V1.x can be used to extract the next 
        files: 

        >PKZIP -X NM14

        NETMAP.EXE  - the program itself
        NETMAP.MAN  - NETMAP's manual-pages (this file)
        NETMAP.PWH  - NETMAP's help-file 
        NETMAP.HIS  - NETMAP's history file 
        NETMAP.M00  - file with example floor plan of the ground level 
                      floor of Artefact's office
        NETMAP.M01  - file with example floor plan of the first floor 
                      of Artefact's office
        NETMAP.M09  - file with example floor plan of the ninth floor 
                      at the dept. of Computer Architecture and Digital 
                      Technique in the building for Electrical 
                      Engineering of the Delft University of Technology
        NETMAP.DEF  - ASCII-file with example workstation-data for 
                      Artefact's Novell LAN 
        NMEL.DEF    - ASCII-file with example workstation-data for 
                      Computer Architecture's LAN
        
        To use NETMAP it will be necessary to adapt NETMAP.Mxx and 
        NETMAP.DEF to the local situation. This can be done with a text-
        editor, preferably one with facilities for column-operations and 
        inserting non-ASCII characters, such as PC-Write or WordPerfect. 

        NETMAP.Mxx:
        First you will have to make up the necessary ground-plans in 
        these files, in a way similar to the example floor plans. 
        Keep in mind that every network-object (workstation, server, 
        printer) will occupy a field of 8 characters on the floor plan: 
        ........ 
    
        NETMAP.DEF:
        Next to the floor plans in the NETMAP.Mxx files the workstation-
        definition-file has to be filled in. NETMAP.DEF contains all 
        network-objects to be displayed and the floor NETMAP will display 
        first. Each workstation will need the next data:
        
        object type - physical address - floor-number - column - row - any comments

        e.g.:
        STATION           80                  0           40      2     # Sales dept.: Bas

        The values of columns and rows have to correspond with the 
        position in the floor plan file of the upper-left corner of the 8 
        characters field in which the object is displayed. (The upper-
        left corner of the floor plan itself corresponds to row 0, column 0) 

        As shown in NETMAP.M09 the keyword OFFSET may be used to specify 
        a workstation's position relative e.g. to the top left corner of 
        a room. 

        To travel through the floor plan the <TAB>-key is used. Network-
        objects are visited in ascending row-order, so it is best to sort 
        the NETMAP.DEF in row-order first. (Within a row on column-order)
        
        When NETMAP.DEF and the NETMAP.Mxx files have been edited all 
        NETMAP.* should be copied to a directory, such as SYS:\PUBLIC. 
        If your search-path has been made to point to this directory, 
        you can start NETMAP from any directory on the network. 
        
        
        INVOKING NETMAP

        NETMAP /? 
        NETMAP /H
            displays a short explanation of the available 
            options

        NETMAP /N
            will start NETMAP without its first screen


        USE OF NETMAP

        After invoking NETMAP you will find yourself at the upper-left of 
        the floor plan of the floor-level specified in NETMAP.DEF. 
        Connections are displayed with the current user's name and the 
        logical stationnumber. 
        
        Important keys, more or less conforming to the SAA 'standard': 
    
        General keys

        <F1>                   Window sensitive help
        <F3>|<Esc>             Exit window
        <Shift-F3>             Exit NETMAP
        <Ctrl-F3>              DOS shell 
        <F9>                   Detailed key help
        <Ctrl-F10>             Start defining a macro 
        <Shift-F10>            Call a macro
        <Enter>                Activate selection
        
        Movement keys

        <Cursor>               Move the floor plan 
        <Tab>                  Go to next connection
        <Shift-Tab>            Go to preceding connection
        <Character>            Go to specified login name
        <F7>|<PgUp>            Go up one floor
        <F8>|<PgDn>            Go down one floor
        <Shift-F4>             Move window

        Input keys                   

        <Cursor>               Move cursor       
        <Ctrl-Left>            Move one word left 
        <Ctrl-Right>           Move one word rights
        <Ctrl-End>             Delete from cursor to end     
        <Ctrl-Home>            Delete all input
        <Ins>                  Insert/Overwrite toggle 
        <Del>                  Delete character at cursor  
        <Backspace>            Delete before cursor   
        <Esc>|<F3>             Cancel
        <Enter>                Accept input
                                       
        Mouse events                 

        Movement               <Cursor>
        Left button            <Enter>
        Right button           <Esc> 


REMARKS
        NETMAP V1.4 has some restrictions:

        The maximum number of workstations is 100
        The maximum width of floor plans is 500 columns
        The maximum height of floor plans is 120 rows

        On Hercules or Monochrome adapters you can experiment with 
        the options /mono and /mda to find the best way for displaying 
        the floor plan.

        NETMAP /? for all available command-line options.
    

SEE ALSO 
        ARTEFACT's products in a nutshell:

        
        SOFTWARE 

        NetMonitor   - to communicate with, observe and use stations
        MultiMon     - to observe and use one or more stations
        NetTalk      - to communicate with others 
        NetGuard     - protect stations and local drives 
        NetBatch     - distributed processing of jobs 
        NetUtilities - management tool set
        NetCure      - ETHERNET monitor/analyser with very flexible 
                       filtering
        NeatPlus     - to completely utilize the 1 MB DOS memory map in 
                       computers equipped with the NEAT (tm) CHIPset
                       (e.g. to load shells and drivers above 640 KB)

        
        GROUPWARE based on the RAP (Remote APplication) concept: 
        (available as VAP or on a dedicated station)

        NETTI        - NETwork Telephone Information system
        AGNES        - Agenda Network System

        
        HARDWARE (incl.software)

        RamRom XT/AT and RamPlus MCA to completely utilize the 1 MB DOS 
        memory map in any XT/AT or PS/2 (like NeatPlus) 


        You can find more product information, plus a public domain
        lister/editor in SHOW.ZIP on Netwire. USERLIST.ZIP contains a 
        public domain Artefact VAP, to list connections on the fileserver 
        console. 

        For any remarks, suggestions and additional information on Novell 
        products from Artefact, please contact:   

        Henk van Doorn 
        Bas van den Berg

        Artefact 
        Nassaulaan 2A 
        2628 GH  DELFT 
        The Netherlands

        Compuserve ID: 72571,73
        TEL  +31 15 617532 
        FAX  +31 15 618202
        BBS  +31 15 620790 
        
