#!/usr/bin/perl

# DiskSpace Report - A utility to utilize disk space checks from mrtgext.nlm and report on a single page the status of all servers
# Written by Jim Shank 5/27/03

use CGI qw/:standard :html3/;
use CGI::Carp qw(fatalsToBrowser);
use Socket;
use locale;
use Time::HiRes qw(gettimeofday); # This is for our timing functions to see how long this takes

# -------------------------Initialize our variables-----------------------------
my $query = new CGI;
$pathtomrtg = "/var/www/html/mrtg";
$totalquerytime = 0;
# Here is the list of servers to report on. Note that your resolv config file must include the proper domain suffix
# search to resolve these hosts. You can put the FQDN here but it is unlikely that the links to MRTG will work for
# historical data.
my @serverlist = (	'SERVER1',
					'SERVER2',
					'SERVER3',
					'SERVER4',
					);
# ----------------------END Initialize our variables END--------------------------

# -----Begin Main code-----
&HTMLStart();
&HTMLOutput(MakeTable(@serverlist));
&HTMLEnd();
# -----End Main code-----

sub MakeTable
{
	my @serverlist = @_;
	my @headings = ('','Volume','Total','Used','% Used','Free','% Free');
	my @rows = th(\@headings); #Start off the @rows array with the table headings
	my $row;
	foreach $server (@serverlist) { # Begin looping through our servers
		foreach $vol (MRTGQuery($server,"volumes")) { #This gets a list of volumes on the server and then loops through them
			my($hostname,$volume,$used,$usedper,$free,$freeper,$total) = DiskQuery($server,$vol); #This retrieves the individual statistics regarding each volume
			my $lchostname = lc($hostname); # We lowercase the hostname and volume so we can link to them in our mrtg directory for historical information
			my $lcvolume = lc($volume);
			if ($usedper gt 85) { # Color code the row red (pink is easier to read) if the used percentage is greater than 85%
				if (-f "$pathtomrtg/$lchostname.$lcvolume.html") { # Checks to make sure there is an actual mrtg report on this volume before linking it
					$row = th($hostname).td({-bgcolor=>'PINK'},["<A HREF=http://lix001mon/mrtg/$lchostname.$lcvolume.html>$volume</A>"]).td({-bgcolor=>'PINK',-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
				else { # If there is no report, we don't link to the page, just color code the row.
					$row = th($hostname).td({-bgcolor=>'PINK'},[$volume]).td({-bgcolor=>'PINK',-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
			}	
			elsif ($usedper gt 80) { # Color code the row yellow is the used percentage is greater than 80%
				if (-f "$pathtomrtg/$lchostname.$lcvolume.html") { # Same Link logic as above
					$row = th($hostname).td({-bgcolor=>'YELLOW'},["<A HREF=http://lix001mon/mrtg/$lchostname.$lcvolume.html>$volume</A>"]).td({-bgcolor=>'YELLOW',-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
				else { # Same Link logic as above
					$row = th($hostname).td({-bgcolor=>'YELLOW'},[$volume]).td({-bgcolor=>'YELLOW',-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
			}
			else 
			{
				if (-f "$pathtomrtg/$lchostname.$lcvolume.html") { # Same Link logic as above
					$row = th($hostname).td({-bgcolor=>'LTGREEN'},["<A HREF=http://lix001mon/mrtg/$lchostname.$lcvolume.html>$volume</A>"]).td({-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
				else { # Same Link logic as above
					$row = th($hostname).td({-bgcolor=>'LTGREEN'},[$volume]).td({-align=>'right'},[commify($total)." KB",commify($used)." KB",$usedper."%",commify($free)." KB",$freeper."%"]);
				}
			}
			push (@rows,$row); # This is so we could break up and build the row in separate statements in case we wanted to do additional logic before pushing it into the array.
		}
	}
	return @rows;
}

sub DiskQuery 
# This query polls the MRTGEXT.NLM on the remote host (through MRTGQuery sub) 
# and gets used and total space, from this we calculate free space and used 
# and free percentages and return it.
{
	my ($hostname, $volume) = @_;
	my ($total,$used) = &MRTGQuery($hostname,"VMS".$volume." VMU".$volume);
	my $free = $total - $used;
	my $freeper_l = $free / $total * 100;
	my $freeper = sprintf("%.2f",$freeper_l);
	my $usedper_l = $used / $total * 100;
	my $usedper = sprintf("%.2f",$usedper_l);
	return $hostname,$volume,$used,$usedper,$free,$freeper,$total;
}

sub HTMLStart
{
	# Here is our HTML output using the handy standard HTML output from CGI
	print $query->header(), 
	$query->start_html(-title=>'Diskspace Usage');
}

sub HTMLOutput # Draw the actual table
{
	my @rows = @_;
	print table({-border=>undef},
				caption(b('Netware Server Space Usage')),
				Tr(\@rows)
			   );
}

sub HTMLEnd # Here we print our query time and close out the HTML code
{
	$totalquerytime = $totalquerytime / 1000;
	$totalquerytime = sprintf("%.2f",$totalquerytime);
	print "Total Query Time: ${totalquerytime} sec";
	print $query->end_html();
}

sub MRTGQuery
# This code was extracted from the nwstat.pl script included with MRTG. 
# The interface clean and simple, telnet to the port and issue the command(s).
# I also included some timing code in here. I was under the assumption that the
# script delay was due to the individual queries to the server. It turns out that
# the volumes query takes a very long time to return and typically makes up 70% or
# more of the actual execution time. 
{
	my $t0 = gettimeofday;
	my ($hostname,$command) = @_;
	my $port = 9999;
	my $result;
	my @results;
	# Open a socket and get the data
	  ($sockaddr,$there,$response,$tries) = ("Snc4x8");
	# On Win95, passing a numeric IP address to inet_aton() is slow, so
	# detect this case and use a simple conversion.  
	if ($hostname =~  /^\d+\.\d+\.\d+\.\d+(.*)/ ) {
		$remote_addr = pack("C4",split /\./, $hostname);
		} else {
			$remote_addr = (gethostbyname($hostname))[4] || die (host_not_found_error ($hostname, $?));
	}
	my $sockaddr_in = 'S n a4 x8';
	$there = pack($sockaddr_in, AF_INET, $port, $remote_addr);
	$proto = (getprotobyname ('tcp'))[2];
	if (!socket(S,AF_INET,SOCK_STREAM,$proto)) { printf "-1\n-1\n\n\n"; die "$0:  Fatal Error.  $!\n"; }
	if (!connect(S,$there)) { printf "-2\n-2\n\n\n"; die "$0:  Fatal Error.  $!\n"; }
	select(S);$|=1;
	select(STDOUT);
	print S "$command\r\n"; # <---- Here is our actual query to the server
	while ($result = <S>) {
	  $result =~ s/\W//; # strip the whitespace from results
	  push (@results, $result);
	}
	close(S);
	my $t1 = gettimeofday;
	my $el = ($t1-$t0)*1000; #Gives $el in ms
	# print "Query $hostname-$command took ${el}ms<BR>"; #If you uncomment this line, you can see how much time each query took.
	$totalquerytime = $totalquerytime + $el;
	return @results;
}

sub commify { # Management likes their number formatted. Mofify for your environment or locality.
	local $_  = shift;
	1 while s/^(-?\d+)(\d{3})/$1,$2/;
	return $_;
}