#!/usr/bin/perl

# port where the MRTGEXT nlm is listening
$port = 9999;

# configuration files
$header="servstat.hdr";
$footer="servstat.ftr";
$cfg="servstat.cfg";

# colour mappings
$RED="#FF0000";
$ORANGE="#FF9900";
$YELLOW="#FFFF00";
$GREEN="#00FF00";
$BLUE="#0000FF";
$CYAN="#00FFFF";
$RETRIES=1;

# Required for perl5.
use Socket;

# List of servers to monitor
open(SERVERS,$cfg);
while (<SERVERS>) {
	chomp;
	tr/a-z/A-Z/;
	@flds=split;
        push @fserv,$flds[0];
	};
close(SERVERS);

&catfile($header);
print STDOUT "<table border=1>\n";
printf STDOUT "<td colspan=12 align=CENTER>Status as of %s</td>", scalar localtime(time);
print STDOUT "<tr><td colspan=4>&nbsp</td><td colspan=2 align=center>Load Average</td><td colspan=6>&nbsp</td></tr>\n";
print STDOUT "<tr><td>Fileserver (os version)</td>\n";
print STDOUT "<td>Connections</td>\n";
print STDOUT "<td>DS Open</td>\n";
print STDOUT "<td>Logins<br> Enabled</td>\n";
print STDOUT "<td>5 min</td>\n";
print STDOUT "<td>15 min</td><td>Uptime</td>\n";
print STDOUT "<td>DS Ver.</td>\n";
print STDOUT "<td>Open Files</td>\n";
print STDOUT "<td>Service Processes</td>\n";
print STDOUT "<td>Abends</td>\n";
print STDOUT "<td>Time In sync</td>\n";

$command = "name S19 license connect S11 S12 util5 util15 uptime S13 S18 S20 S21 S17 S22\r\n";

print "</TR>\n";	

  $sockaddr = "Snc4x8";
  $proto = (getprotobyname ('tcp'))[2];

SERVER:
foreach $nwfs (sort @fserv) {
  print STDOUT "<TR>";

#get the name -- if fail print the name in the ORANGE colour
  @ary = gethostbyname($nwfs);
  if ($#ary==-1) {
        print STDOUT "<td bgcolor=$ORANGE>$nwfs</td></tr>\n";
	next SERVER;
	};

#create a socket, die if we fail
  $there = pack($sockaddr,2,$port, (unpack("C4",$ary[4])));
  if (!socket(S,AF_INET,SOCK_STREAM,$proto)) { die "$0:  Fatal Error.  $!\n"; }

#connect, coping with failures to connect
  for ($reconnect=$RETRIES; $reconnect >0 ; $reconnect--) {
    last if (connect(S,$there));

#if mrtgext not loaded we get this error, don't retry.
    if ($! eq "Connection refused") {
       print STDOUT "<td bgcolor=$YELLOW>$nwfs</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp></td></tr>\n";
       next SERVER
    };
  print STDERR "$nwfs $!\n";

#if server is down, we get this error, don't retry.
   if ($! eq "Connection timed out") {
     printf STDOUT "<td bgcolor=$RED>$nwfs</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td><td>&nbsp</td></tr>\n";
     next SERVER
   };
  print STDERR "$nwfs $!\n";
  };

#ugh we timed out connecting
  if ($reconnect==0) {
     print STDOUT "<td bgcolor=$RED>$nwfs</td></tr>\n";
      next SERVER;
  };

#shove the command, slurp any replies, close the socket
  select(S);$|=1;select(STDOUT);
  print S $command;
  @replies=<S> ;
  close(S);

#fileservername, need not match DNS name
  $name=shift @replies;
  $osver = shift@replies;

   print STDOUT "<td bgcolor=$GREEN>\n";

 
 if ($osver == "-1")
 {
   print STDOUT "$name</td>\n";
 }
 else
 {
   print STDOUT "$name ($osver)</td>\n";
 }

# print out connection count
 $ct=shift @replies;
 $cc=shift @replies;

 if (($ct<0) || ($cc<0)) {
    print STDOUT "<td bgcolor=$CYAN>Error getting</td>";
 } else {
    if ($ct < 1) {
      $cpf=100;
    }
    else {
      $cpf=($ct-$cc)/$ct*100;
    }
    $colour=$GREEN;
    $colour=$YELLOW if ($cpf <30);
    $colour=$ORANGE if ($cpf <20);
    $colour=$RED if ($cpf<10);
    printf STDOUT "<td bgcolor=%s>%s/%s (%d %% free)</td>",
                $colour,$cc,$ct,$cpf;
 }

#print out the DS and login status
  $dso = shift @replies;
  $logen = shift @replies;

  if ($dso < 1)
  {
    if ($dso < 0)
    {
      # not supported on this version of MRTGEXT
      printf STDOUT "<td bgcolor=$ORANGE>&nbsp</td>";
    } else {
      printf STDOUT "<td bgcolor=$RED>No</td>";
    }
  } else {
    printf STDOUT "<td bgcolor=$GREEN>Yes</td>";
  }

  if ($logen < 1) 
  {
     if ($logen < 0)
     {
       # not supported on this version of MRTGEXT 
       printf STDOUT "<td bgcolor=$ORANGE>&nbsp</td>";
     } else {
       printf STDOUT "<td bgcolor=$RED>No</td>";
     }
  } else {
     printf STDOUT "<td bgcolor=$GREEN>Yes</td>";
  }
 
# print out 5 min load average
 $la=shift @replies;
 $colour=$GREEN;
 $colour=$YELLOW if ($la > 70);
 $colour=$ORANGE if ($la > 80);
 $colour=$RED if ($la > 90);
 printf STDOUT "<td bgcolor=%s>%d %%</td>",$colour,$la;

# print out 15 min load average
 $la=shift @replies;
 $colour=$GREEN;
 $colour=$YELLOW if ($la > 70);
 $colour=$ORANGE if ($la > 80);
 $colour=$RED if ($la > 90);
 printf STDOUT "<td bgcolor=%s>%d %%</td>",$colour,$la;


# put out uptime
  $up=shift @replies;
  $colour=$GREEN;
  $colour=$YELLOW if ($up < 14);
  $colour=$ORANGE if ($up < 7);
  $colour=$RED    if ($up < 1);
  printf STDOUT "<td bgcolor=%s>%s</td>",$colour,$up;

#print out the DS Version
 
 $dsv = shift @replies;
 if ($dsv eq "-1\n") 
 {
   printf STDOUT "<td bgcolor=$GREEN>&nbsp</td>";
 } else {
   printf STDOUT "<td bgcolor=$GREEN>%s</td>",$dsv;
 }

#print out the open file count
 
 $ofc = shift @replies;
 if ($ofc == "-1")
 {
   printf STDOUT "<td bgcolor=$GREEN>N/A</TD>\n";
 }
 else
 {
   printf STDOUT "<td bgcolor=$GREEN>%s</td>",$ofc;
 }

#print out the service process info
 $spmax = shift @replies;
 $spcur = shift @replies;

 if ($spcur == "-1")
 {
   printf STDOUT "<td bgcolor=$GREEN>N/A</TD>\n";
 }
 else
 {
   $cpf=($spmax-$spcur)/$spmax*100;
   $colour=$GREEN;
   $colour=$YELLOW if ($cpf <30);
   $colour=$ORANGE if ($cpf <20);
   $colour=$RED  if ($cpf < 10);
   printf STDOUT "<td bgcolor=$colour>%s/%s</td>\n",$spcur,$spmax;
 }

#print out the abended thread count
 $abends = shift @replies;
 if ($abends == "-1") 
 {
   printf STDOUT "<td bgcolor=$GREEN>N/A</td>\n";
 } else {
  if ($abends == "0") {
   printf STDOUT "<td bgcolor=$GREEN>%s</td>\n",$abends;
  } else {
   printf STDOUT "<td bgcolor=$RED>%s</td>\n",$abends;
  }
 }

#Timesync Status
 $sync = shift @replies;
 if ($sync == "-1")
 {
    printf STDOUT "<td bgcolor=$GREEN>N/A</TD>\n";
 } else {
    if ($sync == "0")
    {
       printf STDOUT "<td bgcolor=$RED>NO</TD>\n";
    } else {
       printf STDOUT "<td bgcolor=$GREEN>Yes</TD>\n";
    }
 }
 print STDOUT "</TR>\n";
};

 
print STDOUT "</table>\n";

#write the footer
&catfile($footer);
exit(0);

####subroutines.
# write the file to stdout
sub	catfile {
open(HANDLE,@_[0]) || die "@_[0]:$!\n";
while (<HANDLE>) { print; };
close(HANDLE);
}
