#!/usr/bin/perl

# port where the MRTGEXT nlm is listening
$port = 9999;

# configuration files
$header="volstat.hdr";
$footer="volstat.ftr";
$cfg="volstat.cfg";

# colour mappings
$RED="#FF0000";
$ORANGE="#FF9900";
$YELLOW="#FFFF00";
$GREEN="#00FF00";
$BLUE="#0000FF";
$CYAN="#00FFFF";
$RETRIES=1;

# Required for perl5.
use Socket;

# List of servers to monitor
open(SERVERS,$cfg);
while (<SERVERS>) {
	chomp;
	tr/a-z/A-Z/;
	@flds=split;
        push @fserv,$flds[0];
	};
close(SERVERS);

&catfile($header);
print STDOUT "<table border=1>\n";
printf STDOUT "<td colspan=5 align=CENTER>Status as of %s</td>", scalar localtime(time);
print STDOUT "<tr><th> Volume Name</th>\n";
print STDOUT "<th>Total Space</th>\n";
print STDOUT "<th>Used Space</th><th>Free Space</th><th>Percent Left</th>\n";

$command = "name volumes\r\n";

print "</TR>\n";	

  $sockaddr = "Snc4x8";
  $proto = (getprotobyname ('tcp'))[2];

SERVER:
foreach $nwfs (@fserv) {
#foreach $nwfs (sort @fserv) {
  print STDOUT "<TR>";

#get the name -- if fail print the name in the ORANGE colour
  @ary = gethostbyname($nwfs);
  if ($#ary==-1) {
        print STDOUT "<td colspan=5 bgcolor=$ORANGE><center>$nwfs</center></td></tr>\n";
	next SERVER;
	};

#create a socket, die if we fail
  $there = pack($sockaddr,2,$port, (unpack("C4",$ary[4])));
  if (!socket(S,AF_INET,SOCK_STREAM,$proto)) { die "$0:  Fatal Error.  $!\n"; }

#connect, coping with failures to connect
  for ($reconnect=$RETRIES; $reconnect >0 ; $reconnect--) {
    last if (connect(S,$there));

#if mrtgext not loaded we get this error, don't retry.
    if ($! eq "Connection refused") {
       print STDOUT "<tr><td colspan=5 bgcolor=$YELLOW><center>$nwfs</center></td><tr>\n";
       next SERVER
    };
  print STDERR "$nwfs $!\n";

#if server is down, we get this error, don't retry.
   if ($! eq "Connection timed out") {
     printf STDOUT "<tr><td colspan=5 bgcolor=$RED><center>$nwfs</center></td></tr>\n";
     next SERVER
   };
  print STDERR "$nwfs $!\n";
  };

#ugh we timed out connecting
  if ($reconnect==0) {
     print STDOUT "<tr><td colspan=5 bgcolor=$RED><center>$nwfs</center></td></tr>\n";
      next SERVER;
  };

#shove the command, slurp any replies, close the socket
  select(S);$|=1;select(STDOUT);
  print S $command;
  @replies=<S> ;
  close(S);

#fileservername, need not match DNS name
  $name=shift @replies;
  print STDOUT "<tr><td colspan=5><center>$name</center></td>\n";

# get volume list
  $req="";

  printf STDOUT "<tr>";
  while(@replies) {
    $v = shift @replies;
    $v =~ s/\n//;
    push @vols, $v;
    $req .= "vks$v vku$v ";
#    printf STDOUT "<tr><td>$v</td><td>Space Total</td><td>Space left</td><td>%</td> "; 
  };
 $req .="\r\n";


 #create a socket, die if we fail
  $there = pack($sockaddr,2,$port, (unpack("C4",$ary[4])));
  if (!socket(S,AF_INET,SOCK_STREAM,$proto)) { die "$0:  Fatal Error.  $!\n"; }

 #connect, coping with failures to connect
  for ($reconnect=$RETRIES; $reconnect >0 ; $reconnect--) {
    last if (connect(S,$there));

 #if mrtgext not loaded we get this error, don't retry.
    if ($! eq "Connection refused") {
       print STDOUT "<tr><td colspan=5 bgcolor=$YELLOW>$nwfs</td><tr>\n";
       next SERVER
    };
  print STDERR "$nwfs $!\n";

 #if server is down, we get this error, don't retry.
   if ($! eq "Connection timed out") {
     printf STDOUT "<tr><td colspan=5 bgcolor=$RED>$nwfs</td></tr>\n";
     next SERVER
   };
  print STDERR "$nwfs $!\n";
  };

 #ugh we timed out connecting
  if ($reconnect==0) {
     print STDOUT "<tr><td colspan=5 bgcolor=$RED>$nwfs</td></tr>\n";
      next SERVER;
  };

 #shove the command, slurp any replies, close the socket
  select(S);$|=1;select(STDOUT);
  print S $req;
  @rep=<S> ;
  close(S);

# print out stats...
 
  while(@vols) {
    $v = shift @vols;
    $vtot = shift @rep;
    $vused = shift @rep;
    if ($vtot == 0) {
      $vper = 0;
    } else {
      $vper = (($vtot - $vused) / $vtot) * 100;
    }
    $vleft = $vtot - $vused;
    $colour=$GREEN;
    $colour=$YELLOW if ($vper < 20);
    $colour=$ORANGE if ($vper < 10);
    $colour=$RED if ($vper < 5);
    printf STDOUT "<tr><td bgcolor=%s>%s</td><td bgcolor=%s>%s</td><td bgcolor=%s>%s</td><td bgcolor=%s>%s</td><td bgcolor=%s>%d %%</td> ",
    $colour,$v,$colour,$vtot,$colour,$vused,$colour,$vleft,$colour,$vper; 
  };
 $req .="\r\n";

};

print STDOUT "</table>\n";

#write the footer
&catfile($footer);
exit(0);

####subroutines.
# write the file to stdout
sub	catfile {
open(HANDLE,@_[0]) || die "@_[0]:$!\n";
while (<HANDLE>) { print; };
close(HANDLE);
}
