#include "space.h"

void main(int argc, char *argv[])
{  int loop, loop2, loop3, usercounter=0, numvols=0, skippause=0;
   div_t x;

  clrscr();
  initmainnwcalls();
  strcpy(searchObjectName,strupr(argv[1]));
  if (argc == 1)
	{  clrscr();
	   printf("\nSPACE: Return space in use by a user.");
	   printf("\n\nSyntax: space USERNAME [/p]");
	   printf("\nUSERNAME is a valid user on the network, otherwise NOT FOUND");
	   printf("\nis returned, along with a list of similar user names, if any.");
	   printf("\nThe /p is optional.  If used, the program will pause when there");
	   printf("\nis more than a screen full of names.  Otherwise, it doesn't pause.");
	   printf("\nSpace will return: ");
	   printf("\nServer Name, Volumes, and space used on each volume.");
	}
  else
	{  if (argc == 3)
		 if (strcmp(strupr(argv[2]),"/P") == 0)
		   skippause = 1;
	   printf("Scanning. . .");
	   numvols = getserverinfo();
	   usercounter = scanforusers();
	   for (loop=0;loop<usercounter;loop++)
		 {
		 getspaceused(userlist[loop].username,numvols,loop);
		 printf("\n%-10s",userlist[loop].username);
		 for (loop2=0;loop2<numvols;loop2++)
		   printf("\t%7lu",userlist[loop].volinfo[loop2].spaceused);
		 x = div(loop,20);
		 if (skippause == 1)
		   if ((x.rem == 0) && (loop != 0))
		   { printf("\nPress a key to the next screen. . .");
			 getch();
			 clrscr();
			 printf("Server: %s",serverName);
			 printf("\n\n  USER\t\t  ");
			 for (loop3=0;loop3<numvols;loop3++)
			   printf("%-10s",volinfo[loop3].volname);
			 printf("\n--------\t");
			 for (loop3=0;loop3<numvols;loop3++)
			   printf("-------  ");
		   }
		 } // for
//	   sortoutput(usercounter,numvols);
	   printf("\n%d user(s)",usercounter);
	} // else
} // main

// Scan for usernames
int scanforusers()
{
  char objectName[48], searchName[48];
  NWOBJ_TYPE objectType;
  NWFLAGS objectFlag, objectSecurity, objectHasProperties;
  NWOBJ_ID objectID = -1;
  int counter=0;

  while (!(NWScanObject(connHandle,searchObjectName,OT_USER,&objectID,
	objectName,&objectType,&objectHasProperties,&objectFlag,&objectSecurity)))
	  strcpy(userlist[counter++].username,objectName);
  return(counter);
} // scanforusers

// get information on a server and print the heading
int getserverinfo()
{  WORD nwrc;
   char volName[48]; 
   NWSERVICE_VERSION majorVersion, minorVersion, revision;
   NWNUMBER maxConnections, maxConnectionsUsed, connectionsInUse, numVolumes;
   NWSUPPORT_LEVEL SFTLevel, TTSLevel;
   NWVOL_NUM volNum=0;
   int loop, volcounter=0;
   NWOBJ_ID objectID;
   NWDISK_SPACE restriction, inUse;

   nwrc = (NWGetFileServerName(connHandle,(char NWFAR *)&serverName));
   if (nwrc == 0x8801)
   { printf("\nNWGetFileServerName failed: Invalid Connection");
	 exit(1);
   }

   nwrc = NWGetFileServerInformation(connHandle, (char NWFAR *)&serverName,
   (NWSERVICE_VERSION NWFAR *)&majorVersion,(NWSERVICE_VERSION NWFAR *)&minorVersion,
   (NWSERVICE_VERSION NWFAR *)&revision,(NWNUMBER NWFAR *)&maxConnections,
   (NWNUMBER NWFAR *)&maxConnectionsUsed,(NWNUMBER NWFAR *)&connectionsInUse,
   (NWNUMBER NWFAR *)&numVolumes, (NWSUPPORT_LEVEL NWFAR *)&SFTLevel,(NWSUPPORT_LEVEL NWFAR *)&TTSLevel);

   for (loop=0;loop<numVolumes;loop++)
   {  nwrc =  NWGetVolumeName(connHandle, loop, (char NWFAR *)&volName);
	  if ((nwrc != 0x89FF) && (strlen(volName) > 0))
	  { strcpy(volinfo[loop].volname,volName);
		volcounter++;
	  } // if
   } // for
   printf("Server: %s",serverName);
   printf("\n\n  USER\t\t  ");
   for (loop=0;loop<volcounter;loop++)
	 printf("%-10s",volinfo[loop].volname);
   printf("\n--------\t");
   for (loop=0;loop<volcounter;loop++)
	 printf("-------  ");
   return(volcounter);
} // get server info and print heading

// find the space used by the user. . .
void getspaceused(char *tempname[48],int volcounter, int usernum)
{  char username[48], serverName[48], volName[48], space2[48];
   WORD nwrc;
   NWVOL_NUM volNum=0;
   int loop;
   NWOBJ_ID objectID;
   NWDISK_SPACE restriction, inUse;

   NWGetObjectID(connHandle, tempname, OT_USER, (NWOBJ_ID NWFAR *)&objectID);
   for (loop=0;loop<volcounter;loop++)
   {  nwrc = NWGetObjDiskRestrictions(connHandle, loop, objectID,
			 (NWDISK_SPACE NWFAR *)&restriction, (NWDISK_SPACE NWFAR *)&inUse);
	  if (nwrc == 0x0000)
		{  userlist[usernum].volinfo[loop].spaceused = (unsigned long int) inUse * 4;
//		   printf("\nUSERNUM = %d",usernum);
//		   printf("\t%s\t%lu",tempname,userlist[usernum].volinfo[loop].spaceused);
		}
	  else
		printf("\nnwrc = %04x\t\tID: %lx",nwrc,objectID);
   } // for
} // getspaceused

// qsort the output
void sortoutput(int numusers,int numvols)
{
   int  loop, loop2;

   printf("\n\n");
   qsort((void *)userlist, numusers, sizeof(userlist[0].username), sort_function);
   for (loop = 0; loop < numusers; loop++)
   {  printf("\n%-10s", userlist[loop].username);
	  for (loop2=0;loop2<numvols;loop2++)
		printf("\t%7lu",userlist[loop].volinfo[loop2].spaceused);
   }
   printf("\n%d users",numusers);
   return 0;
}

int sort_function( const void *a, const void *b)
{
   return( strcmp((char *)a,(char *)b) );
}


