#!/usr/bin/perl

#########################################################
#        Netware Server Stat Extension to MRTG          #
#                   Config Maker                        #
#                                                       #
#########################################################
# Written by James Drews (drews@engr.wisc.edu) on       #
# Version 1.30                                          #
#    URL:  http://www.engr.wisc.edu/~drews/mrtg/        #
# Updated by James Moore (jm@ufl.edu) on                #
#  1999/10/20: Added options for Cricket/RRDTool config #
#                files                                  #
#########################################################
# This program is freeware.  *NO* warranty is expressed,#
# implied, nor granted to you in any way.  Use of this  #
# program is at your own risk.  Your mileage may vary.  #
# This program was packed by weight, not by volume.     #
# Some settling may have occurred during shipment.      #
#########################################################

# if you load the NLM with a different port
# from the default, here is where you change it
$port = 9999;

# the directory where you have the nwstat perl script
# is defined below. Please change it to where your
# copy lives
$nwstat = "/usr/local/mrtg/bin/nwstat.pl";

# Required for perl5.
use Socket;

$configtype = "";

if (! $ARGV[0]) { &PrintUsage }
	
else {
	while ($ARGV[0] =~ /^\-/) {
		if ($ARGV[0] eq '-c')	{ shift @ARGV ; $configtype = "cricket"; }
		elsif ($ARGV[0] eq '-m')	{ shift @ARGV ; $configtype = "mrtg"; }
		elsif ($ARGV[0] eq '-h')	{ &PrintUsage; }
		else { print STDERR "Unknown option: $ARGV[0]\n"; &PrintUsage; }
	}
}

$hostname = $ARGV[0];

# Open a socket and get the data
($sockaddr,$there,$response,$tries) = ("Snc4x8");
# On Win95, passing a numeric IP address to inet_aton() is slow, so
# detect this case and use a simple conversion.  
if ($hostname =~  /^\d+\.\d+\.\d+\.\d+(.*)/ ) {
	$remote_addr = pack("C4",split /\./, $hostname);
}
else {
	$remote_addr = (gethostbyname($hostname))[4] || die "host $hostname not found";
}
  
my $sockaddr_in = 'S n a4 x8';
$there = pack($sockaddr_in, AF_INET, $port, $remote_addr);
$proto = (getprotobyname ('tcp'))[2];

if (!socket(S,AF_INET,SOCK_STREAM,$proto)) { die "$0:  Fatal Error.  $!\n"; }
if (!connect(S,$there)) { die "$0:  Fatal Error.  can't connect $!\n"; }
select(S);$|=1;
select(STDOUT);

if ($configtype eq "mrtg") { &mrtg; }
else { &cricket; }

exit(0);

###### End of main program ########

sub mrtg {

# Get the server name, license count and volume names
  print S "name license s2 volumes\r\n";
	
  $server_name = <S>;
  $server_name =~ s/\W//;

  $license = int(<S>);
  $totcachebuf = int(<S>);

  $itemcount = 1;

  # do a graph for server utilization (5 and 15 minute)
  print "Title[$server_name.$itemcount]: Server Utilization\n";
  print "Target[$server_name.$itemcount]: `$nwstat $hostname util5 util15`\n";
  print "Options[$server_name.$itemcount]: growright, gauge\n";
  print "MaxBytes[$server_name.$itemcount]: 100\n";
  print "YLegend[$server_name.$itemcount]: Utilization\n";
  print "ShortLEgend[$server_name.$itemcount]: %\n";
  print "Legend1[$server_name.$itemcount]: 5 min\n";
  print "Legend2[$server_name.$itemcount]: 15 min\n";
  print "Legend3[$server_name.$itemcount]: 5 min peak\n";
  print "Legend4[$server_name.$itemcount]: 15 min peak\n";
  print "LegendI[$server_name.$itemcount]: &nbsp;5min:\n";
  print "LegendO[$server_name.$itemcount]: &nbsp;15min:\n";
  print "PageTop[$server_name.$itemcount]: <H1>Server Utilization for $server_name</H1>\n";
  print "  <p> These graphs track the 5 minute and 15 minute server utilization\n";
  print "\n";

  $itemcount++;

  # do a graph for connection stats
  print "Title[$server_name.$itemcount]: Server Connectin Stats\n";
  print "Target[$server_name.$itemcount]: `$nwstat $hostname connect zero`\n";
  print "Options[$server_name.$itemcount]: growright, gauge\n";
  print "MaxBytes[$server_name.$itemcount]: $license\n";
  print "YLegend[$server_name.$itemcount]: Connections\n";
  print "ShortLEgend[$server_name.$itemcount]: &nbsp;\n";
  print "Legend1[$server_name.$itemcount]: In Use\n";
  print "Legend2[$server_name.$itemcount]: \n";
  print "Legend3[$server_name.$itemcount]: In Use Peak\n";
  print "Legend4[$server_name.$itemcount]: \n";
  print "LegendI[$server_name.$itemcount]: &nbsp;InUse:\n";
  print "LegendO[$server_name.$itemcount]: \n";
  print "PageTop[$server_name.$itemcount]: <H1>Server Connection Count for $server_name</H1>\n";
  print "  <p> These graphs track the number of logged in users on the server\n";
  print "\n";

  # now loop through all volumes
  while ($volume = <S>) {
	  $itemcount++;
	  $volume =~ s/\W//;
	  $volSize = &GetVolumeSize($volume);

	  print "Title[$server_name.$itemcount]: Disk Space Usage on $volume\n";
	  print "Target[$server_name.$itemcount]: `$nwstat $hostname vku$volume zero`\n";
	  print "Options[$server_name.$itemcount]: growright, gauge\n";
          print "kMG[$server_name.$itemcount]: ,M,G,T,P\n";
	  print "MaxBytes[$server_name.$itemcount]: $volSize\n";
	  print "YLegend[$server_name.$itemcount]: Space in use\n";
	  print "ShortLEgend[$server_name.$itemcount]: bytes\n";
	  print "Legend1[$server_name.$itemcount]: $volume\n";
	  print "Legend2[$server_name.$itemcount]: \n";
	  print "Legend3[$server_name.$itemcount]: $volume Peak\n";
	  print "Legend4[$server_name.$itemcount]: \n";
	  print "LegendI[$server_name.$itemcount]: &nbsp;$volume:\n";
	  print "LegendO[$server_name.$itemcount]: \n";
	  print "PageTop[$server_name.$itemcount]: <H1>Disk space stats for $server_name\\$volume </H1>\n";
	  print "  <p> These graphs track disk space usage on $volume\n";
	  print "\n";
	}

  # 
  # now do a graph for LRU sitting time
  #
  $itemcount++;
  print "Title[$server_name.$itemcount]: Cache LRU Sitting Time Stats\n";
  print "Target[$server_name.$itemcount]: `$nwstat $hostname S5 zero`\n";
  print "MaxBytes[$server_name.$itemcount]: 36863\n";  #Use some large number
  print "Options[$server_name.$itemcount]: gauge\n";
  print "YLegend[$server_name.$itemcount]: LRU in Minutes\n";
  print "ShortLEgend[$server_name.$itemcount]: minutes;\n";
  print "Legend1[$server_name.$itemcount]: LRU Sitting Time\n";
  print "Legend2[$server_name.$itemcount]: \n";
  print "Legend3[$server_name.$itemcount]: Peak LRU Sitting Time\n";
  print "Legend4[$server_name.$itemcount]: \n";
  print "LegendI[$server_name.$itemcount]: &nbsp; LRU Time: &nbsp;\n";
  print "LegendO[$server_name.$itemcount]: \n";
  print "PageTop[$server_name.$itemcount]: <H1>LRU Sitting time for $server_name</H1>\n";
  print "  <p> These graphs track the Least Requested Unit (LRU) Sitting time in \n";
  print "  the server's disk cache.\n";
  print "\n";

  #
  # Now do a graph for Number Dirty Cache Buffers
  #
  $itemcount++;
  print "Title[$server_name.$itemcount]: Cache Dirty Buffer Count Stats\n";
  print "Target[$server_name.$itemcount]: `$nwstat $hostname S3 zero`\n";
  print "MaxBytes[$server_name.$itemcount]: $totcachebuf\n";  #Use some large number
  print "Options[$server_name.$itemcount]: gauge\n";
  print "YLegend[$server_name.$itemcount]: Dirty Cache Buffers\n";
  print "ShortLEgend[$server_name.$itemcount]: &nbsp;\n";
  print "Legend1[$server_name.$itemcount]: Cache Dirty Buffer Count\n";
  print "Legend2[$server_name.$itemcount]: \n";
  print "Legend3[$server_name.$itemcount]: Peak Cache Dirty Buffer Count\n";
  print "Legend4[$server_name.$itemcount]: \n";
  print "LegendI[$server_name.$itemcount]: &nbsp; DirtyBuffers: &nbsp;\n";
  print "LegendO[$server_name.$itemcount]: \n";
  print "PageTop[$server_name.$itemcount]: <H1>Cache Dirty Buffer count for $server_name</H1>\n";
  print "  <p> These graphs track the number of buffers in the file server disk cache \n";
  print "  that are waiting to be written out to disk.\n";
  print "\n";

  #
  # Now do a graph for Cache Hit Percentage
  #
  $itemcount++;
  print "Title[$server_name.$itemcount]: Cache Hit Percentage Stats\n";
  print "Target[$server_name.$itemcount]: `$nwstat $hostname S1 zero`\n";
  print "MaxBytes[$server_name.$itemcount]: 100\n";
  print "Options[$server_name.$itemcount]: gauge\n";
  print "YLegend[$server_name.$itemcount]: Hit Rate\n";
  print "ShortLEgend[$server_name.$itemcount]: %\n";
  print "Legend1[$server_name.$itemcount]: Cache Hit Rate\n";
  print "Legend2[$server_name.$itemcount]: \n";
  print "Legend3[$server_name.$itemcount]: Peak Cache Hit Rate\n";
  print "Legend4[$server_name.$itemcount]: \n";
  print "LegendI[$server_name.$itemcount]: &nbsp; HitRate: &nbsp;\n";
  print "LegendO[$server_name.$itemcount]: \n";
  print "PageTop[$server_name.$itemcount]: <H1>Cache Hit Rate for $server_name</H1>\n";
  print "  <p> These graphs track the long term cache hit rate for the server disk \n";
  print "  cache.\n";
  print "\n";

close(S);

}

sub cricket {
  print S "name volumes\r\n";

  $server_name = <S>;
  $server_name =~ s/\W//;

  # print header for config file
  print "target --default--\n";
  print "\tnovell-server = $hostname\n\n";

  # do a graph for server utilization (5 and 15 minute)
  print "target cpu\n";
  print "\ttarget-type = cpu\n\n";

  # do a graph for connection stats
  print "target connections\n";
  print "\ttarget-type = connections\n\n";

  # print cache and buffer stuff
  print "target cache-hit\n";
  print "\ttarget-type = cachehit\n\n";
  print "target buffers\n";
  print "\ttarget-type = buffers\n\n";
  print "target cachelru\n";
  print "\ttarget-type = cachelru\n\n";

  # now loop through all volumes
  while ($volume = <S>) {

	  $volume =~ s/\W//;

	  print "target $volume\n";
  	print "\ttarget-type = volume\n";
	  print "\tvolume = $volume\n";
	  print "\tshort-desc = \"Free space on $volume\"\n";
	  print "\n";
	}
	close(S);
}

sub GetVolumeSize {
  # get the size of a volume
  local ($volName) = @_;

  my $sockaddr_in = 'S n a4 x8';
  $there = pack($sockaddr_in, AF_INET, $port, $remote_addr);
  $proto = (getprotobyname ('tcp'))[2];
  if (!socket(SO,AF_INET,SOCK_STREAM,$proto)) { die "$0:  Fatal Error.  $!\n"; }
  if (!connect(SO,$there)) { die "$0:  Fatal Error.  can't connect $!\n"; }
  select(SO);$|=1;
  select(STDOUT);

  print SO "vks$volName\r\n";

  $size = int(<SO>);
  close(SO);
 
  return ($size); 

}

sub PrintUsage {
	print "\nUSAGE: $0 [-cmh] HOST \n";
	print "HOST is the DNS name or IP number of the server to create a config file for\n";
	print "Options:\n";
	print "\t-c\tproduce a config file suitable for Cricket/RRDTool\n";
	print "\t-m\tproduce a config file suitable for MRTG\n";
	print "\t-h\tprint this text\n";
	print "\n";
	exit(1);
}
